/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk;

import android.app.Application;
import android.content.Context;
import android.os.AsyncTask;
import android.preference.PreferenceManager;
import android.util.Log;
import io.scanbot.sap.IScanbotSDKLicenseErrorHandler;
import io.scanbot.sap.SapManager;
import io.scanbot.sap.SdkLicenseInfo;
import io.scanbot.sdk.ScanbotSDK;
import io.scanbot.sdk.a.a;
import io.scanbot.sdk.persistence.PageStorageSettings;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.doo.snap.blob.BlobFactory;
import net.doo.snap.blob.BlobManager;
import net.doo.snap.entity.Blob;
import net.doo.snap.injection.k;
import net.doo.snap.intelligence.OcrSettings;
import net.doo.snap.persistence.cleanup.UnreferencedSourcesProvider;
import net.doo.snap.process.draft.DocumentDraftExtractor;
import net.doo.snap.security.SapSingleton;
import net.doo.snap.util.log.DebugLog;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;
import net.doo.snap.util.log.StubLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 42\u00020\u0001:\u000245B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010 \u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004J\u0016\u0010!\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\"J\b\u0010#\u001a\u00020$H\u0002J\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010%\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020\"J\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0006J\u0010\u0010&\u001a\u00020$2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0006J\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\u0006J\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0006J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0006J\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0006J\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0006J\u0016\u0010(\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020)J\u000e\u0010*\u001a\u00020\u00002\u0006\u0010+\u001a\u00020,J\u000e\u0010-\u001a\u00020\u00002\u0006\u0010.\u001a\u00020/J\u000e\u00100\u001a\u00020\u00002\u0006\u00101\u001a\u000202J\u000e\u00103\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0006R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u00020\u0006X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u00066"}, d2={"Lio/scanbot/sdk/ScanbotSDKInitializer;", "", "()V", "licenseErrorHandler", "Lio/scanbot/sap/IScanbotSDKLicenseErrorHandler;", "licenseSet", "", "logger", "Lnet/doo/snap/util/log/Logger;", "getLogger", "()Lnet/doo/snap/util/log/Logger;", "setLogger", "(Lnet/doo/snap/util/log/Logger;)V", "prepareBarcodeScannerBlobs", "prepareChequeBlobs", "prepareDcBlobs", "prepareFilterPredictionBlobs", "prepareMRZBlobs", "prepareOCRLanguagesBlobs", "preparePayFormBlobs", "useLog", "getUseLog", "()Z", "setUseLog", "(Z)V", "documentDraftExtractor", "extractor", "Lnet/doo/snap/process/draft/DocumentDraftExtractor;", "initialize", "Lio/scanbot/sap/SdkLicenseInfo;", "application", "Landroid/app/Application;", "licenceErrorHandler", "license", "", "loadNativeLibraries", "", "ocrBlobsPath", "prepareBlobs", "prepareDcScannerBlobs", "sdkFilesDirectory", "Ljava/io/File;", "unreferencedSourcesProvider", "provider", "Lnet/doo/snap/persistence/cleanup/UnreferencedSourcesProvider;", "useOcrSettings", "ocrSettings", "Lnet/doo/snap/intelligence/OcrSettings;", "usePageStorageSettings", "pageStorageSettings", "Lio/scanbot/sdk/persistence/PageStorageSettings;", "withLogging", "Companion", "PrepareBlobsTask", "sdk-bundle_release"})
public final class ScanbotSDKInitializer {
    private boolean useLog;
    @Nullable
    private Logger logger;
    private boolean licenseSet;
    private boolean prepareOCRLanguagesBlobs;
    private boolean prepareMRZBlobs;
    private boolean prepareChequeBlobs;
    private boolean preparePayFormBlobs;
    private boolean prepareFilterPredictionBlobs;
    private boolean prepareDcBlobs;
    private boolean prepareBarcodeScannerBlobs;
    private IScanbotSDKLicenseErrorHandler licenseErrorHandler;
    private static boolean initialized;
    public static final Companion Companion;

    protected final boolean getUseLog() {
        return this.useLog;
    }

    protected final void setUseLog(boolean bl) {
        this.useLog = bl;
    }

    @Nullable
    protected final Logger getLogger() {
        return this.logger;
    }

    protected final void setLogger(@Nullable Logger logger) {
        this.logger = logger;
    }

    @NotNull
    public final ScanbotSDKInitializer withLogging(boolean useLog) {
        if (useLog) {
            Log.w((String)"Scanbot SDK", (String)"Logging enabled in non-debug build, consider switching it off");
        }
        this.useLog = useLog;
        if (!useLog) {
            this.logger = (Logger)new StubLogger();
        }
        return this;
    }

    @NotNull
    public final ScanbotSDKInitializer license(@NotNull Application application, @NotNull String license) {
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
        Intrinsics.checkParameterIsNotNull((Object)license, (String)"license");
        PreferenceManager.getDefaultSharedPreferences((Context)((Context)application)).edit().putString("SCANBOT_SDK_LICENSE_KEY", license).apply();
        this.licenseSet = true;
        return this;
    }

    @NotNull
    public final ScanbotSDKInitializer licenceErrorHandler(@NotNull IScanbotSDKLicenseErrorHandler licenseErrorHandler) {
        Intrinsics.checkParameterIsNotNull((Object)licenseErrorHandler, (String)"licenseErrorHandler");
        this.licenseErrorHandler = licenseErrorHandler;
        return this;
    }

    @NotNull
    public final ScanbotSDKInitializer ocrBlobsPath(@NotNull Application application, @NotNull String ocrBlobsPath) {
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
        Intrinsics.checkParameterIsNotNull((Object)ocrBlobsPath, (String)"ocrBlobsPath");
        PreferenceManager.getDefaultSharedPreferences((Context)((Context)application)).edit().putString("SCANBOT_SDK_OCR_BLOBS_PATH", ocrBlobsPath).apply();
        return this;
    }

    @NotNull
    public final ScanbotSDKInitializer prepareOCRLanguagesBlobs(boolean prepareOCRLanguagesBlobs) {
        this.prepareOCRLanguagesBlobs = prepareOCRLanguagesBlobs;
        return this;
    }

    @NotNull
    public final ScanbotSDKInitializer useOcrSettings(@NotNull OcrSettings ocrSettings) {
        Intrinsics.checkParameterIsNotNull((Object)ocrSettings, (String)"ocrSettings");
        k.c = ocrSettings;
        return this;
    }

    @NotNull
    public final ScanbotSDKInitializer prepareMRZBlobs(boolean prepareMRZBlobs) {
        this.prepareMRZBlobs = prepareMRZBlobs;
        return this;
    }

    @NotNull
    public final ScanbotSDKInitializer prepareChequeBlobs(boolean prepareChequeBlobs) {
        this.prepareChequeBlobs = prepareChequeBlobs;
        return this;
    }

    @NotNull
    public final ScanbotSDKInitializer preparePayFormBlobs(boolean preparePayFormBlobs) {
        this.preparePayFormBlobs = preparePayFormBlobs;
        return this;
    }

    @NotNull
    public final ScanbotSDKInitializer prepareFilterPredictionBlobs(boolean prepareFilterPredictionBlobs) {
        this.prepareFilterPredictionBlobs = prepareFilterPredictionBlobs;
        return this;
    }

    @NotNull
    public final ScanbotSDKInitializer prepareBarcodeScannerBlobs(boolean prepareBarcodeScannerBlobs) {
        this.prepareBarcodeScannerBlobs = prepareBarcodeScannerBlobs;
        return this;
    }

    @NotNull
    public final ScanbotSDKInitializer prepareDcBlobs(boolean prepareDcScannerBlobs) {
        this.prepareDcBlobs = prepareDcScannerBlobs;
        return this;
    }

    @NotNull
    public final SdkLicenseInfo initialize(@NotNull Application application) {
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
        LoggerProvider.setLogger((Logger)(this.logger == null ? (this.useLog ? (Logger)new DebugLog((Context)application) : (Logger)new StubLogger()) : this.logger));
        if (!this.licenseSet) {
            PreferenceManager.getDefaultSharedPreferences((Context)((Context)application)).edit().remove("SCANBOT_SDK_LICENSE_KEY").apply();
        }
        this.loadNativeLibraries();
        SapSingleton.initializeSapManager((Context)((Context)application));
        SapManager sapManager = SapSingleton.getInstance();
        if (this.licenseErrorHandler != null) {
            sapManager.setLicenceErrorHandler(this.licenseErrorHandler);
        }
        initialized = true;
        this.prepareBlobs(application);
        SapManager sapManager2 = sapManager;
        Intrinsics.checkExpressionValueIsNotNull((Object)sapManager2, (String)"sapManager");
        SdkLicenseInfo sdkLicenseInfo = sapManager2.getLicenseStatus();
        String string2 = "ScanbotSDK license status : " + sdkLicenseInfo.getStatus().name();
        LoggerProvider.getLogger().i("ScanbotSDKInitializer", string2);
        SdkLicenseInfo sdkLicenseInfo2 = sdkLicenseInfo;
        Intrinsics.checkExpressionValueIsNotNull((Object)sdkLicenseInfo2, (String)"licenseStatus");
        return sdkLicenseInfo2;
    }

    private final void loadNativeLibraries() {
        System.loadLibrary("jpgt");
        System.loadLibrary("lept");
        System.loadLibrary("tess");
        System.loadLibrary("tflite");
        System.loadLibrary("scanbotsdk");
    }

    private final void prepareBlobs(Application application) {
        new PrepareBlobsTask(application, this.prepareOCRLanguagesBlobs, this.prepareMRZBlobs, this.prepareChequeBlobs, this.preparePayFormBlobs, this.prepareBarcodeScannerBlobs).executeOnExecutor(AsyncTask.SERIAL_EXECUTOR, new Void[0]);
    }

    @NotNull
    public final ScanbotSDKInitializer documentDraftExtractor(@NotNull DocumentDraftExtractor extractor) {
        Intrinsics.checkParameterIsNotNull((Object)extractor, (String)"extractor");
        k.a = extractor;
        return this;
    }

    @NotNull
    public final ScanbotSDKInitializer unreferencedSourcesProvider(@NotNull UnreferencedSourcesProvider provider) {
        Intrinsics.checkParameterIsNotNull((Object)provider, (String)"provider");
        k.b = provider;
        return this;
    }

    @NotNull
    public final ScanbotSDKInitializer sdkFilesDirectory(@NotNull Application application, @NotNull File sdkFilesDirectory) {
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
        Intrinsics.checkParameterIsNotNull((Object)sdkFilesDirectory, (String)"sdkFilesDirectory");
        PreferenceManager.getDefaultSharedPreferences((Context)((Context)application)).edit().putString("CUSTOM_SDK_FILES_PATH", sdkFilesDirectory.getPath()).apply();
        return this;
    }

    @NotNull
    public final ScanbotSDKInitializer logger(@NotNull Logger logger) {
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        this.logger = logger;
        return this;
    }

    @NotNull
    public final ScanbotSDKInitializer usePageStorageSettings(@NotNull PageStorageSettings pageStorageSettings) {
        Intrinsics.checkParameterIsNotNull((Object)pageStorageSettings, (String)"pageStorageSettings");
        a.a.a(pageStorageSettings);
        return this;
    }

    static {
        Companion = new Companion(null);
    }

    public static final /* synthetic */ void access$setPrepareFilterPredictionBlobs$p(ScanbotSDKInitializer $this, boolean bl) {
        $this.prepareFilterPredictionBlobs = bl;
    }

    public static final /* synthetic */ void access$setPrepareDcBlobs$p(ScanbotSDKInitializer $this, boolean bl) {
        $this.prepareDcBlobs = bl;
    }

    public static final /* synthetic */ void access$setInitialized$cp(boolean bl) {
        initialized = bl;
    }

    @JvmStatic
    public static final boolean isInitialized() {
        return Companion.isInitialized();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001B5\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\u0006\u0010\n\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u000bJ'\u0010\u0014\u001a\u0004\u0018\u00010\u00022\u0016\u0010\u0015\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00020\u0016\"\u0004\u0018\u00010\u0002H\u0014\u00a2\u0006\u0002\u0010\u0017J\u001e\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\n\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000f\u00a8\u0006\u001f"}, d2={"Lio/scanbot/sdk/ScanbotSDKInitializer$PrepareBlobsTask;", "Landroid/os/AsyncTask;", "Ljava/lang/Void;", "application", "Landroid/app/Application;", "prepareOCRLanguagesBlobs", "", "prepareMRZBlobs", "prepareChequeBlobs", "preparePayFormBlobs", "prepareBarcodeScannerBlobs", "(Lio/scanbot/sdk/ScanbotSDKInitializer;Landroid/app/Application;ZZZZZ)V", "getApplication", "()Landroid/app/Application;", "getPrepareBarcodeScannerBlobs", "()Z", "getPrepareChequeBlobs", "getPrepareMRZBlobs", "getPrepareOCRLanguagesBlobs", "getPreparePayFormBlobs", "doInBackground", "params", "", "([Ljava/lang/Void;)Ljava/lang/Void;", "fetchBlobs", "", "blobs", "", "Lnet/doo/snap/entity/Blob;", "blobManager", "Lnet/doo/snap/blob/BlobManager;", "sdk-bundle_release"})
    public final class PrepareBlobsTask
    extends AsyncTask<Void, Void, Void> {
        @NotNull
        private final Application application;
        private final boolean prepareOCRLanguagesBlobs;
        private final boolean prepareMRZBlobs;
        private final boolean prepareChequeBlobs;
        private final boolean preparePayFormBlobs;
        private final boolean prepareBarcodeScannerBlobs;

        @Nullable
        protected final Void doInBackground(Void ... params) {
            Collection collection;
            Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
            ScanbotSDK scanbotSDK = new ScanbotSDK(this.application);
            BlobManager blobManager = scanbotSDK.blobManager();
            BlobFactory blobFactory = scanbotSDK.blobFactory();
            Logger logger = LoggerProvider.getLogger();
            if (this.prepareOCRLanguagesBlobs) {
                collection = new ArrayList();
                try {
                    Collection collection2 = blobFactory.ocrLanguageBlobs();
                    Intrinsics.checkExpressionValueIsNotNull((Object)collection2, (String)"blobFactory.ocrLanguageBlobs()");
                    collection.addAll(collection2);
                }
                catch (IOException iOException) {
                    logger.logException((Throwable)iOException);
                    logger.e("PrepareBlobsTask", "Could not fetch OCR blobs!");
                }
                this.fetchBlobs(collection, blobManager);
            }
            if (this.prepareMRZBlobs) {
                collection = new ArrayList();
                try {
                    Blob blob = blobFactory.mrzTraineddataBlob();
                    Intrinsics.checkExpressionValueIsNotNull((Object)blob, (String)"blobFactory.mrzTraineddataBlob()");
                    collection.add(blob);
                    Blob blob2 = blobFactory.mrzCascadeBlob();
                    Intrinsics.checkExpressionValueIsNotNull((Object)blob2, (String)"blobFactory.mrzCascadeBlob()");
                    collection.add(blob2);
                }
                catch (IOException iOException) {
                    logger.logException((Throwable)iOException);
                    logger.e("PrepareBlobsTask", "Could not fetch MRZ scanner blobs!");
                }
                this.fetchBlobs(collection, blobManager);
            }
            if (this.prepareChequeBlobs) {
                collection = new ArrayList();
                try {
                    Blob blob = blobFactory.chequeDigitRecognitionModelBlob();
                    Intrinsics.checkExpressionValueIsNotNull((Object)blob, (String)"blobFactory.chequeDigitRecognitionModelBlob()");
                    collection.add(blob);
                }
                catch (IOException iOException) {
                    logger.logException((Throwable)iOException);
                    logger.e("PrepareBlobsTask", "Could not fetch Cheque Digit Recognition Model blob!");
                }
                this.fetchBlobs(collection, blobManager);
            }
            if (this.preparePayFormBlobs) {
                collection = new ArrayList();
                try {
                    Blob blob = blobFactory.bankDataBlob();
                    Intrinsics.checkExpressionValueIsNotNull((Object)blob, (String)"blobFactory.bankDataBlob()");
                    collection.add(blob);
                }
                catch (IOException iOException) {
                    logger.logException((Throwable)iOException);
                    logger.e("PrepareBlobsTask", "Could not fetch Pay Form Bank Data blob!");
                }
                this.fetchBlobs(collection, blobManager);
            }
            if (this.prepareBarcodeScannerBlobs) {
                collection = new ArrayList();
                try {
                    Blob blob = blobFactory.barcodeScannerModelBlob();
                    Intrinsics.checkExpressionValueIsNotNull((Object)blob, (String)"blobFactory.barcodeScannerModelBlob()");
                    collection.add(blob);
                }
                catch (IOException iOException) {
                    logger.logException((Throwable)iOException);
                    logger.e("PrepareBlobsTask", "Could not fetch Barcode Scanner Model blob!");
                }
                this.fetchBlobs(collection, blobManager);
            }
            if (ScanbotSDKInitializer.this.prepareFilterPredictionBlobs) {
                collection = new ArrayList();
                try {
                    Blob blob = blobFactory.filterPredictionModelBlob();
                    Intrinsics.checkExpressionValueIsNotNull((Object)blob, (String)"blobFactory.filterPredictionModelBlob()");
                    collection.add(blob);
                }
                catch (IOException iOException) {
                    logger.logException((Throwable)iOException);
                    logger.e("PrepareBlobsTask", "Could not fetch Filter Prediction Model blob!");
                }
                this.fetchBlobs(collection, blobManager);
            }
            if (ScanbotSDKInitializer.this.prepareDcBlobs) {
                collection = new ArrayList();
                try {
                    Collection collection3 = blobFactory.dcFormModelsBlobs();
                    Intrinsics.checkExpressionValueIsNotNull((Object)collection3, (String)"blobFactory.dcFormModelsBlobs()");
                    collection.addAll(collection3);
                }
                catch (IOException iOException) {
                    logger.logException((Throwable)iOException);
                    logger.e("PrepareBlobsTask", "Could not fetch DC Model blobs!");
                }
                this.fetchBlobs(collection, blobManager);
            }
            return null;
        }

        private final void fetchBlobs(Collection<Blob> blobs, BlobManager blobManager) {
            Logger logger = LoggerProvider.getLogger();
            for (Blob blob : blobs) {
                if (blobManager.isBlobAvailable(blob)) continue;
                try {
                    blobManager.fetch(blob);
                }
                catch (IOException iOException) {
                    logger.logException((Throwable)iOException);
                    logger.e("PrepareBlobsTask", "Could not fetch blob! /n Blob local path: " + blob.getLocalPath() + " /n Blob remote path: " + blob.getRemotePath());
                }
            }
        }

        @NotNull
        public final Application getApplication() {
            return this.application;
        }

        public final boolean getPrepareOCRLanguagesBlobs() {
            return this.prepareOCRLanguagesBlobs;
        }

        public final boolean getPrepareMRZBlobs() {
            return this.prepareMRZBlobs;
        }

        public final boolean getPrepareChequeBlobs() {
            return this.prepareChequeBlobs;
        }

        public final boolean getPreparePayFormBlobs() {
            return this.preparePayFormBlobs;
        }

        public final boolean getPrepareBarcodeScannerBlobs() {
            return this.prepareBarcodeScannerBlobs;
        }

        public PrepareBlobsTask(@NotNull Application application, boolean prepareOCRLanguagesBlobs, boolean prepareMRZBlobs, boolean prepareChequeBlobs, boolean preparePayFormBlobs, boolean prepareBarcodeScannerBlobs) {
            Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
            this.application = application;
            this.prepareOCRLanguagesBlobs = prepareOCRLanguagesBlobs;
            this.prepareMRZBlobs = prepareMRZBlobs;
            this.prepareChequeBlobs = prepareChequeBlobs;
            this.preparePayFormBlobs = preparePayFormBlobs;
            this.prepareBarcodeScannerBlobs = prepareBarcodeScannerBlobs;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/scanbot/sdk/ScanbotSDKInitializer$Companion;", "", "()V", "initialized", "", "isInitialized", "sdk-bundle_release"})
    public static final class Companion {
        @JvmStatic
        public final boolean isInitialized() {
            return initialized;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

