/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ocr;

import android.net.Uri;
import androidx.core.net.UriKt;
import io.scanbot.sdk.ocr.OpticalCharacterRecognizer;
import io.scanbot.sdk.ocr.a;
import io.scanbot.sdk.persistence.Page;
import io.scanbot.sdk.persistence.PageFileStorage;
import io.scanbot.sdk.process.PDFPageSize;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import net.doo.snap.blob.BlobManager;
import net.doo.snap.entity.Document;
import net.doo.snap.entity.Language;
import net.doo.snap.entity.OcrStatus;
import net.doo.snap.persistence.PageFactory;
import net.doo.snap.process.OcrResult;
import net.doo.snap.process.TextRecognition;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0002J$\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J$\u0010\u001a\u001a\u00020\u00162\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00182\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J,\u0010\u001d\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J,\u0010 \u001a\u00020\u00162\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00182\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lio/scanbot/sdk/ocr/ScanbotOpticalCharacterRecognizer;", "Lio/scanbot/sdk/ocr/OpticalCharacterRecognizer;", "textRecognition", "Lnet/doo/snap/process/TextRecognition;", "pageFactory", "Lnet/doo/snap/persistence/PageFactory;", "blobManager", "Lnet/doo/snap/blob/BlobManager;", "pageFileStorage", "Lio/scanbot/sdk/persistence/PageFileStorage;", "(Lnet/doo/snap/process/TextRecognition;Lnet/doo/snap/persistence/PageFactory;Lnet/doo/snap/blob/BlobManager;Lio/scanbot/sdk/persistence/PageFileStorage;)V", "checkMissingLangs", "", "languages", "", "Lnet/doo/snap/entity/Language;", "getInstalledLanguages", "getLanguageDataPath", "Ljava/io/File;", "getPendingDocument", "Lnet/doo/snap/entity/Document;", "recognizeTextFromPages", "Lnet/doo/snap/process/OcrResult;", "pages", "", "Lio/scanbot/sdk/persistence/Page;", "recognizeTextFromUris", "imageFileUris", "Landroid/net/Uri;", "recognizeTextWithPdfFromPages", "pageSize", "Lio/scanbot/sdk/process/PDFPageSize;", "recognizeTextWithPdfFromUris", "sdk-bundle_release"})
public final class b
implements OpticalCharacterRecognizer {
    private final TextRecognition a;
    private final PageFactory b;
    private final BlobManager c;
    private final PageFileStorage d;

    @Override
    @NotNull
    public final OcrResult recognizeTextFromUris(@NotNull List<? extends Uri> imageFileUris, @NotNull Set<? extends Language> languages) {
        Collection<net.doo.snap.entity.Page> collection;
        Intrinsics.checkParameterIsNotNull(imageFileUris, (String)"imageFileUris");
        Intrinsics.checkParameterIsNotNull(languages, (String)"languages");
        this.a(languages);
        Iterable iterable = imageFileUris;
        TextRecognition textRecognition = this.a;
        Iterable iterable2 = iterable;
        Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        for (Object t2 : iterable2) {
            Uri uri = (Uri)t2;
            collection = collection2;
            net.doo.snap.entity.Page page = this.b.buildPage(UriKt.toFile((Uri)uri));
            collection.add(page);
        }
        collection = (List)collection2;
        OcrResult ocrResult = textRecognition.withoutPDF((List)collection, languages).recognize();
        Intrinsics.checkExpressionValueIsNotNull((Object)ocrResult, (String)"textRecognition.withoutP\u2026ges\n        ).recognize()");
        return ocrResult;
    }

    @Override
    @NotNull
    public final OcrResult recognizeTextFromPages(@NotNull List<Page> pages, @NotNull Set<? extends Language> languages) {
        Collection<net.doo.snap.entity.Page> collection;
        Intrinsics.checkParameterIsNotNull(pages, (String)"pages");
        Intrinsics.checkParameterIsNotNull(languages, (String)"languages");
        this.a(languages);
        Iterable iterable = pages;
        TextRecognition textRecognition = this.a;
        Iterable iterable2 = iterable;
        Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        for (Object t2 : iterable2) {
            Page page = (Page)t2;
            collection = collection2;
            net.doo.snap.entity.Page page2 = this.b.buildPage(page.getPageId(), new File(this.d.getImageURI(page.getPageId(), PageFileStorage.PageFileType.DOCUMENT).getPath()));
            Intrinsics.checkExpressionValueIsNotNull((Object)page2, (String)"oldPage");
            page2.setImageFilterType(page.getFilter());
            net.doo.snap.entity.Page page3 = page2;
            collection.add(page3);
        }
        collection = (List)collection2;
        OcrResult ocrResult = textRecognition.withoutPDF((List)collection, languages).recognize();
        Intrinsics.checkExpressionValueIsNotNull((Object)ocrResult, (String)"textRecognition.withoutP\u2026ges\n        ).recognize()");
        return ocrResult;
    }

    @Override
    @NotNull
    public final OcrResult recognizeTextWithPdfFromUris(@NotNull List<? extends Uri> imageFileUris, @NotNull PDFPageSize pageSize, @NotNull Set<? extends Language> languages) {
        Collection<net.doo.snap.entity.Page> collection;
        Intrinsics.checkParameterIsNotNull(imageFileUris, (String)"imageFileUris");
        Intrinsics.checkParameterIsNotNull((Object)pageSize, (String)"pageSize");
        Intrinsics.checkParameterIsNotNull(languages, (String)"languages");
        this.a(languages);
        Iterable iterable = imageFileUris;
        Document document = io.scanbot.sdk.ocr.b.a();
        TextRecognition textRecognition = this.a;
        Iterable iterable2 = iterable;
        Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        for (Object t2 : iterable2) {
            Uri uri = (Uri)t2;
            collection = collection2;
            net.doo.snap.entity.Page page = this.b.buildPage(UriKt.toFile((Uri)uri));
            Intrinsics.checkExpressionValueIsNotNull((Object)page, (String)"oldPage");
            page.setPageSize(pageSize);
            net.doo.snap.entity.Page page2 = page;
            collection.add(page2);
        }
        collection = (List)collection2;
        OcrResult ocrResult = textRecognition.withPDF(document, (List)collection, languages).recognize();
        Intrinsics.checkExpressionValueIsNotNull((Object)ocrResult, (String)"textRecognition.withPDF(\u2026ges\n        ).recognize()");
        return ocrResult;
    }

    @Override
    @NotNull
    public final OcrResult recognizeTextWithPdfFromPages(@NotNull List<Page> pages, @NotNull PDFPageSize pageSize, @NotNull Set<? extends Language> languages) {
        Collection<net.doo.snap.entity.Page> collection;
        Intrinsics.checkParameterIsNotNull(pages, (String)"pages");
        Intrinsics.checkParameterIsNotNull((Object)pageSize, (String)"pageSize");
        Intrinsics.checkParameterIsNotNull(languages, (String)"languages");
        this.a(languages);
        Iterable iterable = pages;
        Document document = io.scanbot.sdk.ocr.b.a();
        TextRecognition textRecognition = this.a;
        Iterable iterable2 = iterable;
        Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        for (Object t2 : iterable2) {
            Page page = (Page)t2;
            collection = collection2;
            net.doo.snap.entity.Page page2 = this.b.buildPage(page.getPageId(), new File(this.d.getImageURI(page.getPageId(), PageFileStorage.PageFileType.DOCUMENT).getPath()));
            Intrinsics.checkExpressionValueIsNotNull((Object)page2, (String)"oldPage");
            page2.setImageFilterType(page.getFilter());
            page2.setPolygon(page.getPolygon());
            page2.setPageSize(pageSize);
            net.doo.snap.entity.Page page3 = page2;
            collection.add(page3);
        }
        collection = (List)collection2;
        OcrResult ocrResult = textRecognition.withPDF(document, (List)collection, languages).recognize();
        Intrinsics.checkExpressionValueIsNotNull((Object)ocrResult, (String)"textRecognition.withPDF(\u2026ges\n        ).recognize()");
        return ocrResult;
    }

    @Override
    @NotNull
    public final File getLanguageDataPath() {
        File file = this.c.getOCRBlobsDirectory();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"blobManager.ocrBlobsDirectory");
        return file;
    }

    @Override
    @NotNull
    public final Set<Language> getInstalledLanguages() {
        Set set = this.c.getAllLanguagesWithAvailableOcrBlobs();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"blobManager.allLanguagesWithAvailableOcrBlobs");
        return set;
    }

    private static Document a() {
        Document document;
        Document document2 = document = new Document();
        document.setId(UUID.randomUUID().toString());
        document2.setName(document2.getId() + ".pdf");
        document2.setOcrStatus(OcrStatus.PENDING);
        return document;
    }

    private final void a(Set<? extends Language> set) {
        Set set2 = SetsKt.minus(set, (Iterable)this.getInstalledLanguages());
        if (!((Collection)set2).isEmpty()) {
            throw (Throwable)new a(set2 + " Provided set of languages was not presented on device");
        }
    }

    @Inject
    public b(@NotNull TextRecognition textRecognition, @NotNull PageFactory pageFactory, @NotNull BlobManager blobManager, @NotNull PageFileStorage pageFileStorage) {
        Intrinsics.checkParameterIsNotNull((Object)textRecognition, (String)"textRecognition");
        Intrinsics.checkParameterIsNotNull((Object)pageFactory, (String)"pageFactory");
        Intrinsics.checkParameterIsNotNull((Object)blobManager, (String)"blobManager");
        Intrinsics.checkParameterIsNotNull((Object)pageFileStorage, (String)"pageFileStorage");
        this.a = textRecognition;
        this.b = pageFactory;
        this.c = blobManager;
        this.d = pageFileStorage;
    }
}

