/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.mrzscanner;

import android.content.Context;
import io.scanbot.mrzscanner.model.MRZRecognitionResult;
import io.scanbot.sap.SapManager;
import io.scanbot.sap.SdkFeature;
import io.scanbot.sdk.SdkLicenseError;
import io.scanbot.sdk.camera.BaseResultHandler;
import io.scanbot.sdk.camera.FrameHandlerResult;
import java.util.LinkedHashSet;
import java.util.Set;
import net.doo.snap.camera.PreviewBuffer;
import net.doo.snap.camera.ScanbotCameraView;
import net.doo.snap.mrzscanner.MRZScanner;
import net.doo.snap.security.SapSingleton;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;

public class MRZScannerFrameHandler
implements PreviewBuffer.FrameHandler {
    private MRZScanner mrzScanner;
    private final Set<ResultHandler> handlers = new LinkedHashSet<ResultHandler>();
    protected final SapManager sapManager;
    private final Logger logger = LoggerProvider.getLogger();
    protected boolean enabled = true;

    public static MRZScannerFrameHandler attach(ScanbotCameraView cameraView, MRZScanner mrzScanner) {
        MRZScannerFrameHandler mRZScannerFrameHandler = new MRZScannerFrameHandler(cameraView.getContext(), mrzScanner);
        cameraView.getPreviewBuffer().addFrameHandler((PreviewBuffer.FrameHandler)mRZScannerFrameHandler);
        return mRZScannerFrameHandler;
    }

    public MRZScannerFrameHandler(Context context, MRZScanner mrzScanner) {
        this.mrzScanner = mrzScanner;
        this.sapManager = SapSingleton.getInstance();
    }

    public synchronized boolean handleFrame(PreviewBuffer.FrameHandler.Frame previewFrame) {
        this.logger.logMethod();
        if (!this.enabled) {
            return false;
        }
        if (!this.sapManager.checkLicenseStatus(SdkFeature.MRZRecognition).booleanValue()) {
            this.notifyHandlers((FrameHandlerResult<MRZRecognitionResult, SdkLicenseError>)new FrameHandlerResult.Failure((Object)new SdkLicenseError()));
            return false;
        }
        MRZRecognitionResult mRZRecognitionResult = previewFrame.finderRect == null ? this.mrzScanner.recognizeMRZ(previewFrame.frame, previewFrame.width, previewFrame.height, previewFrame.frameOrientation) : this.mrzScanner.recognizeMRZWithFinderOverlay(previewFrame.frame, previewFrame.width, previewFrame.height, previewFrame.frameOrientation, previewFrame.finderRect, false);
        return this.notifyHandlers((FrameHandlerResult<MRZRecognitionResult, SdkLicenseError>)new FrameHandlerResult.Success((Object)mRZRecognitionResult));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResultHandler(ResultHandler handler) {
        Set<ResultHandler> set = this.handlers;
        synchronized (set) {
            this.handlers.add(handler);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResultHandler(ResultHandler handler) {
        Set<ResultHandler> set = this.handlers;
        synchronized (set) {
            this.handlers.remove(handler);
            return;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean notifyHandlers(FrameHandlerResult<MRZRecognitionResult, SdkLicenseError> result) {
        boolean bl = false;
        Set<ResultHandler> set = this.handlers;
        synchronized (set) {
            for (ResultHandler resultHandler : this.handlers) {
                bl |= resultHandler.handle(result);
            }
        }
        return bl;
    }

    public static interface ResultHandler
    extends BaseResultHandler<MRZRecognitionResult, SdkLicenseError> {
    }
}

