/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.persistence.cleanup;

import android.util.Pair;
import io.scanbot.sdk.persistence.Page;
import io.scanbot.sdk.persistence.PageStorageProcessor;
import javax.inject.Inject;
import net.doo.snap.entity.Document;
import net.doo.snap.persistence.DocumentStoreStrategy;
import net.doo.snap.persistence.PageStoreStrategy;
import net.doo.snap.persistence.cleanup.UnreferencedSourcesProvider;
import net.doo.snap.process.g;
import net.doo.snap.process.util.DocumentDraft;

public class Cleaner {
    private final UnreferencedSourcesProvider a;
    private final PageStoreStrategy b;
    private final DocumentStoreStrategy c;
    private final g d;
    private final PageStorageProcessor e;

    @Inject
    public Cleaner(UnreferencedSourcesProvider unreferencedSourcesProvider, PageStoreStrategy pageStoreStrategy, DocumentStoreStrategy documentStoreStrategy, g processingInfoProvider, PageStorageProcessor pageStorageProcessor) {
        this.a = unreferencedSourcesProvider;
        this.b = pageStoreStrategy;
        this.c = documentStoreStrategy;
        this.d = processingInfoProvider;
        this.e = pageStorageProcessor;
    }

    public void cleanUp() {
        for (Pair<String, String> object : this.a.getUnreferencedDocuments()) {
            this.c.eraseDocument((String)object.first, (String)object.second);
        }
        for (String string2 : this.a.getUnreferencedSDKPages()) {
            this.b.erasePage(string2);
        }
        for (DocumentDraft documentDraft : this.d.b()) {
            this.cleanUpPagesData(documentDraft.getPages());
        }
    }

    public void cleanUpPagesData(net.doo.snap.entity.Page[] pages) {
        net.doo.snap.entity.Page[] pageArray = pages;
        int n2 = pages.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            net.doo.snap.entity.Page page = pageArray[i2];
            this.b.eraseTempPageData(page.getId());
        }
    }

    public void cleanUpPagesData(Page[] pages) {
        Page[] pageArray = pages;
        int n2 = pages.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Page page = pageArray[i2];
            this.e.erasePageData(page);
        }
    }

    public void cleanUpDocumentData(Document document) {
        this.c.eraseDocument(document.getId(), document.getName());
    }

    public void cleanUpDocumentThumbnail(Document document) {
        this.c.eraseDocumentThumbnail(document.getId());
    }
}

