/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.ui;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import net.doo.snap.R;
import net.doo.snap.ui.EditPolygonImageView;
import net.doo.snap.util.bitmap.BitmapUtils;

public class MagnifierView
extends View {
    private final float magnifierRaduis;
    private final float magnifierMargin;
    private final int magnifierDrawableResourceId;
    private a magnifier = new a();
    private PointF zoomPoint;
    private Bitmap magnifierFrameBitmap;
    private boolean enableBounding;

    public MagnifierView(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.fw, 0, 0);
        try {
            this.magnifierDrawableResourceId = typedArray.getResourceId(R.styleable.fy, 0);
            this.magnifierRaduis = typedArray.getDimension(R.styleable.fA, this.getResources().getDimension(R.dimen.bc));
            this.magnifierMargin = typedArray.getDimension(R.styleable.fz, this.getResources().getDimension(R.dimen.bb));
            this.enableBounding = typedArray.getBoolean(R.styleable.fx, true);
            return;
        }
        finally {
            typedArray.recycle();
        }
    }

    void drawMagnifier(PointF zoomPoint) {
        this.zoomPoint = zoomPoint;
        this.invalidate();
    }

    void eraseMagnifier() {
        this.zoomPoint = null;
        this.invalidate();
    }

    public void setImageRotation(float rotation) {
        this.magnifier.a(rotation);
        this.invalidate();
    }

    public void setupMagnifier(EditPolygonImageView view) {
        Bitmap bitmap = BitmapUtils.drawableToBitmap((Drawable)view.getDrawable());
        this.magnifier.a(bitmap, view.getRotation());
        view.setMagnifier(this);
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        if (this.zoomPoint != null) {
            this.magnifier.a(canvas, this.zoomPoint);
            return;
        }
        canvas.drawColor(0);
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        BitmapFactory.Options options = new BitmapFactory.Options();
        new BitmapFactory.Options().inPreferredConfig = Bitmap.Config.ARGB_8888;
        this.magnifierFrameBitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)this.magnifierDrawableResourceId, (BitmapFactory.Options)options);
        if (this.magnifierFrameBitmap == null) {
            this.magnifierFrameBitmap = BitmapUtils.drawableToBitmap((Drawable)this.getResources().getDrawable(this.magnifierDrawableResourceId));
        }
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.magnifierFrameBitmap.recycle();
        this.magnifierFrameBitmap = null;
        this.magnifier.a();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.magnifier.a(this.getWidth() - this.getPaddingLeft() - this.getPaddingRight(), this.getHeight() - this.getPaddingTop() - this.getPaddingBottom());
    }

    public void setEnableBounding(boolean enableBounding) {
        this.enableBounding = enableBounding;
    }

    private final class a {
        private final float b = 2.0f;
        private float c;
        private int d;
        private int e;
        private BitmapShader f;
        private Paint g;
        private Matrix h = new Matrix();
        private float i;
        private float j;
        private float k;
        private Bitmap l;

        a() {
        }

        final void a(int n2, int n3) {
            this.d = n2;
            this.e = n3;
            if (this.l != null && n2 != 0 && n3 != 0) {
                this.c = Math.max((float)this.l.getWidth() / (float)this.d, (float)this.l.getHeight() / (float)this.e);
                this.i = ((float)this.d - (float)this.l.getWidth() / this.c) / 2.0f;
                this.j = ((float)this.e - (float)this.l.getHeight() / this.c) / 2.0f;
            }
        }

        final void a(Bitmap bitmap, float f2) {
            if (BitmapUtils.isBitmapValid((Bitmap)bitmap)) {
                if (this.f != null) {
                    this.a();
                }
                Bitmap bitmap2 = bitmap;
                Canvas canvas = new Canvas(bitmap2);
                Paint paint = new Paint();
                paint.setColor(-16777216);
                paint.setStyle(Paint.Style.STROKE);
                paint.setStrokeWidth(0.0f);
                canvas.drawRect(0.0f, 0.0f, (float)(bitmap2.getWidth() - 1), (float)(bitmap2.getHeight() - 1), paint);
                this.l = bitmap2;
                Shader.TileMode tileMode = Shader.TileMode.CLAMP;
                this.f = new BitmapShader(this.l, tileMode, tileMode);
                this.g = new Paint();
                this.g.setShader((Shader)this.f);
                this.k = f2;
                a a2 = this;
                a2.a(a2.MagnifierView.this.getWidth() - MagnifierView.this.getPaddingLeft() - MagnifierView.this.getPaddingRight(), MagnifierView.this.getHeight() - MagnifierView.this.getPaddingTop() - MagnifierView.this.getPaddingBottom());
            }
        }

        final void a() {
            if (this.l != null) {
                this.l.recycle();
            }
            this.l = null;
            this.g = null;
            this.f = null;
        }

        private static Bitmap a(Bitmap bitmap, int n2) {
            Canvas canvas = new Canvas(bitmap);
            Paint paint = new Paint();
            paint.setColor(n2);
            paint.setStyle(Paint.Style.STROKE);
            paint.setStrokeWidth(0.0f);
            canvas.drawRect(0.0f, 0.0f, (float)(bitmap.getWidth() - 1), (float)(bitmap.getHeight() - 1), paint);
            return bitmap;
        }

        final void a(Canvas canvas, PointF pointF) {
            PointF pointF2 = new PointF(pointF.x * (float)this.l.getWidth(), pointF.y * (float)this.l.getHeight());
            float f2 = MagnifierView.this.magnifierMargin;
            float f3 = MagnifierView.this.magnifierMargin;
            if (MagnifierView.this.enableBounding) {
                PointF pointF3 = pointF2;
                a a2 = this;
                int n2 = pointF3.x + a2.i < (float)(a2.l.getWidth() >> 1) ? (pointF3.y + a2.j < (float)(a2.l.getHeight() >> 1) ? 1 : 4) : (pointF3.y + a2.j < (float)(a2.l.getHeight() >> 1) ? 2 : 3);
                if ((int)((float)n2 - (360.0f - a2.k) % 360.0f / 90.0f) == 1) {
                    f2 = (float)MagnifierView.this.getWidth() - MagnifierView.this.magnifierRaduis * 2.0f - MagnifierView.this.magnifierMargin;
                }
            }
            this.h.setScale(2.0f, 2.0f);
            this.h.postTranslate(-pointF2.x * 2.0f + MagnifierView.this.magnifierRaduis + f2, -pointF2.y * 2.0f + MagnifierView.this.magnifierRaduis + f3);
            this.f.setLocalMatrix(this.h);
            canvas.save();
            canvas.rotate(this.k, f2 + MagnifierView.this.magnifierRaduis, f3 + MagnifierView.this.magnifierRaduis);
            canvas.drawCircle(f2 + MagnifierView.this.magnifierRaduis, f3 + MagnifierView.this.magnifierRaduis, MagnifierView.this.magnifierRaduis, this.g);
            canvas.restore();
            canvas.drawBitmap(MagnifierView.this.magnifierFrameBitmap, f2, f3, null);
        }

        private boolean a(PointF pointF) {
            int n2 = pointF.x + this.i < (float)(this.l.getWidth() >> 1) ? (pointF.y + this.j < (float)(this.l.getHeight() >> 1) ? 1 : 4) : (pointF.y + this.j < (float)(this.l.getHeight() >> 1) ? 2 : 3);
            return (int)((float)n2 - (360.0f - this.k) % 360.0f / 90.0f) == 1;
        }

        final void a(float f2) {
            this.k = f2;
        }
    }
}

