/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.camera;

import android.content.Context;
import android.graphics.PointF;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import io.scanbot.sdk.ScanbotSDK;
import io.scanbot.sdk.SdkLicenseError;
import io.scanbot.sdk.camera.FrameHandlerResult;
import io.scanbot.sdk.core.contourdetector.DetectionResult;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import net.doo.snap.camera.CameraStateCallback;
import net.doo.snap.camera.CameraTakePictureCallback;
import net.doo.snap.camera.ContourDetectorFrameHandler;
import net.doo.snap.camera.PictureCallback;
import net.doo.snap.camera.PreviewBuffer;
import net.doo.snap.camera.ScanbotCameraView;
import net.doo.snap.camera.sensor.SignificantMoveCatcher;
import net.doo.snap.camera.sensor.SignificantMoveListener;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;
import org.jetbrains.annotations.NotNull;

public class AutoSnappingController {
    private static final long DEFAULT_CAPTURE_INTERVAL_MS = 1000L;
    private static final long MAXIMUM_CAPTURE_INTERVAL = 3000L;
    private static final int DELAY_AFTER_MOVE_MS = 2000;
    private static final int OK_DETECTIONS_COUNT_FOR_AUTOSNAP = 3;
    private static final double OK_DETECTIONS_THRESHOLD = 0.05;
    protected final ScanbotCameraView cameraView;
    protected final SignificantMoveCatcher significantMoveCatcher;
    protected final SignificantMoveListener significantMoveListener;
    private long lastSignificantMove;
    protected final AtomicLong captureInterval;
    protected final Logger logger;
    protected long lastCapture;
    protected AtomicBoolean capturing;
    protected boolean ignoreBadAspectRatio;
    protected boolean forceAutofocusBeforeSnap;
    protected final Handler mainThreadHandler;
    private boolean isAutoSnapEnabled;
    private AtomicBoolean isAutosnappingShooting;
    private AutoSnappingCallback autoSnappingCallback;
    private final Runnable autosnappingShoot;
    private List<PointF> lastDetectedPolygon;
    private AtomicInteger okDetectionCounter;

    public static AutoSnappingController attach(ScanbotCameraView cameraView) {
        ScanbotCameraView scanbotCameraView = cameraView;
        ScanbotCameraView scanbotCameraView2 = scanbotCameraView.getContext();
        return AutoSnappingController.attach(scanbotCameraView, new ContourDetectorFrameHandler((Context)scanbotCameraView2, new ScanbotSDK((Context)scanbotCameraView2).contourDetector()));
    }

    /*
     * WARNING - void declaration
     */
    public static AutoSnappingController attach(ScanbotCameraView cameraView, ContourDetectorFrameHandler contourDetectorFrameHandler) {
        void var1_1;
        ScanbotCameraView scanbotCameraView;
        return new AutoSnappingController(scanbotCameraView, (ContourDetectorFrameHandler)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public AutoSnappingController(ScanbotCameraView cameraView, ContourDetectorFrameHandler contourDetectorFrameHandler) {
        this((ScanbotCameraView)d3, (PreviewBuffer.FrameHandler)var2_2);
        d d2;
        void var2_2;
        d d3;
        d3 = d2;
        d2 = new d();
        contourDetectorFrameHandler.addResultHandler((ContourDetectorFrameHandler.ResultHandler)d3);
    }

    /*
     * WARNING - void declaration
     */
    protected AutoSnappingController(ScanbotCameraView cameraView, PreviewBuffer.FrameHandler frameHandler) {
        void var2_2;
        void var1_1;
        ScanbotCameraView scanbotCameraView = cameraView;
        AutoSnappingController autoSnappingController = this;
        this.lastSignificantMove = 0L;
        this.captureInterval = new AtomicLong(1000L);
        this.logger = LoggerProvider.getLogger();
        this.lastCapture = 0L;
        this.capturing = new AtomicBoolean(false);
        this.ignoreBadAspectRatio = false;
        this.forceAutofocusBeforeSnap = false;
        this.mainThreadHandler = new Handler(Looper.getMainLooper());
        this.isAutoSnapEnabled = true;
        this.isAutosnappingShooting = new AtomicBoolean(false);
        this.autoSnappingCallback = AutoSnappingCallback.NULL;
        this.autosnappingShoot = new Runnable(this){
            final /* synthetic */ AutoSnappingController a;
            {
                void var1_1;
                this.a = var1_1;
            }

            @Override
            public void run() {
                boolean bl = SystemClock.elapsedRealtime() - this.a.lastSignificantMove <= 2000L;
                if (this.a.isAutoSnapEnabled && !bl) {
                    if (!this.a.autoSnappingCallback.onAutoSnapping()) {
                        bl = this.a.forceAutofocusBeforeSnap || Build.VERSION.SDK_INT < 24;
                        this.a.cameraView.takePicture(bl);
                    }
                } else {
                    this.a.isAutosnappingShooting.set(false);
                }
            }
        };
        this.okDetectionCounter = new AtomicInteger(0);
        autoSnappingController.cameraView = var1_1;
        autoSnappingController.significantMoveCatcher = new SignificantMoveCatcher(var1_1.getContext().getApplicationContext());
        autoSnappingController.significantMoveListener = new SignificantMoveListenerImpl(this);
        scanbotCameraView.getPreviewBuffer().addFrameHandler((PreviewBuffer.FrameHandler)var2_2);
        scanbotCameraView.addPictureCallback((PictureCallback)new e());
        scanbotCameraView.addCameraStateCallback((CameraStateCallback)new b());
        scanbotCameraView.addTakePictureCallback((CameraTakePictureCallback)new c());
    }

    /*
     * WARNING - void declaration
     */
    private void checkDetectedPolygonAndSnap(List<PointF> polygon) {
        void var1_1;
        if (polygon != null && !var1_1.isEmpty() && this.okDetectionCounter.get() < 3) {
            List<PointF> list = this.lastDetectedPolygon;
            if (list == null) {
                this.lastDetectedPolygon = var1_1;
            } else if (this.polygonsAreClose(list, (List<PointF>)var1_1)) {
                this.okDetectionCounter.incrementAndGet();
            } else {
                this.okDetectionCounter.set(0);
                this.lastDetectedPolygon = var1_1;
            }
        } else {
            AutoSnappingController autoSnappingController = this;
            autoSnappingController.isAutosnappingShooting.set(true);
            autoSnappingController.mainThreadHandler.post(this.autosnappingShoot);
            autoSnappingController.okDetectionCounter.set(0);
            autoSnappingController.lastDetectedPolygon = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean polygonsAreClose(List<PointF> lastDetectedPolygon, List<PointF> polygon) {
        void var1_1;
        void var2_2;
        return (double)Math.abs(lastDetectedPolygon.get((int)0).x - ((PointF)var2_2.get((int)0)).x) < 0.05 && (double)Math.abs(((PointF)var1_1.get((int)0)).y - ((PointF)var2_2.get((int)0)).y) < 0.05 && (double)Math.abs(((PointF)var1_1.get((int)2)).x - ((PointF)var2_2.get((int)2)).x) < 0.05 && (double)Math.abs(((PointF)var1_1.get((int)2)).y - ((PointF)var2_2.get((int)2)).y) < 0.05;
    }

    /*
     * WARNING - void declaration
     */
    private float clamp(float value) {
        void var1_1;
        if (value < 0.0f) {
            return 0.0f;
        }
        if (var1_1 > 1.0f) {
            return 1.0f;
        }
        return (float)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ long access$002(AutoSnappingController x02, long x1) {
        void var1_1;
        var0.lastSignificantMove = var1_1;
        return x1;
    }

    /*
     * WARNING - void declaration
     */
    protected void onDetectionOK(List<PointF> polygon) {
        if (!this.isAutosnappingShooting.get()) {
            void var1_1;
            this.checkDetectedPolygonAndSnap((List<PointF>)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setEnabled(boolean enabled) {
        void var1_1;
        this.isAutoSnapEnabled = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setForceAutofocusBeforeSnap(boolean enabled) {
        void var1_1;
        this.forceAutofocusBeforeSnap = var1_1;
    }

    public boolean isEnabled() {
        return this.isAutoSnapEnabled;
    }

    /*
     * WARNING - void declaration
     */
    public void setSensitivity(float sensitivity) {
        void var1_2;
        AutoSnappingController autoSnappingController = this;
        this.logger.logMethod();
        float f2 = 1.0f - autoSnappingController.clamp((float)var1_2);
        autoSnappingController.captureInterval.set((long)(f2 * 3000.0f));
    }

    /*
     * WARNING - void declaration
     */
    public void setIgnoreBadAspectRatio(boolean ignoreBadAspectRatio) {
        void var1_1;
        this.logger.logMethod();
        this.ignoreBadAspectRatio = var1_1;
    }

    public void setAutoSnappingCallback(AutoSnappingCallback callback) {
        AutoSnappingCallback autoSnappingCallback;
        this.logger.logMethod();
        if (callback == null) {
            autoSnappingCallback = AutoSnappingCallback.NULL;
        }
        this.autoSnappingCallback = autoSnappingCallback;
    }

    private class c
    implements CameraTakePictureCallback {
        private c() {
        }

        public void onTakePictureRequested() {
        }

        public void onTakePictureCancelled() {
            c c2 = this;
            c2.AutoSnappingController.this.mainThreadHandler.removeCallbacksAndMessages(null);
            c2.AutoSnappingController.this.isAutosnappingShooting.set(false);
        }
    }

    protected class SignificantMoveListenerImpl
    implements SignificantMoveListener {
        final /* synthetic */ AutoSnappingController this$0;

        /*
         * WARNING - void declaration
         */
        protected SignificantMoveListenerImpl(AutoSnappingController this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        @Override
        public float getSignificantMoveThreshold() {
            return 0.6f;
        }

        @Override
        public void onSignificantMove() {
            SignificantMoveListenerImpl significantMoveListenerImpl = this;
            AutoSnappingController.access$002(significantMoveListenerImpl.this$0, SystemClock.elapsedRealtime());
            if (significantMoveListenerImpl.this$0.capturing.get() && this.this$0.isAutosnappingShooting.get()) {
                SignificantMoveListenerImpl significantMoveListenerImpl2 = this;
                significantMoveListenerImpl2.this$0.cameraView.continuousFocus();
                significantMoveListenerImpl2.this$0.mainThreadHandler.removeCallbacksAndMessages(null);
                significantMoveListenerImpl2.this$0.isAutosnappingShooting.set(false);
            }
        }
    }

    private class b
    implements CameraStateCallback {
        private b() {
        }

        public void onResume() {
            b b2 = this_;
            b2.AutoSnappingController.this.capturing.set(true);
            AutoSnappingController this_ = b2.AutoSnappingController.this;
            this_.significantMoveCatcher.registerSignificantMoveListener(this_.significantMoveListener);
        }

        public void onPause() {
            b b2 = this_;
            AutoSnappingController this_ = b2.AutoSnappingController.this;
            this_.significantMoveCatcher.unregisterSignificantMoveListener(this_.significantMoveListener);
            b2.AutoSnappingController.this.isAutosnappingShooting.set(false);
            b2.AutoSnappingController.this.capturing.set(false);
            b2.AutoSnappingController.this.lastCapture = 0L;
        }
    }

    private class e
    implements PictureCallback {
        private e() {
        }

        public void onPictureTaken(byte[] image, int imageOrientation) {
            e e2 = this;
            e2.AutoSnappingController.this.mainThreadHandler.removeCallbacksAndMessages(null);
            e2.AutoSnappingController.this.isAutosnappingShooting.set(false);
        }
    }

    private class d
    implements ContourDetectorFrameHandler.ResultHandler {
        private d() {
        }

        /*
         * WARNING - void declaration
         */
        private void a(List<PointF> polygon) {
            void var1_1;
            AutoSnappingController.this.mainThreadHandler.post(new Runnable(this, (List)var1_1){
                final /* synthetic */ List a;
                final /* synthetic */ d b;
                {
                    void var1_1;
                    this.b = var1_1;
                    this.a = list;
                }

                @Override
                public void run() {
                    this.b.AutoSnappingController.this.onDetectionOK(this.a);
                }
            });
        }

        public boolean handle(@NotNull FrameHandlerResult<? extends ContourDetectorFrameHandler.DetectedFrame, ? extends SdkLicenseError> result) {
            if (result instanceof FrameHandlerResult.Success) {
                ContourDetectorFrameHandler.DetectedFrame detectedFrame;
                detectedFrame = (ContourDetectorFrameHandler.DetectedFrame)((FrameHandlerResult.Success)detectedFrame).getValue();
                AutoSnappingController.this.logger.logMethod();
                Object object = detectedFrame.detectionResult;
                if ((object == DetectionResult.OK || AutoSnappingController.this.ignoreBadAspectRatio && object == DetectionResult.OK_BUT_BAD_ASPECT_RATIO) && AutoSnappingController.this.capturing.get()) {
                    object = AutoSnappingController.this;
                    if (SystemClock.elapsedRealtime() - object.lastCapture > object.captureInterval.get()) {
                        if (AutoSnappingController.this.lastCapture != 0L) {
                            this.a(detectedFrame.polygon);
                        }
                        AutoSnappingController.this.lastCapture = SystemClock.elapsedRealtime();
                    }
                }
            }
            return false;
        }
    }

    public static interface AutoSnappingCallback {
        public static final AutoSnappingCallback NULL = new AutoSnappingCallback(){

            @Override
            public boolean onAutoSnapping() {
                return false;
            }
        };

        public boolean onAutoSnapping();
    }
}

