/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.process.compose;

import io.scanbot.sdk.docprocessing.compose.Composer;
import io.scanbot.sdk.docprocessing.compose.ComposerFactory;
import io.scanbot.sdk.docprocessing.compose.JpegComposer;
import io.scanbot.sdk.docprocessing.compose.SimpleComposer;
import io.scanbot.sdk.entity.Document;
import io.scanbot.sdk.entity.OcrStatus;
import io.scanbot.sdk.ocr.process.compose.OcrComposer;
import io.scanbot.sdk.util.device.DeviceUtils;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;

public class P2ComposerFactory
implements ComposerFactory {
    private final DeviceUtils deviceUtils;
    private final OcrComposer ocrComposer;
    private final SimpleComposer simpleComposer;
    private final JpegComposer jpegComposer;

    @Inject
    public P2ComposerFactory(DeviceUtils deviceUtils, OcrComposer ocrComposer, SimpleComposer simpleComposer, JpegComposer jpegComposer) {
        this.deviceUtils = deviceUtils;
        this.ocrComposer = ocrComposer;
        this.simpleComposer = simpleComposer;
        this.jpegComposer = jpegComposer;
    }

    private boolean isJpeg(Document document) {
        String string = document.name.toLowerCase();
        return string.endsWith(".jpg") || string.endsWith(".jpeg");
    }

    private Composer buildSimpleOrDummyComposer(Document document) {
        if (document.size > 0L) {
            return new ComposerFactory.DummyComposer();
        }
        return this.simpleComposer;
    }

    private Composer buildJpegOrDummyComposer(Document document) {
        if (document.size > 0L) {
            return new ComposerFactory.DummyComposer();
        }
        return this.jpegComposer;
    }

    @NotNull
    public Composer composerForDocument(Document document) {
        if (this.isJpeg(document)) {
            return this.buildJpegOrDummyComposer(document);
        }
        OcrStatus ocrStatus = document.ocrStatus;
        if (ocrStatus == OcrStatus.PENDING_FORCED) {
            return this.ocrComposer;
        }
        if (ocrStatus == OcrStatus.PENDING_ON_CHARGER && this.deviceUtils.isDeviceOnCharger()) {
            return this.ocrComposer;
        }
        if (ocrStatus == OcrStatus.PENDING) {
            return this.ocrComposer;
        }
        return this.buildSimpleOrDummyComposer(document);
    }
}

