/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui;

import android.animation.Animator;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import androidx.appcompat.widget.AppCompatImageView;
import io.scanbot.sdk.ScanbotSDKInitializer;
import io.scanbot.sdk.bundle.R;
import io.scanbot.sdk.core.contourdetector.Line2D;
import io.scanbot.sdk.ui.MagnifierView;
import io.scanbot.sdk.util.PolygonHelper;
import io.scanbot.sdk.util.bitmap.BitmapUtils;
import io.scanbot.sdk.util.view.PolygonHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import org.jetbrains.annotations.Nullable;

public class EditPolygonImageView
extends AppCompatImageView {
    private static final int CORNERS_COUNT = 4;
    private EditPolygonAnimationEndListener editPolygonAnimationEndListener = null;
    private EditPolygonDragListener editPolygonDragListener = null;
    private final float magneticLineTreshold;
    private final int edgeColor;
    private final int edgeColorOnLine;
    private final Drawable cornerDrawable;
    private final Drawable edgeDrawable;
    private Paint paint;
    private Paint paintOnLine;
    private Paint handlePaint;
    private io.scanbot.sdk.util.view.PolygonHelper polygonHelper;
    private float rotationScale = 1.0f;
    private boolean isPointsDraggable = true;
    private final List<Line2D> horizontalLines2D = new ArrayList<Line2D>();
    private final List<Line2D> verticalLines2D = new ArrayList<Line2D>();
    private final List<PolygonHelper.Line> horizontalLines = new ArrayList<PolygonHelper.Line>();
    private final List<PolygonHelper.Line> verticalLines = new ArrayList<PolygonHelper.Line>();
    private PointF finger = new PointF();
    private List<PointF> polygon;
    private List<PointF> corners;
    private List<PolygonHelper.Edge> edges;
    private float offsetX;
    private float offsetY;
    private Bitmap cornerBitmap;
    private Bitmap edgeBitmap;
    private int handleSize;
    private PointF selectedCorner;
    private PolygonHelper.Edge selectedEdge;
    private PointF tmpPointA = new PointF();
    private PointF tmpPointB = new PointF();
    private float medianX;
    private float medianY;
    private PriorityQueue<PointF> pointsQueue;
    @Nullable
    private MagnifierView magnifierView;
    private float[] imageMatrix;
    private RectF touchRect;
    private float polygonStrokeWidth;
    private int lastKnownImageWidth;
    private int lastKnownImageHeight;
    private float scaleLandscape;
    private float scalePortrait;
    boolean fullPolygonSelected;

    public static List<PointF> getDefaultPolygon() {
        return new ArrayList<PointF>(){
            {
                PointF pointF;
                PointF pointF2;
                PointF pointF3;
                PointF pointF4;
                a a2 = a3;
                a a3 = pointF4;
                pointF4 = new PointF(0.0f, 0.0f);
                a2.add(a3);
                a3 = pointF3;
                pointF3 = new PointF(1.0f, 0.0f);
                a2.add(a3);
                a3 = pointF2;
                pointF2 = new PointF(1.0f, 1.0f);
                a2.add(a3);
                a3 = pointF;
                pointF = new PointF(0.0f, 1.0f);
                a2.add(a3);
            }
        };
    }

    public EditPolygonImageView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        Comparator<PointF> comparator;
        Comparator<PointF> comparator2 = comparator;
        comparator = new Comparator<PointF>(){

            public int a(PointF pointF, PointF pointF2) {
                return Double.compare(Math.atan2(pointF.y - EditPolygonImageView.this.medianY, pointF.x - EditPolygonImageView.this.medianX), Math.atan2(pointF2.y - EditPolygonImageView.this.medianY, pointF2.x - EditPolygonImageView.this.medianX));
            }
        };
        this.pointsQueue = new PriorityQueue<PointF>(4, comparator2);
        this.imageMatrix = new float[9];
        this.touchRect = new RectF();
        this.lastKnownImageWidth = -1;
        this.lastKnownImageHeight = -1;
        this.scaleLandscape = 1.0f;
        this.scalePortrait = 1.0f;
        if (ScanbotSDKInitializer.isInitialized()) {
            ArrayList<PolygonHelper.Edge> arrayList;
            Paint paint;
            Paint paint2;
            EditPolygonImageView editPolygonImageView = this;
            context = context.getTheme().obtainStyledAttributes(attributeSet, R.styleable.EditPolygonImageView, 0, 0);
            EditPolygonImageView editPolygonImageView2 = this;
            Context context2 = context;
            EditPolygonImageView editPolygonImageView3 = this;
            Context context3 = context;
            EditPolygonImageView editPolygonImageView4 = this;
            Context context4 = context;
            EditPolygonImageView editPolygonImageView5 = this;
            Context context5 = context;
            EditPolygonImageView editPolygonImageView6 = this;
            Context context6 = context;
            EditPolygonImageView editPolygonImageView7 = this;
            Context context7 = context;
            EditPolygonImageView editPolygonImageView8 = this;
            int n2 = context.getColor(R.styleable.EditPolygonImageView_edgeColor, 0);
            editPolygonImageView8.edgeColor = n2;
            int n3 = context7.getColor(R.styleable.EditPolygonImageView_edgeColorOnLine, n2);
            try {
                editPolygonImageView7.edgeColorOnLine = n3;
                editPolygonImageView6.cornerDrawable = context6.getDrawable(R.styleable.EditPolygonImageView_cornerImageSrc);
                editPolygonImageView5.edgeDrawable = context5.getDrawable(R.styleable.EditPolygonImageView_edgeImageSrc);
                editPolygonImageView4.magneticLineTreshold = context4.getDimension(R.styleable.EditPolygonImageView_magneticLineTreshold, this.getResources().getDimension(R.dimen.magnetic_line_treshold));
                editPolygonImageView3.polygonStrokeWidth = context3.getDimension(R.styleable.EditPolygonImageView_editPolygonStrokeWidth, this.getResources().getDimension(R.dimen.polygon_stroke_width));
                editPolygonImageView2.handleSize = context2.getDimensionPixelSize(R.styleable.EditPolygonImageView_editPolygonHandleSize, this.getResources().getDimensionPixelSize(R.dimen.edit_polygon_handle_size));
            }
            catch (Throwable throwable) {
                context.recycle();
                throw throwable;
            }
            context.recycle();
            editPolygonImageView.polygon = Collections.emptyList();
            Context context8 = context = paint2;
            super();
            this.paint = context8;
            paint2.setColor(n2);
            editPolygonImageView.paint.setStyle(Paint.Style.STROKE);
            editPolygonImageView.paint.setStrokeWidth(this.polygonStrokeWidth);
            editPolygonImageView.paint.setAntiAlias(true);
            editPolygonImageView.paint.setStrokeCap(Paint.Cap.SQUARE);
            Context context9 = context = paint;
            super();
            this.paintOnLine = context9;
            paint.setColor(n3);
            editPolygonImageView.paintOnLine.setStyle(Paint.Style.STROKE);
            editPolygonImageView.paintOnLine.setStrokeWidth(this.polygonStrokeWidth);
            editPolygonImageView.paintOnLine.setAntiAlias(true);
            editPolygonImageView.paintOnLine.setStrokeCap(Paint.Cap.SQUARE);
            this.handlePaint = new Paint();
            this.handlePaint.setAntiAlias(true);
            editPolygonImageView.handlePaint.setFilterBitmap(true);
            editPolygonImageView.polygonHelper = new io.scanbot.sdk.util.view.PolygonHelper();
            editPolygonImageView.corners = new ArrayList<PointF>();
            for (int i2 = 0; i2 < 4; ++i2) {
                this.corners.add(new PointF());
            }
            ArrayList<PolygonHelper.Edge> arrayList2 = arrayList;
            arrayList = new ArrayList<PolygonHelper.Edge>();
            this.edges = arrayList2;
            int n4 = 0;
            while (n4 < this.corners.size()) {
                PolygonHelper.Edge edge;
                PolygonHelper.Edge edge2 = edge;
                edge2();
                edge2.pointA = this.corners.get(n4);
                n3 = n4 + 1;
                edge2.pointB = this.corners.get(n3 % 4);
                edge2.pointFarA = this.corners.get((n4 + 3) % 4);
                edge.pointFarB = this.corners.get((n4 + 2) % 4);
                this.edges.add(edge2);
                n4 = n3;
            }
            return;
        }
        throw new IllegalStateException("Scanbot SDK is not initialized. Please use ScanbotSDKInitializer.class for the first SDK initialization.");
    }

    private float getRotationScale(float f2, float f3) {
        if (Math.abs((f2 + f3) % 360.0f) / 90.0f % 2.0f == 0.0f) {
            return this.scalePortrait;
        }
        return this.scaleLandscape;
    }

    private void checkWhetherImageSizeUpdated() {
        Drawable drawable = this.getDrawable();
        if (drawable == null) {
            return;
        }
        if (drawable.getIntrinsicWidth() != this.lastKnownImageWidth || drawable.getIntrinsicHeight() != this.lastKnownImageHeight) {
            this.lastKnownImageWidth = drawable.getIntrinsicWidth();
            this.lastKnownImageHeight = drawable.getIntrinsicHeight();
            this.onImageSizeUpdated();
        }
    }

    private void drawHandle(Canvas canvas, PointF pointF, Bitmap bitmap, float f2) {
        canvas.save();
        if (f2 != 0.0f) {
            PointF pointF2 = pointF;
            float f3 = pointF2.x;
            float f4 = pointF2.y;
            canvas.rotate(f2, f3, f4);
        }
        Canvas canvas2 = canvas;
        PointF pointF3 = pointF;
        PointF pointF4 = pointF;
        EditPolygonImageView editPolygonImageView = this;
        float f5 = 1.0f / editPolygonImageView.getRotationScale(editPolygonImageView.getRotation(), 0.0f);
        float f6 = pointF4.x;
        float f7 = pointF4.y;
        float f8 = f5;
        canvas.scale(f8, f8, f6, f7);
        f5 = pointF3.x - (float)(bitmap.getWidth() >> 1);
        f6 = pointF3.y - (float)(bitmap.getHeight() >> 1);
        Paint paint = this.handlePaint;
        canvas2.drawBitmap(bitmap, f5, f6, paint);
        canvas2.restore();
    }

    private void keepInsideView(PointF pointF) {
        PointF pointF2 = pointF;
        pointF2.set(Math.max(0.0f, Math.min(pointF2.x, (float)this.getWidth() - this.offsetX * 2.0f)), Math.max(0.0f, Math.min(pointF.y, (float)this.getHeight() - this.offsetY * 2.0f)));
    }

    private void checkPolygonSelection() {
        EditPolygonImageView editPolygonImageView = this;
        boolean bl = editPolygonImageView.getPolygon().containsAll(PolygonHelper.getFullPolygon());
        if (editPolygonImageView.fullPolygonSelected != bl) {
            EditPolygonDragListener editPolygonDragListener = this.editPolygonDragListener;
            if (editPolygonDragListener != null) {
                editPolygonDragListener.onPolygonSelectedStateChanged(bl);
            }
            this.fullPolygonSelected = bl;
        }
    }

    private void restoreSelectedEdge() {
        EditPolygonImageView editPolygonImageView = editPolygonImageView3;
        editPolygonImageView.selectedEdge.pointA.set(editPolygonImageView3.tmpPointA);
        editPolygonImageView.selectedEdge.pointB.set(editPolygonImageView3.tmpPointB);
        PolygonHelper.Edge edge = editPolygonImageView.selectedEdge;
        EditPolygonImageView editPolygonImageView2 = editPolygonImageView3 = edge;
        EditPolygonImageView editPolygonImageView3 = ((PolygonHelper.Edge)editPolygonImageView2).pointA;
        edge.edgeLine.calculateLine((PointF)editPolygonImageView3, ((PolygonHelper.Edge)editPolygonImageView2).pointB);
    }

    private void ensureNoPolygonIntersection() {
        EditPolygonImageView editPolygonImageView = this;
        editPolygonImageView.calculateMedian();
        if (editPolygonImageView.ensureCornersOrder()) {
            this.ensureEdgesOrder();
        }
    }

    private boolean ensureCornersOrder() {
        boolean bl = false;
        this.pointsQueue.addAll(this.corners);
        for (int i2 = 0; i2 < 4; ++i2) {
            PointF pointF = (PointF)this.pointsQueue.remove();
            if (!pointF.equals((Object)this.corners.get(i2))) {
                bl = true;
            }
            this.corners.set(i2, pointF);
        }
        return bl;
    }

    private void calculateMedian() {
        float f2 = 0.0f;
        float f3 = 0.0f;
        for (int i2 = 0; i2 < 4; ++i2) {
            float f4 = f3;
            PointF pointF = this.corners.get(i2);
            f3 = f2 + pointF.x;
            f2 = f4 + pointF.y;
            float f5 = f3;
            f3 = f2;
            f2 = f5;
        }
        this.medianX = f2 / 4.0f;
        this.medianY = f3 / 4.0f;
    }

    private void ensureEdgesOrder() {
        int n2 = 0;
        while (n2 < 4) {
            PolygonHelper.Edge edge = this.edges.get(n2);
            edge.pointA = this.corners.get(n2);
            int n3 = n2 + 1;
            edge.pointB = this.corners.get(n3 % 4);
            edge.pointFarA = this.corners.get((n2 + 3) % 4);
            this.edges.get(n2).pointFarB = this.corners.get((n2 + 2) % 4);
            n2 = n3;
        }
    }

    private void onImageSizeUpdated() {
        if (object.getDrawable() != null) {
            float f2;
            EditPolygonImageView editPolygonImageView = object;
            editPolygonImageView.offsetX = 0.0f;
            editPolygonImageView.offsetY = 0.0f;
            editPolygonImageView.getImageMatrix().getValues(object.imageMatrix);
            Drawable drawable = editPolygonImageView.getDrawable();
            int n2 = drawable.getIntrinsicHeight();
            float f3 = drawable.getIntrinsicWidth();
            EditPolygonImageView editPolygonImageView2 = object;
            float f4 = f3 * object.getScaleX();
            float f5 = n2;
            float f6 = f5 * object.getScaleY();
            RectF rectF = new RectF(0.0f, 0.0f, f4, f6);
            editPolygonImageView2.scalePortrait = io.scanbot.sdk.d.a.a((View)editPolygonImageView2, 0.0f, rectF) * object.getScaleX();
            editPolygonImageView2.scaleLandscape = io.scanbot.sdk.d.a.a((View)editPolygonImageView2, 90.0f, rectF) * object.getScaleY();
            if (f2 * editPolygonImageView2.scalePortrait < (float)object.getWidth()) {
                object.offsetX = object.getWidth() - (int)(f3 * object.scalePortrait) >> 1;
            }
            if (f5 * object.scalePortrait < (float)object.getHeight()) {
                object.offsetY = object.getHeight() - (int)(f5 * object.scalePortrait) >> 1;
            }
            EditPolygonImageView editPolygonImageView3 = object;
            int n3 = (int)Math.ceil(f3 * object.scalePortrait);
            editPolygonImageView3.polygonHelper.setImageSize(n3, (int)Math.ceil(f5 * object.scalePortrait));
            editPolygonImageView3.scaleLandscape /= object.scalePortrait;
            editPolygonImageView3.scalePortrait = 1.0f;
            if (editPolygonImageView3.getRotation() / 90.0f % 2.0f == 1.0f) {
                EditPolygonImageView editPolygonImageView4 = object;
                editPolygonImageView4.setScaleX(editPolygonImageView4.scaleLandscape);
                editPolygonImageView4.setScaleY(editPolygonImageView4.scaleLandscape);
            }
            if (!object.polygon.isEmpty()) {
                EditPolygonImageView editPolygonImageView5 = object;
                Object object = editPolygonImageView5.polygon;
                object.polygonHelper.getDrawingPolygon((List)object, editPolygonImageView5.corners);
            }
        }
    }

    static /* synthetic */ List access$202(EditPolygonImageView editPolygonImageView, List list) {
        editPolygonImageView.polygon = list;
        return list;
    }

    protected void onAttachedToWindow() {
        EditPolygonImageView editPolygonImageView = this;
        super.onAttachedToWindow();
        editPolygonImageView.cornerBitmap = BitmapUtils.drawableToBitmap((Drawable)editPolygonImageView.cornerDrawable);
        editPolygonImageView.edgeBitmap = BitmapUtils.drawableToBitmap((Drawable)editPolygonImageView.edgeDrawable);
    }

    protected void onDetachedFromWindow() {
        EditPolygonImageView editPolygonImageView = this;
        super.onDetachedFromWindow();
        editPolygonImageView.cornerBitmap.recycle();
        editPolygonImageView.edgeBitmap.recycle();
        editPolygonImageView.editPolygonAnimationEndListener = null;
        editPolygonImageView.editPolygonDragListener = null;
    }

    protected void onMeasure(int n2, int n3) {
        EditPolygonImageView editPolygonImageView = this;
        super.onMeasure(n2, n3);
        editPolygonImageView.onImageSizeUpdated();
    }

    protected void onLayout(boolean bl, int n2, int n3, int n4, int n5) {
        super.onLayout(bl, n2, n3, n4, n5);
    }

    public void setPolygon(final List<PointF> list) {
        Runnable runnable;
        Runnable runnable2 = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                if (!list.isEmpty()) {
                    c c2 = this;
                    EditPolygonImageView.access$202(c2.EditPolygonImageView.this, list);
                    if (!c2.EditPolygonImageView.this.corners.isEmpty()) {
                        EditPolygonImageView.this.polygonHelper.getDrawingPolygon(list, EditPolygonImageView.this.corners);
                    }
                    c c3 = this;
                    c3.EditPolygonImageView.this.checkPolygonSelection();
                    c3.EditPolygonImageView.this.invalidate();
                }
            }
        };
        this.post(runnable2);
    }

    public List<PointF> getPolygon() {
        if (!this.corners.isEmpty() && !this.polygon.isEmpty()) {
            EditPolygonImageView editPolygonImageView = this;
            List<PointF> list = editPolygonImageView.corners;
            this.polygonHelper.getPolygonFromDrawingPolygon(list, editPolygonImageView.polygon);
        }
        return this.polygon;
    }

    public void setRotation(float f2) {
        if (f2 % 90.0f != 0.0f) {
            return;
        }
        EditPolygonImageView editPolygonImageView = this;
        float f3 = editPolygonImageView.getRotation() - f2;
        f3 = editPolygonImageView.getRotationScale(editPolygonImageView.getRotation(), f3);
        MagnifierView magnifierView = editPolygonImageView.magnifierView;
        if (magnifierView != null) {
            magnifierView.setImageRotation(f2);
        }
        EditPolygonImageView editPolygonImageView2 = this;
        editPolygonImageView2.setScaleX(f3);
        editPolygonImageView2.setScaleY(f3);
        editPolygonImageView2.invalidate();
        super.setRotation(f2);
    }

    public void setLines(final List<Line2D> list, final List<Line2D> list2) {
        Runnable runnable;
        Runnable runnable2 = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                ArrayList arrayList;
                Object object;
                PointF pointF;
                ArrayList<Line2D> arrayList2;
                Iterator<Line2D> iterator = arrayList2;
                arrayList2 = new ArrayList<Line2D>(list.size());
                for (Line2D line2D : list) {
                    PointF pointF2;
                    PointF pointF3 = line2D.start;
                    float f2 = pointF3.x;
                    pointF = pointF2;
                    PointF pointF4 = line2D.end;
                    float f3 = pointF4.x;
                    pointF2 = new PointF(f3, pointF4.y);
                    iterator.add(new Line2D(new PointF(f2, pointF3.y), pointF));
                }
                d d2 = this;
                d2.EditPolygonImageView.this.horizontalLines2D.clear();
                d2.EditPolygonImageView.this.horizontalLines2D.addAll(EditPolygonImageView.this.polygonHelper.scaleLines(iterator));
                d2.EditPolygonImageView.this.horizontalLines.clear();
                iterator = iterator.iterator();
                while (iterator.hasNext()) {
                    PolygonHelper.Line line;
                    object = (Line2D)iterator.next();
                    PolygonHelper.Line line2 = line;
                    Line2D line2D = object;
                    line2();
                    object = line2D.start;
                    line.calculateLine((PointF)object, line2D.end);
                    EditPolygonImageView.this.horizontalLines.add(line2);
                }
                iterator = arrayList;
                arrayList = new ArrayList(list2.size());
                for (Line2D line2D : list2) {
                    PointF pointF5;
                    PointF pointF6 = line2D.start;
                    float f4 = pointF6.x;
                    pointF = pointF5;
                    PointF pointF7 = line2D.end;
                    float f5 = pointF7.x;
                    pointF5 = new PointF(f5, pointF7.y);
                    iterator.add(new Line2D(new PointF(f4, pointF6.y), pointF));
                }
                d d3 = this;
                d3.EditPolygonImageView.this.verticalLines2D.clear();
                d3.EditPolygonImageView.this.verticalLines2D.addAll(EditPolygonImageView.this.polygonHelper.scaleLines((List)((Object)iterator)));
                d3.EditPolygonImageView.this.verticalLines.clear();
                iterator = iterator.iterator();
                while (iterator.hasNext()) {
                    PolygonHelper.Line line;
                    object = (Line2D)iterator.next();
                    PolygonHelper.Line line3 = line;
                    Object object2 = object;
                    line3();
                    object = ((Line2D)object2).start;
                    line.calculateLine((PointF)object, ((Line2D)object2).end);
                    EditPolygonImageView.this.verticalLines.add(line3);
                }
            }
        };
        this.post(runnable2);
    }

    public void setEdgeColor(int n2) {
        this.paint.setColor(n2);
    }

    public void setEdgeColorOnLine(int n2) {
        this.paintOnLine.setColor(n2);
    }

    public void setEdgeWidth(float f2) {
        EditPolygonImageView editPolygonImageView = this;
        editPolygonImageView.polygonStrokeWidth = f2;
        editPolygonImageView.paint.setStrokeWidth(f2);
        editPolygonImageView.paintOnLine.setStrokeWidth(this.polygonStrokeWidth);
    }

    public void rotateClockwise() {
        float f2 = this.getRotation();
        if (f2 % 90.0f != 0.0f) {
            return;
        }
        EditPolygonImageView editPolygonImageView = this;
        f2 = editPolygonImageView.getRotationScale(f2, 90.0f);
        editPolygonImageView.animate().rotationBy(90.0f).scaleX(f2).scaleY(f2).setListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animator) {
            }

            public void onAnimationEnd(Animator animator) {
                if (EditPolygonImageView.this.magnifierView != null) {
                    EditPolygonImageView.this.magnifierView.setImageRotation(EditPolygonImageView.this.getRotation());
                }
                if (EditPolygonImageView.this.editPolygonAnimationEndListener != null) {
                    EditPolygonImageView.this.editPolygonAnimationEndListener.onAnimationEnded();
                }
                EditPolygonImageView.this.invalidate();
            }

            public void onAnimationCancel(Animator animator) {
            }

            public void onAnimationRepeat(Animator animator) {
            }
        }).start();
    }

    public void rotateCounterClockwise() {
        float f2 = this.getRotation();
        if (f2 % 90.0f != 0.0f) {
            return;
        }
        EditPolygonImageView editPolygonImageView = this;
        f2 = editPolygonImageView.getRotationScale(f2, -90.0f);
        editPolygonImageView.animate().rotationBy(-90.0f).scaleX(f2).scaleY(f2).setListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animator) {
            }

            public void onAnimationEnd(Animator animator) {
                if (EditPolygonImageView.this.magnifierView != null) {
                    EditPolygonImageView.this.magnifierView.setImageRotation(EditPolygonImageView.this.getRotation());
                }
                if (EditPolygonImageView.this.editPolygonAnimationEndListener != null) {
                    EditPolygonImageView.this.editPolygonAnimationEndListener.onAnimationEnded();
                }
                EditPolygonImageView.this.invalidate();
            }

            public void onAnimationCancel(Animator animator) {
            }

            public void onAnimationRepeat(Animator animator) {
            }
        }).start();
    }

    protected void dispatchDraw(Canvas canvas) {
        EditPolygonImageView editPolygonImageView = editPolygonImageView5;
        super.dispatchDraw(canvas);
        editPolygonImageView.checkWhetherImageSizeUpdated();
        if (!editPolygonImageView.polygon.isEmpty()) {
            float f2;
            float f3;
            EditPolygonImageView editPolygonImageView2 = editPolygonImageView5;
            canvas.save();
            float f4 = editPolygonImageView2.offsetX;
            canvas.translate(f4, editPolygonImageView2.offsetY);
            for (PolygonHelper.Edge edge : editPolygonImageView5.edges) {
                PointF pointF = edge.pointA;
                f3 = pointF.x;
                float f5 = pointF.y;
                PointF pointF2 = edge.pointB;
                f2 = pointF2.x;
                float f6 = pointF2.y;
                Paint paint = edge.isDetectedLine ? editPolygonImageView5.paintOnLine : editPolygonImageView5.paint;
                canvas.drawLine(f3, f5, f2, f6, paint);
            }
            Object object = editPolygonImageView5.selectedCorner;
            if (object != null) {
                editPolygonImageView5.drawHandle(canvas, (PointF)object, editPolygonImageView5.cornerBitmap, 0.0f);
                canvas.save();
                canvas.translate(-editPolygonImageView5.offsetX, -editPolygonImageView5.offsetY);
                if (editPolygonImageView5.magnifierView != null) {
                    PointF pointF;
                    object = pointF;
                    pointF = new PointF(editPolygonImageView5.selectedCorner.x / ((float)editPolygonImageView5.getWidth() - editPolygonImageView5.offsetX * 2.0f), editPolygonImageView5.selectedCorner.y / ((float)editPolygonImageView5.getHeight() - editPolygonImageView5.offsetY * 2.0f));
                    editPolygonImageView5.magnifierView.drawMagnifier((PointF)object);
                }
                canvas.restore();
            } else {
                object = editPolygonImageView5.selectedEdge;
                if (object != null) {
                    EditPolygonImageView editPolygonImageView3 = editPolygonImageView5;
                    EditPolygonImageView editPolygonImageView4 = editPolygonImageView5;
                    EditPolygonImageView editPolygonImageView5 = object.getHandle();
                    object = editPolygonImageView4.edgeBitmap;
                    f3 = editPolygonImageView4.selectedEdge.getAngleInDegrees();
                    editPolygonImageView3.drawHandle(canvas, (PointF)editPolygonImageView5, (Bitmap)object, f3);
                } else {
                    for (PolygonHelper.Edge edge : editPolygonImageView5.edges) {
                        PointF pointF = edge.getHandle();
                        Bitmap bitmap = editPolygonImageView5.edgeBitmap;
                        f2 = edge.getAngleInDegrees();
                        editPolygonImageView5.drawHandle(canvas, pointF, bitmap, f2);
                    }
                    for (PointF pointF : editPolygonImageView5.corners) {
                        editPolygonImageView5.drawHandle(canvas, pointF, editPolygonImageView5.cornerBitmap, 0.0f);
                    }
                }
            }
            canvas.restore();
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean onTouchEvent(MotionEvent var1_1) {
        if (!this.isPointsDraggable) {
            return true;
        }
        switch (var1_1.getAction()) {
            default: {
                return super.onTouchEvent((MotionEvent)var1_1);
            }
            case 2: {
                var2_2 = this.selectedCorner;
                if (var2_2 == null) ** GOTO lbl15
                v0 = this;
                var2_2.set(var1_1.getX() - this.offsetX, var1_1.getY() - this.offsetY);
                v0.keepInsideView(v0.selectedCorner);
                v0.ensureNoPolygonIntersection();
                v0.invalidate();
                ** GOTO lbl82
lbl15:
                // 1 sources

                if (this.selectedEdge == null) ** GOTO lbl82
                v1 = this;
                v2 = var1_1;
                var2_3 = v2.getX() - this.selectedEdge.prevX;
                var3_11 = v2.getY() - this.selectedEdge.prevY;
                v1.finger.offset(var2_3, var3_11);
                v1.tmpPointA.set(this.selectedEdge.pointA);
                v1.tmpPointB.set(this.selectedEdge.pointB);
                var2_4 = 1.7976931348623157E308;
                var4_15 = null;
                if (v1.selectedEdge.isHorizontal()) {
                    for (var5_18 = 0; var5_18 < this.horizontalLines.size(); ++var5_18) {
                        var6_21 = this.horizontalLines.get(var5_18).getDistanceToPoint(this.finger);
                        if (v3 < var2_4) {
                            var4_15 = this.horizontalLines2D.get(var5_18);
                        } else {
                            var6_21 = var2_4;
                        }
                        var2_4 = var6_21;
                    }
                } else {
                    for (var5_19 = 0; var5_19 < this.verticalLines.size(); ++var5_19) {
                        var6_22 = this.verticalLines.get(var5_19).getDistanceToPoint(this.finger);
                        if (v4 < var2_4) {
                            var4_15 = this.verticalLines2D.get(var5_19);
                        } else {
                            var6_22 = var2_4;
                        }
                        var2_4 = var6_22;
                    }
                }
                if (var4_15 != null && var2_4 < (double)this.magneticLineTreshold) {
                    v5 = this;
                    v5.selectedEdge.pointA.set(var4_15.start);
                    v5.selectedEdge.pointB.set(var4_15.end);
                    v5.selectedEdge.isDetectedLine = true;
                } else {
                    v6 = this;
                    v6.selectedEdge.isDetectedLine = false;
                    var2_5 = v6.selectedEdge.getHandle();
                    v7 = v6.finger;
                    var3_11 = v7.x - var2_5.x;
                    var2_6 = v7.y - var2_5.y;
                    v6.selectedEdge.pointA.offset(var3_11, var2_6);
                    v6.selectedEdge.pointB.offset(var3_11, var2_6);
                }
                v8 = this;
                v9 = v8.selectedEdge;
                v10 = var2_7 = v9;
                var2_7 = v10.pointA;
                v9.edgeLine.calculateLine((PointF)var2_7, v10.pointB);
                var2_7 = v8.selectedEdge;
                var2_7 = var2_7.edgeLine.getIntersectionPoint(var2_7.lineA);
                if (Float.isNaN(var2_7.x) || Float.isNaN(var2_7.y)) ** GOTO lbl80
                v11 = this;
                v11.selectedEdge.pointA.set((PointF)var2_7);
                var2_7 = v11.selectedEdge;
                var2_7 = var2_7.edgeLine.getIntersectionPoint(var2_7.lineB);
                if (!Float.isNaN(var2_7.x) && !Float.isNaN(var2_7.y)) {
                    v12 = this;
                    v12.selectedEdge.pointB.set((PointF)var2_7);
                    v12.keepInsideView(v12.selectedEdge.pointA);
                    v12.keepInsideView(v12.selectedEdge.pointB);
                    v12.selectedEdge.prevX = var1_1.getX();
                    v12.selectedEdge.prevY = var1_1.getY();
                    v12.invalidate();
                } else {
                    this.restoreSelectedEdge();
                    return false;
lbl80:
                    // 1 sources

                    this.restoreSelectedEdge();
                    return false;
                }
lbl82:
                // 3 sources

                this.checkPolygonSelection();
                return true;
            }
            case 1: 
            case 3: {
                this.selectedCorner = null;
                this.selectedEdge = null;
                var1_1 = this.magnifierView;
                if (var1_1 != null) {
                    var1_1.eraseMagnifier();
                }
                this.invalidate();
                return true;
            }
            case 0: 
        }
        v13 = this;
        var2_8 = v13.handleSize >> 1;
        v14 = var2_8;
        var2_9 = v14;
        v15 = var1_1;
        var3_12 = v15.getY() - this.offsetY - var2_9;
        var4_16 = v15.getX() - this.offsetX + var2_9;
        var2_9 = v15.getY() - this.offsetY + var2_9;
        v13.touchRect.set(var1_1.getX() - this.offsetX - v14, var3_12, var4_16, var2_9);
        var2_10 = v13.corners.iterator();
        while (var2_10.hasNext()) {
            v16 = var3_13 = var2_10.next();
            var4_16 = v16.x;
            if (!this.touchRect.contains(var4_16, v16.y)) continue;
            this.selectedCorner = var3_13;
            this.invalidate();
            return true;
        }
        for (PolygonHelper.Edge var3_14 : this.edges) {
            v17 = var4_17 = var3_14.getHandle();
            var5_20 = v17.x;
            if (!this.touchRect.contains(var5_20, v17.y)) continue;
            v18 = this;
            v19 = this.selectedEdge = var3_14;
            var3_14.prevX = var1_1.getX();
            v19.prevY = var1_1.getY();
            v20 = var3_14;
            this = v20.pointA;
            v19.lineA.calculateLine((PointF)this, v20.pointFarA);
            v21 = var3_14;
            this = v21.pointB;
            v19.lineB.calculateLine((PointF)this, v21.pointFarB);
            v18.finger.set(var4_17);
            v18.invalidate();
            return true;
        }
        return false;
    }

    void setMagnifier(MagnifierView magnifierView) {
        this.magnifierView = magnifierView;
        this.invalidate();
    }

    public void setEditPolygonAnimationEndListener(EditPolygonAnimationEndListener editPolygonAnimationEndListener) {
        this.editPolygonAnimationEndListener = editPolygonAnimationEndListener;
    }

    public void setEditPolygonDragListener(EditPolygonDragListener editPolygonDragListener) {
        this.editPolygonDragListener = editPolygonDragListener;
    }

    public boolean isPointsDraggable() {
        return this.isPointsDraggable;
    }

    public void setPointsDraggable(boolean bl) {
        this.isPointsDraggable = bl;
    }

    public static interface EditPolygonDragListener {
        public void onPolygonSelectedStateChanged(boolean var1);
    }

    public static interface EditPolygonAnimationEndListener {
        public void onAnimationEnded();
    }
}

