/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import io.scanbot.sdk.bundle.R;
import io.scanbot.sdk.ui.EditPolygonImageView;
import io.scanbot.sdk.util.bitmap.BitmapUtils;

public class MagnifierView
extends View {
    private final float magnifierRaduis;
    private final float magnifierMargin;
    private final int magnifierDrawableResourceId;
    private a magnifier = new a();
    private PointF zoomPoint;
    private Bitmap magnifierFrameBitmap;
    private boolean enableBounding;

    public MagnifierView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        context = context.getTheme().obtainStyledAttributes(attributeSet, R.styleable.MagnifierView, 0, 0);
        try {
            this.magnifierDrawableResourceId = context.getResourceId(R.styleable.MagnifierView_magnifierImageSrc, 0);
            this.magnifierRaduis = context.getDimension(R.styleable.MagnifierView_magnifierRadius, this.getResources().getDimension(R.dimen.magnifier_raduis));
            this.magnifierMargin = context.getDimension(R.styleable.MagnifierView_magnifierMargin, this.getResources().getDimension(R.dimen.magnifier_margin));
            this.enableBounding = context.getBoolean(R.styleable.MagnifierView_magnifierEnableBounding, true);
        }
        catch (Throwable throwable) {
            context.recycle();
            throw throwable;
        }
        context.recycle();
    }

    void drawMagnifier(PointF pointF) {
        this.zoomPoint = pointF;
        this.invalidate();
    }

    void eraseMagnifier() {
        this.zoomPoint = null;
        this.invalidate();
    }

    public void setImageRotation(float f2) {
        MagnifierView magnifierView = this;
        magnifierView.magnifier.a(f2);
        magnifierView.invalidate();
    }

    public void setupMagnifier(EditPolygonImageView editPolygonImageView) {
        MagnifierView magnifierView = magnifierView2;
        MagnifierView magnifierView2 = BitmapUtils.drawableToBitmap((Drawable)editPolygonImageView.getDrawable());
        magnifierView.magnifier.a((Bitmap)magnifierView2, editPolygonImageView.getRotation(), -16777216);
        editPolygonImageView.setMagnifier(magnifierView);
    }

    protected void dispatchDraw(Canvas canvas) {
        MagnifierView magnifierView = this;
        super.dispatchDraw(canvas);
        PointF pointF = magnifierView.zoomPoint;
        if (pointF != null) {
            this.magnifier.a(canvas, pointF);
        } else {
            canvas.drawColor(0);
        }
    }

    public void onAttachedToWindow() {
        BitmapFactory.Options options;
        MagnifierView magnifierView = this;
        super.onAttachedToWindow();
        BitmapFactory.Options options2 = options;
        new BitmapFactory.Options().inPreferredConfig = Bitmap.Config.ARGB_8888;
        this.magnifierFrameBitmap = BitmapFactory.decodeResource((Resources)magnifierView.getResources(), (int)this.magnifierDrawableResourceId, (BitmapFactory.Options)options2);
        if (this.magnifierFrameBitmap == null) {
            this.magnifierFrameBitmap = BitmapUtils.drawableToBitmap((Drawable)this.getResources().getDrawable(this.magnifierDrawableResourceId));
        }
    }

    public void onDetachedFromWindow() {
        MagnifierView magnifierView = this;
        super.onDetachedFromWindow();
        magnifierView.magnifierFrameBitmap.recycle();
        magnifierView.magnifierFrameBitmap = null;
        magnifierView.magnifier.a();
    }

    protected void onLayout(boolean bl, int n2, int n3, int n4, int n5) {
        MagnifierView magnifierView = this;
        super.onLayout(bl, n2, n3, n4, n5);
        magnifierView.magnifier.a(this.getWidth() - this.getPaddingLeft() - this.getPaddingRight(), this.getHeight() - this.getPaddingTop() - this.getPaddingBottom());
    }

    public void setEnableBounding(boolean bl) {
        this.enableBounding = bl;
    }

    private class a {
        private final float a;
        private float b;
        private int c;
        private int d;
        private BitmapShader e;
        private Paint f;
        private Matrix g;
        private float h;
        private float i;
        private float j;
        private Bitmap k;

        a() {
            Matrix matrix;
            a2.a = 2.0f;
            a a2 = matrix;
            matrix = new Matrix();
            v1.g = a2;
        }

        private Bitmap a(Bitmap bitmap, int n2) {
            Paint paint;
            Canvas canvas;
            a a2 = canvas;
            Bitmap bitmap2 = bitmap;
            a2(bitmap);
            a2 = paint;
            a2();
            paint.setColor(n2);
            paint.setStyle(Paint.Style.STROKE);
            paint.setStrokeWidth(0.0f);
            float f2 = bitmap2.getWidth() - 1;
            float f3 = bitmap2.getHeight() - 1;
            canvas.drawRect(0.0f, 0.0f, f2, f3, (Paint)a2);
            return bitmap;
        }

        private boolean a(PointF pointF) {
            return (int)((float)(pointF.x + this.h < (float)(this.k.getWidth() >> 1) ? (pointF.y + this.i < (float)(this.k.getHeight() >> 1) ? 1 : 4) : (pointF.y + this.i < (float)(this.k.getHeight() >> 1) ? 2 : 3)) - (360.0f - this.j) % 360.0f / 90.0f) == 1;
        }

        void a(int n2, int n3) {
            this.c = n2;
            this.d = n3;
            Bitmap bitmap = this.k;
            if (bitmap != null && n2 != 0 && n3 != 0) {
                a a2 = this;
                a2.b = Math.max((float)bitmap.getWidth() / (float)this.c, (float)this.k.getHeight() / (float)this.d);
                a2.h = ((float)a2.c - (float)this.k.getWidth() / this.b) / 2.0f;
                a2.i = ((float)a2.d - (float)this.k.getHeight() / this.b) / 2.0f;
            }
        }

        void a(Bitmap bitmap, float f2, int n2) {
            if (BitmapUtils.isBitmapValid((Bitmap)bitmap)) {
                Paint paint;
                if (this.e != null) {
                    this.a();
                }
                a a2 = this;
                this.k = this.a(bitmap, n2);
                Shader.TileMode tileMode = Shader.TileMode.CLAMP;
                this.e = new BitmapShader(this.k, tileMode, tileMode);
                Bitmap bitmap2 = bitmap = paint;
                bitmap2();
                this.f = bitmap2;
                paint.setShader((Shader)this.e);
                a2.j = f2;
                a2.a(a2.MagnifierView.this.getWidth() - MagnifierView.this.getPaddingLeft() - MagnifierView.this.getPaddingRight(), MagnifierView.this.getHeight() - MagnifierView.this.getPaddingTop() - MagnifierView.this.getPaddingBottom());
            }
        }

        void a() {
            Bitmap bitmap = this.k;
            if (bitmap != null) {
                bitmap.recycle();
            }
            a a2 = this;
            a2.k = null;
            a2.f = null;
            a2.e = null;
        }

        void a(Canvas canvas, PointF pointF) {
            PointF pointF2;
            a a2 = this;
            PointF pointF3 = pointF2;
            pointF2 = new PointF(pointF.x * (float)this.k.getWidth(), pointF.y * (float)this.k.getHeight());
            float f2 = a2.MagnifierView.this.magnifierMargin;
            float f3 = a2.MagnifierView.this.magnifierMargin;
            if (a2.MagnifierView.this.enableBounding && this.a(pointF3)) {
                f2 = (float)MagnifierView.this.getWidth() - MagnifierView.this.magnifierRaduis * 2.0f - MagnifierView.this.magnifierMargin;
            }
            Canvas canvas2 = canvas;
            a a3 = this;
            a a4 = this;
            a a5 = this;
            a5.g.setScale(2.0f, 2.0f);
            a5.g.postTranslate(-pointF3.x * 2.0f + MagnifierView.this.magnifierRaduis + f2, -pointF3.y * 2.0f + MagnifierView.this.magnifierRaduis + f3);
            a5.e.setLocalMatrix(this.g);
            canvas.save();
            float f4 = a4.j;
            float f5 = f2 + a4.MagnifierView.this.magnifierRaduis;
            float f6 = f3 + MagnifierView.this.magnifierRaduis;
            canvas.rotate(f4, f5, f6);
            f4 = f2 + MagnifierView.this.magnifierRaduis;
            f5 = f3 + MagnifierView.this.magnifierRaduis;
            f6 = a3.MagnifierView.this.magnifierRaduis;
            Paint paint = a3.f;
            canvas2.drawCircle(f4, f5, f6, paint);
            canvas2.restore();
            canvas.drawBitmap(MagnifierView.this.magnifierFrameBitmap, f2, f3, null);
        }

        void a(float f2) {
            this.j = f2;
        }
    }
}

