/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk;

import android.app.Application;
import android.content.Context;
import android.os.AsyncTask;
import android.preference.PreferenceManager;
import android.util.Log;
import io.scanbot.sap.IScanbotSDKLicenseErrorHandler;
import io.scanbot.sap.SdkLicenseInfo;
import io.scanbot.sdk.ScanbotSDK;
import io.scanbot.sdk.blob.BlobFactory;
import io.scanbot.sdk.blob.BlobManager;
import io.scanbot.sdk.blob.BlobType;
import io.scanbot.sdk.core.contourdetector.ContourDetector;
import io.scanbot.sdk.core.contourdetector.ContourDetectorSettings;
import io.scanbot.sdk.di.ScanbotSdkModule;
import io.scanbot.sdk.di.SdkStorageModule;
import io.scanbot.sdk.docprocessing.draft.DocumentDraftExtractor;
import io.scanbot.sdk.entity.Blob;
import io.scanbot.sdk.ocr.intelligence.OcrSettings;
import io.scanbot.sdk.persistence.PageStorageSettings;
import io.scanbot.sdk.security.SapSingleton;
import io.scanbot.sdk.util.log.DebugLog;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import io.scanbot.sdk.util.log.StubLogger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0016\u0018\u0000 I2\u00020\u0001:\u0002IJB\u0007\u00a2\u0006\u0004\bH\u0010\u0004J\u000f\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0017\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\u000b\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001d\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001d\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\r\u00a2\u0006\u0004\b\u0014\u0010\u000fJ\u0015\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\t\u00a2\u0006\u0004\b\u0015\u0010\fJ\u0015\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\t\u00a2\u0006\u0004\b\u0016\u0010\fJ\u0015\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\t\u00a2\u0006\u0004\b\u0017\u0010\fJ\u0015\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\t\u00a2\u0006\u0004\b\u0018\u0010\fJ\u0015\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0019\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0015\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\t\u00a2\u0006\u0004\b\u001d\u0010\fJ\u0015\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\t\u00a2\u0006\u0004\b\u001e\u0010\fJ\u0015\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\t\u00a2\u0006\u0004\b\u001f\u0010\fJ\u0015\u0010 \u001a\u00020\u00002\u0006\u0010 \u001a\u00020\t\u00a2\u0006\u0004\b \u0010\fJ\u0015\u0010!\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\t\u00a2\u0006\u0004\b!\u0010\fJ\u0015\u0010#\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\t\u00a2\u0006\u0004\b#\u0010\fJ\u0015\u0010&\u001a\u00020\u00002\u0006\u0010%\u001a\u00020$\u00a2\u0006\u0004\b&\u0010'J\u0015\u0010)\u001a\u00020(2\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b)\u0010*J\u0015\u0010-\u001a\u00020\u00002\u0006\u0010,\u001a\u00020+\u00a2\u0006\u0004\b-\u0010.J\u001d\u00100\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u00100\u001a\u00020/\u00a2\u0006\u0004\b0\u00101J\u0015\u00103\u001a\u00020\u00002\u0006\u00103\u001a\u000202\u00a2\u0006\u0004\b3\u00104J\u0015\u00107\u001a\u00020\u00002\u0006\u00106\u001a\u000205\u00a2\u0006\u0004\b7\u00108R\u0016\u0010\u001a\u001a\u00020\u00198\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001a\u00109R\u0016\u0010\u0017\u001a\u00020\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0017\u0010:R\u0016\u0010!\u001a\u00020\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b!\u0010:R\u0016\u0010&\u001a\u00020$8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b&\u0010;R\u0016\u0010#\u001a\u00020\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b#\u0010:R\u0016\u0010<\u001a\u00020\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b<\u0010:R\"\u0010\n\u001a\u00020\t8\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\b\n\u0010:\u001a\u0004\b=\u0010>\"\u0004\b?\u0010@R\u0016\u0010\u001e\u001a\u00020\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001e\u0010:R\u0016\u0010\u001d\u001a\u00020\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001d\u0010:R\u0016\u0010\u0018\u001a\u00020\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0018\u0010:R\u0016\u0010\u0015\u001a\u00020\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0015\u0010:R\u0016\u0010\u001f\u001a\u00020\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001f\u0010:R$\u00103\u001a\u0004\u0018\u0001028\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\b3\u0010A\u001a\u0004\bB\u0010C\"\u0004\bD\u0010ER\u0018\u0010-\u001a\u0004\u0018\u00010+8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b-\u0010FR\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u00108\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0011\u0010GR\u0016\u0010 \u001a\u00020\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b \u0010:R\u0016\u0010\u0016\u001a\u00020\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0016\u0010:\u00a8\u0006K"}, d2={"Lio/scanbot/sdk/ScanbotSDKInitializer;", "", "", "loadNativeLibraries", "()V", "Landroid/app/Application;", "application", "prepareBlobs", "(Landroid/app/Application;)V", "", "useLog", "withLogging", "(Z)Lio/scanbot/sdk/ScanbotSDKInitializer;", "", "license", "(Landroid/app/Application;Ljava/lang/String;)Lio/scanbot/sdk/ScanbotSDKInitializer;", "Lio/scanbot/sap/IScanbotSDKLicenseErrorHandler;", "licenseErrorHandler", "licenceErrorHandler", "(Lio/scanbot/sap/IScanbotSDKLicenseErrorHandler;)Lio/scanbot/sdk/ScanbotSDKInitializer;", "ocrBlobsPath", "prepareOCRLanguagesBlobs", "prepareBlurEstimatorBlobs", "prepareIdCardScannerBlobs", "prepareGenericTextRecognizerBlobs", "Lio/scanbot/sdk/ocr/intelligence/OcrSettings;", "ocrSettings", "useOcrSettings", "(Lio/scanbot/sdk/ocr/intelligence/OcrSettings;)Lio/scanbot/sdk/ScanbotSDKInitializer;", "prepareMRZBlobs", "prepareChequeBlobs", "preparePayFormBlobs", "prepareFilterPredictionBlobs", "prepareBarcodeScannerBlobs", "prepareDcScannerBlobs", "prepareDcBlobs", "Lio/scanbot/sdk/core/contourdetector/ContourDetector$Type;", "type", "contourDetectorType", "(Lio/scanbot/sdk/core/contourdetector/ContourDetector$Type;)Lio/scanbot/sdk/ScanbotSDKInitializer;", "Lio/scanbot/sap/SdkLicenseInfo;", "initialize", "(Landroid/app/Application;)Lio/scanbot/sap/SdkLicenseInfo;", "Lio/scanbot/sdk/docprocessing/draft/DocumentDraftExtractor;", "extractor", "documentDraftExtractor", "(Lio/scanbot/sdk/docprocessing/draft/DocumentDraftExtractor;)Lio/scanbot/sdk/ScanbotSDKInitializer;", "Ljava/io/File;", "sdkFilesDirectory", "(Landroid/app/Application;Ljava/io/File;)Lio/scanbot/sdk/ScanbotSDKInitializer;", "Lio/scanbot/sdk/util/log/Logger;", "logger", "(Lio/scanbot/sdk/util/log/Logger;)Lio/scanbot/sdk/ScanbotSDKInitializer;", "Lio/scanbot/sdk/persistence/PageStorageSettings;", "pageStorageSettings", "usePageStorageSettings", "(Lio/scanbot/sdk/persistence/PageStorageSettings;)Lio/scanbot/sdk/ScanbotSDKInitializer;", "Lio/scanbot/sdk/ocr/intelligence/OcrSettings;", "Z", "Lio/scanbot/sdk/core/contourdetector/ContourDetector$Type;", "licenseSet", "getUseLog", "()Z", "setUseLog", "(Z)V", "Lio/scanbot/sdk/util/log/Logger;", "getLogger", "()Lio/scanbot/sdk/util/log/Logger;", "setLogger", "(Lio/scanbot/sdk/util/log/Logger;)V", "Lio/scanbot/sdk/docprocessing/draft/DocumentDraftExtractor;", "Lio/scanbot/sap/IScanbotSDKLicenseErrorHandler;", "<init>", "Companion", "PrepareBlobsTask", "sdk-bundle_release"})
public final class ScanbotSDKInitializer {
    private static boolean initialized;
    public static final Companion Companion;
    private boolean useLog;
    @Nullable
    private Logger logger;
    private boolean licenseSet;
    private boolean prepareOCRLanguagesBlobs;
    private boolean prepareMRZBlobs;
    private boolean prepareChequeBlobs;
    private boolean preparePayFormBlobs;
    private boolean prepareFilterPredictionBlobs;
    private boolean prepareDcBlobs;
    private boolean prepareBarcodeScannerBlobs;
    private ContourDetector.Type contourDetectorType = ContourDetector.Type.EDGE_BASED;
    private OcrSettings ocrSettings = new OcrSettings.Builder().build();
    private boolean prepareBlurEstimatorBlobs;
    private boolean prepareIdCardScannerBlobs;
    private boolean prepareGenericTextRecognizerBlobs;
    private IScanbotSDKLicenseErrorHandler licenseErrorHandler;
    private DocumentDraftExtractor documentDraftExtractor;

    private final void loadNativeLibraries() {
        System.loadLibrary("jpgt");
        System.loadLibrary("lept");
        System.loadLibrary("tess");
        System.loadLibrary("tflite");
        System.loadLibrary("scanbotsdk");
    }

    private final void prepareBlobs(Application application) {
        ScanbotSDKInitializer scanbotSDKInitializer = this;
        boolean bl = scanbotSDKInitializer.prepareOCRLanguagesBlobs;
        boolean bl2 = scanbotSDKInitializer.prepareMRZBlobs;
        boolean bl3 = scanbotSDKInitializer.prepareChequeBlobs;
        boolean bl4 = scanbotSDKInitializer.preparePayFormBlobs;
        boolean bl5 = scanbotSDKInitializer.prepareBarcodeScannerBlobs;
        boolean bl6 = scanbotSDKInitializer.prepareBlurEstimatorBlobs;
        boolean bl7 = scanbotSDKInitializer.prepareIdCardScannerBlobs;
        boolean bl8 = scanbotSDKInitializer.prepareGenericTextRecognizerBlobs;
        new PrepareBlobsTask(application, bl, bl2, bl3, bl4, bl5, bl6, bl7, bl8).executeOnExecutor(AsyncTask.SERIAL_EXECUTOR, new Void[0]);
    }

    static {
        Companion = new Companion(null);
    }

    public static final /* synthetic */ void access$setPrepareFilterPredictionBlobs$p(ScanbotSDKInitializer scanbotSDKInitializer, boolean bl) {
        scanbotSDKInitializer.prepareFilterPredictionBlobs = bl;
    }

    public static final /* synthetic */ void access$setPrepareDcBlobs$p(ScanbotSDKInitializer scanbotSDKInitializer, boolean bl) {
        scanbotSDKInitializer.prepareDcBlobs = bl;
    }

    public static final /* synthetic */ void access$setContourDetectorType$p(ScanbotSDKInitializer scanbotSDKInitializer, ContourDetector.Type type) {
        scanbotSDKInitializer.contourDetectorType = type;
    }

    public static final /* synthetic */ void access$setInitialized$cp(boolean bl) {
        initialized = bl;
    }

    @JvmStatic
    public static final boolean isInitialized() {
        return Companion.isInitialized();
    }

    protected final boolean getUseLog() {
        return this.useLog;
    }

    protected final void setUseLog(boolean bl) {
        this.useLog = bl;
    }

    @Nullable
    protected final Logger getLogger() {
        return this.logger;
    }

    protected final void setLogger(@Nullable Logger logger) {
        this.logger = logger;
    }

    @NotNull
    public final ScanbotSDKInitializer withLogging(boolean bl) {
        if (bl) {
            Log.w((String)"Scanbot SDK", (String)"Logging enabled in non-debug build, consider switching it off");
        }
        this.useLog = bl;
        if (!bl) {
            StubLogger stubLogger;
            StubLogger stubLogger2 = stubLogger;
            stubLogger = new StubLogger();
            this.logger = stubLogger2;
        }
        return this;
    }

    @NotNull
    public final ScanbotSDKInitializer license(@NotNull Application application, @NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)string, (String)"license");
        PreferenceManager.getDefaultSharedPreferences((Context)application).edit().putString("SCANBOT_SDK_LICENSE_KEY", string).apply();
        this.licenseSet = true;
        return this;
    }

    @NotNull
    public final ScanbotSDKInitializer licenceErrorHandler(@NotNull IScanbotSDKLicenseErrorHandler iScanbotSDKLicenseErrorHandler) {
        Intrinsics.checkNotNullParameter((Object)iScanbotSDKLicenseErrorHandler, (String)"licenseErrorHandler");
        this.licenseErrorHandler = iScanbotSDKLicenseErrorHandler;
        return this;
    }

    @NotNull
    public final ScanbotSDKInitializer ocrBlobsPath(@NotNull Application application, @NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)string, (String)"ocrBlobsPath");
        PreferenceManager.getDefaultSharedPreferences((Context)application).edit().putString("SCANBOT_SDK_OCR_BLOBS_PATH", string).apply();
        return this;
    }

    @NotNull
    public final ScanbotSDKInitializer prepareOCRLanguagesBlobs(boolean bl) {
        this.prepareOCRLanguagesBlobs = bl;
        return this;
    }

    @NotNull
    public final ScanbotSDKInitializer prepareBlurEstimatorBlobs(boolean bl) {
        this.prepareBlurEstimatorBlobs = bl;
        return this;
    }

    @NotNull
    public final ScanbotSDKInitializer prepareIdCardScannerBlobs(boolean bl) {
        this.prepareIdCardScannerBlobs = bl;
        return this;
    }

    @NotNull
    public final ScanbotSDKInitializer prepareGenericTextRecognizerBlobs(boolean bl) {
        this.prepareGenericTextRecognizerBlobs = bl;
        return this;
    }

    @NotNull
    public final ScanbotSDKInitializer useOcrSettings(@NotNull OcrSettings ocrSettings) {
        Intrinsics.checkNotNullParameter((Object)ocrSettings, (String)"ocrSettings");
        this.ocrSettings = ocrSettings;
        return this;
    }

    @NotNull
    public final ScanbotSDKInitializer prepareMRZBlobs(boolean bl) {
        this.prepareMRZBlobs = bl;
        return this;
    }

    @NotNull
    public final ScanbotSDKInitializer prepareChequeBlobs(boolean bl) {
        this.prepareChequeBlobs = bl;
        return this;
    }

    @NotNull
    public final ScanbotSDKInitializer preparePayFormBlobs(boolean bl) {
        this.preparePayFormBlobs = bl;
        return this;
    }

    @NotNull
    public final ScanbotSDKInitializer prepareFilterPredictionBlobs(boolean bl) {
        this.prepareFilterPredictionBlobs = bl;
        return this;
    }

    @NotNull
    public final ScanbotSDKInitializer prepareBarcodeScannerBlobs(boolean bl) {
        this.prepareBarcodeScannerBlobs = bl;
        return this;
    }

    @NotNull
    public final ScanbotSDKInitializer prepareDcBlobs(boolean bl) {
        this.prepareDcBlobs = bl;
        return this;
    }

    @NotNull
    public final ScanbotSDKInitializer contourDetectorType(@NotNull ContourDetector.Type type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.contourDetectorType = type;
        return this;
    }

    @NotNull
    public final SdkLicenseInfo initialize(@NotNull Application object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"application");
        Logger logger = this.logger;
        if (logger == null) {
            if (this.useLog) {
                DebugLog debugLog;
                logger = debugLog;
                debugLog = new DebugLog((Context)object);
            } else {
                StubLogger stubLogger;
                logger = stubLogger;
                stubLogger = new StubLogger();
            }
        }
        LoggerProvider.setLogger((Logger)logger);
        if (!this.licenseSet) {
            PreferenceManager.getDefaultSharedPreferences((Context)object).edit().remove("SCANBOT_SDK_LICENSE_KEY").apply();
        }
        this.loadNativeLibraries();
        SapSingleton.initializeSapManager((Context)object);
        logger = SapSingleton.getInstance();
        IScanbotSDKLicenseErrorHandler iScanbotSDKLicenseErrorHandler = this.licenseErrorHandler;
        if (iScanbotSDKLicenseErrorHandler != null) {
            logger.setLicenceErrorHandler(iScanbotSDKLicenseErrorHandler);
        }
        initialized = true;
        this.prepareBlobs((Application)object);
        SdkLicenseInfo sdkLicenseInfo = logger.getLicenseStatus();
        object = "ScanbotSDK license status : " + sdkLicenseInfo.getStatus().name();
        LoggerProvider.getLogger().i("ScanbotSDKInitializer", (String)object);
        ScanbotSdkModule.Companion companion = ScanbotSdkModule.Companion;
        companion.setDocumentDraftExtractor(this.documentDraftExtractor);
        companion.setOcrSettings(this.ocrSettings);
        companion.setContourDetectorSettings(new ContourDetectorSettings.Builder().useType(this.contourDetectorType).build());
        Intrinsics.checkNotNullExpressionValue((Object)sdkLicenseInfo, (String)"licenseStatus");
        return sdkLicenseInfo;
    }

    @NotNull
    public final ScanbotSDKInitializer documentDraftExtractor(@NotNull DocumentDraftExtractor documentDraftExtractor) {
        Intrinsics.checkNotNullParameter((Object)documentDraftExtractor, (String)"extractor");
        this.documentDraftExtractor = documentDraftExtractor;
        return this;
    }

    @NotNull
    public final ScanbotSDKInitializer sdkFilesDirectory(@NotNull Application application, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)file, (String)"sdkFilesDirectory");
        PreferenceManager.getDefaultSharedPreferences((Context)application).edit().putString("CUSTOM_SDK_FILES_PATH", file.getPath()).apply();
        return this;
    }

    @NotNull
    public final ScanbotSDKInitializer logger(@NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.logger = logger;
        return this;
    }

    @NotNull
    public final ScanbotSDKInitializer usePageStorageSettings(@NotNull PageStorageSettings pageStorageSettings) {
        Intrinsics.checkNotNullParameter((Object)pageStorageSettings, (String)"pageStorageSettings");
        SdkStorageModule.Companion.setPageStorageSettings(pageStorageSettings);
        return this;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0013\b\u0086\u0004\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001BO\u0012\u0006\u0010\u001f\u001a\u00020\u001e\u0012\u0006\u0010'\u001a\u00020\u0017\u0012\u0006\u0010%\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0017\u0012\u0006\u0010)\u001a\u00020\u0017\u0012\u0006\u0010-\u001a\u00020\u0017\u0012\u0006\u0010#\u001a\u00020\u0017\u0012\u0006\u0010\u001c\u001a\u00020\u0017\u0012\u0006\u0010+\u001a\u00020\u0017\u00a2\u0006\u0004\b/\u00100J5\u0010\r\u001a\u00020\f2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ-\u0010\r\u001a\u00020\f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\r\u0010\u0012J)\u0010\u0015\u001a\u0004\u0018\u00010\u00022\u0016\u0010\u0014\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00020\u0013\"\u0004\u0018\u00010\u0002H\u0014\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u0019\u0010\u0018\u001a\u00020\u00178\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001bR\u0019\u0010\u001c\u001a\u00020\u00178\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u001c\u0010\u0019\u001a\u0004\b\u001d\u0010\u001bR\u0019\u0010\u001f\u001a\u00020\u001e8\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\"R\u0019\u0010#\u001a\u00020\u00178\u0006@\u0006\u00a2\u0006\f\n\u0004\b#\u0010\u0019\u001a\u0004\b$\u0010\u001bR\u0019\u0010%\u001a\u00020\u00178\u0006@\u0006\u00a2\u0006\f\n\u0004\b%\u0010\u0019\u001a\u0004\b&\u0010\u001bR\u0019\u0010'\u001a\u00020\u00178\u0006@\u0006\u00a2\u0006\f\n\u0004\b'\u0010\u0019\u001a\u0004\b(\u0010\u001bR\u0019\u0010)\u001a\u00020\u00178\u0006@\u0006\u00a2\u0006\f\n\u0004\b)\u0010\u0019\u001a\u0004\b*\u0010\u001bR\u0019\u0010+\u001a\u00020\u00178\u0006@\u0006\u00a2\u0006\f\n\u0004\b+\u0010\u0019\u001a\u0004\b,\u0010\u001bR\u0019\u0010-\u001a\u00020\u00178\u0006@\u0006\u00a2\u0006\f\n\u0004\b-\u0010\u0019\u001a\u0004\b.\u0010\u001b\u00a8\u00061"}, d2={"Lio/scanbot/sdk/ScanbotSDKInitializer$PrepareBlobsTask;", "Landroid/os/AsyncTask;", "Ljava/lang/Void;", "", "Lio/scanbot/sdk/blob/BlobType;", "types", "Lio/scanbot/sdk/blob/BlobFactory;", "blobFactory", "Lio/scanbot/sdk/blob/BlobManager;", "blobManager", "Lio/scanbot/sdk/util/log/Logger;", "logger", "", "fetchBlobs", "(Ljava/util/List;Lio/scanbot/sdk/blob/BlobFactory;Lio/scanbot/sdk/blob/BlobManager;Lio/scanbot/sdk/util/log/Logger;)V", "", "Lio/scanbot/sdk/entity/Blob;", "blobs", "(Ljava/util/Collection;Lio/scanbot/sdk/blob/BlobManager;Lio/scanbot/sdk/util/log/Logger;)V", "", "params", "doInBackground", "([Ljava/lang/Void;)Ljava/lang/Void;", "", "prepareChequeBlobs", "Z", "getPrepareChequeBlobs", "()Z", "prepareIdCardScannerBlobs", "getPrepareIdCardScannerBlobs", "Landroid/app/Application;", "application", "Landroid/app/Application;", "getApplication", "()Landroid/app/Application;", "prepareBlurEstimatorBlobs", "getPrepareBlurEstimatorBlobs", "prepareMRZBlobs", "getPrepareMRZBlobs", "prepareOCRLanguagesBlobs", "getPrepareOCRLanguagesBlobs", "preparePayFormBlobs", "getPreparePayFormBlobs", "prepareGenericTextRecognizerBlobs", "getPrepareGenericTextRecognizerBlobs", "prepareBarcodeScannerBlobs", "getPrepareBarcodeScannerBlobs", "<init>", "(Lio/scanbot/sdk/ScanbotSDKInitializer;Landroid/app/Application;ZZZZZZZZ)V", "sdk-bundle_release"})
    public final class PrepareBlobsTask
    extends AsyncTask<Void, Void, Void> {
        @NotNull
        private final Application application;
        private final boolean prepareOCRLanguagesBlobs;
        private final boolean prepareMRZBlobs;
        private final boolean prepareChequeBlobs;
        private final boolean preparePayFormBlobs;
        private final boolean prepareBarcodeScannerBlobs;
        private final boolean prepareBlurEstimatorBlobs;
        private final boolean prepareIdCardScannerBlobs;
        private final boolean prepareGenericTextRecognizerBlobs;

        private final void fetchBlobs(List<? extends BlobType> arrayList, BlobFactory blobFactory, BlobManager blobManager, Logger logger) {
            ArrayList<Blob> arrayList2;
            ArrayList<Blob> arrayList3 = arrayList;
            arrayList = arrayList2;
            arrayList2 = new ArrayList<Blob>();
            for (BlobType blobType : arrayList3) {
                try {
                    arrayList.addAll(blobFactory.getBlobsForType(blobType));
                }
                catch (IOException iOException) {
                    Logger logger2 = logger;
                    logger2.logException((Throwable)iOException);
                    logger2.e("PrepareBlobsTask", "Could not fetch " + blobType + " blobs!");
                }
            }
            this.fetchBlobs(arrayList, blobManager, logger);
        }

        private final void fetchBlobs(Collection<Blob> blob2, BlobManager blobManager, Logger logger) {
            for (Blob blob2 : blob2) {
                try {
                    blobManager.fetch(blob2);
                }
                catch (IOException iOException) {
                    Logger logger2 = logger;
                    logger2.logException((Throwable)iOException);
                    logger2.e("PrepareBlobsTask", "Could not fetch blob! /n Blob local path: " + blob2.getLocalPath() + " /n Blob remote path: " + blob2.getRemotePath());
                }
            }
        }

        public PrepareBlobsTask(Application application, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8) {
            Intrinsics.checkNotNullParameter((Object)application, (String)"application");
            this.application = application;
            this.prepareOCRLanguagesBlobs = bl;
            this.prepareMRZBlobs = bl2;
            this.prepareChequeBlobs = bl3;
            this.preparePayFormBlobs = bl4;
            this.prepareBarcodeScannerBlobs = bl5;
            this.prepareBlurEstimatorBlobs = bl6;
            this.prepareIdCardScannerBlobs = bl7;
            this.prepareGenericTextRecognizerBlobs = bl8;
        }

        @Nullable
        protected Void doInBackground(Void ... blobManager) {
            Intrinsics.checkNotNullParameter((Object)blobManager, (String)"params");
            ScanbotSDK scanbotSDK = new ScanbotSDK(this.application);
            blobManager = scanbotSDK.blobManager();
            BlobFactory blobFactory = scanbotSDK.blobFactory();
            Logger logger = LoggerProvider.getLogger();
            if (this.prepareOCRLanguagesBlobs) {
                this.fetchBlobs(CollectionsKt.listOf((Object[])new BlobType[]{BlobType.OCR_BLOBS, BlobType.PDF_FONT}), blobFactory, blobManager, logger);
            }
            if (this.prepareMRZBlobs) {
                this.fetchBlobs(CollectionsKt.listOf((Object[])new BlobType[]{BlobType.MRZ_CASCADE, BlobType.MRZ_TRAINEDDATA}), blobFactory, blobManager, logger);
            }
            if (this.prepareChequeBlobs) {
                this.fetchBlobs(CollectionsKt.listOf((Object)BlobType.CHEQUE_DIGIT_RECOGNITION_MODEL), blobFactory, blobManager, logger);
            }
            if (this.preparePayFormBlobs) {
                this.fetchBlobs(CollectionsKt.listOf((Object)BlobType.BANKS_DATA), blobFactory, blobManager, logger);
            }
            if (this.prepareBarcodeScannerBlobs) {
                this.fetchBlobs(CollectionsKt.listOf((Object[])new BlobType[]{BlobType.BARCODE_DETECTION_MODEL, BlobType.BARCODE_BINARIZATION_MODEL}), blobFactory, blobManager, logger);
            }
            if (this.prepareBlurEstimatorBlobs) {
                this.fetchBlobs(CollectionsKt.listOf((Object)BlobType.BLUR_ESTIMATOR_MODEL), blobFactory, blobManager, logger);
            }
            if (ScanbotSDKInitializer.this.prepareFilterPredictionBlobs) {
                this.fetchBlobs(CollectionsKt.listOf((Object)BlobType.FILTER_PREDICTION_MODEL), blobFactory, blobManager, logger);
            }
            if (ScanbotSDKInitializer.this.prepareDcBlobs) {
                this.fetchBlobs(CollectionsKt.listOf((Object)BlobType.DC_FORM_MODELS), blobFactory, blobManager, logger);
            }
            if (this.prepareIdCardScannerBlobs) {
                if (blobFactory.isAvailableInAssets(BlobType.IDCARD_SCANNER_MODELS)) {
                    this.fetchBlobs(CollectionsKt.listOf((Object)BlobType.IDCARD_SCANNER_MODELS), blobFactory, blobManager, logger);
                } else {
                    throw new RuntimeException("Could not fetch IdCard Scanner Model blobs! Please, check that you added dependency on io.scanbot:sdk-idcard-assets:VERSION");
                }
            }
            if (this.prepareGenericTextRecognizerBlobs) {
                if (blobFactory.isAvailableInAssets(BlobType.GENERIC_TEXT_RECOGNIZER_MODELS)) {
                    this.fetchBlobs(CollectionsKt.listOf((Object)BlobType.GENERIC_TEXT_RECOGNIZER_MODELS), blobFactory, blobManager, logger);
                } else {
                    throw new RuntimeException("Could not fetch Generic text recognizer model blobs! Please, check that you added dependency on io.scanbot:sdk-generictext-assets:VERSION");
                }
            }
            if (ScanbotSDKInitializer.this.contourDetectorType == ContourDetector.Type.ML_BASED) {
                if (blobFactory.isAvailableInAssets(BlobType.DOC_DETECTOR_MODEL)) {
                    this.fetchBlobs(CollectionsKt.listOf((Object)BlobType.DOC_DETECTOR_MODEL), blobFactory, blobManager, logger);
                } else {
                    throw new RuntimeException("Could not fetch document detector Model blobs! Please, check that you added dependency on io.scanbot:sdk-ml-docdetector:VERSION");
                }
            }
            return null;
        }

        @NotNull
        public final Application getApplication() {
            return this.application;
        }

        public final boolean getPrepareOCRLanguagesBlobs() {
            return this.prepareOCRLanguagesBlobs;
        }

        public final boolean getPrepareMRZBlobs() {
            return this.prepareMRZBlobs;
        }

        public final boolean getPrepareChequeBlobs() {
            return this.prepareChequeBlobs;
        }

        public final boolean getPreparePayFormBlobs() {
            return this.preparePayFormBlobs;
        }

        public final boolean getPrepareBarcodeScannerBlobs() {
            return this.prepareBarcodeScannerBlobs;
        }

        public final boolean getPrepareBlurEstimatorBlobs() {
            return this.prepareBlurEstimatorBlobs;
        }

        public final boolean getPrepareIdCardScannerBlobs() {
            return this.prepareIdCardScannerBlobs;
        }

        public final boolean getPrepareGenericTextRecognizerBlobs() {
            return this.prepareGenericTextRecognizerBlobs;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\u0003\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004R\u0016\u0010\u0005\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lio/scanbot/sdk/ScanbotSDKInitializer$Companion;", "", "", "isInitialized", "()Z", "initialized", "Z", "<init>", "()V", "sdk-bundle_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }

        @JvmStatic
        public final boolean isInitialized() {
            return initialized;
        }
    }
}

