/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk;

import android.app.Application;
import android.content.Context;
import android.preference.PreferenceManager;
import android.util.Log;
import io.scanbot.common.util.NativeLogger;
import io.scanbot.common.util.TensorFlowUtils;
import io.scanbot.sap.IScanbotSDKLicenseErrorHandler;
import io.scanbot.sap.SDKLicenseErrorHandler;
import io.scanbot.sap.SapManager;
import io.scanbot.sap.SdkLicenseInfo;
import io.scanbot.sdk.SDKLicenseErrorHandlerImpl;
import io.scanbot.sdk.ScanbotSDK;
import io.scanbot.sdk.blob.BlobFactory;
import io.scanbot.sdk.blob.BlobManager;
import io.scanbot.sdk.blob.BlobType;
import io.scanbot.sdk.core.contourdetector.ContourDetector;
import io.scanbot.sdk.core.contourdetector.ContourDetectorSettings;
import io.scanbot.sdk.di.ScanbotSdkModule;
import io.scanbot.sdk.di.SdkStorageModule;
import io.scanbot.sdk.docprocessing.draft.DocumentDraftExtractor;
import io.scanbot.sdk.entity.Blob;
import io.scanbot.sdk.exceptions.imageprocessing.ImageProcessorBlobRuntimeException;
import io.scanbot.sdk.ocr.intelligence.OcrSettings;
import io.scanbot.sdk.persistence.FileStorageSettings;
import io.scanbot.sdk.persistence.PageStorageSettings;
import io.scanbot.sdk.persistence.fileio.FileIOProcessor;
import io.scanbot.sdk.process.ImageProcessor;
import io.scanbot.sdk.process.ImageProcessorSettings;
import io.scanbot.sdk.security.SapSingleton;
import io.scanbot.sdk.ui.camera.CameraUiSettings;
import io.scanbot.sdk.util.log.DebugLog;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import io.scanbot.sdk.util.log.StubLogger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.ExecutorCoroutineDispatcher;
import kotlinx.coroutines.ExecutorsKt;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 ]2\u00020\u0001:\u0002]^B\u0007\u00a2\u0006\u0004\b\\\u0010\u0004J\u000f\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0017\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\t\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\t\u0010\bJ\u001f\u0010\r\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\n2\b\b\u0002\u0010\f\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001d\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0015\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001d\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0016\u0010\u0011J\u0015\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\n\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0015\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0019\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0015\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\n\u00a2\u0006\u0004\b\u001d\u0010\u0018J\u0015\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\n\u00a2\u0006\u0004\b\u001e\u0010\u0018J\u0015\u0010!\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u001f\u00a2\u0006\u0004\b!\u0010\"J\u0015\u0010$\u001a\u00020\u00002\u0006\u0010 \u001a\u00020#\u00a2\u0006\u0004\b$\u0010%J!\u0010)\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\n2\n\b\u0002\u0010(\u001a\u0004\u0018\u00010'\u00a2\u0006\u0004\b)\u0010*J\u0015\u0010,\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\n\u00a2\u0006\u0004\b,\u0010\u0018J\u0015\u0010-\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\n\u00a2\u0006\u0004\b-\u0010\u0018J\u0015\u0010.\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\n\u00a2\u0006\u0004\b.\u0010\u0018J\u001d\u00101\u001a\u00020\u00002\u000e\b\u0002\u00100\u001a\b\u0012\u0004\u0012\u00020\u00020/\u00a2\u0006\u0004\b1\u00102J\u0015\u00104\u001a\u0002032\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b4\u00105J\u0015\u00108\u001a\u00020\u00002\u0006\u00107\u001a\u000206\u00a2\u0006\u0004\b8\u00109J\u001d\u0010;\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010;\u001a\u00020:\u00a2\u0006\u0004\b;\u0010<J\u0015\u0010>\u001a\u00020\u00002\u0006\u0010>\u001a\u00020=\u00a2\u0006\u0004\b>\u0010?J\u0015\u0010B\u001a\u00020\u00002\u0006\u0010A\u001a\u00020@\u00a2\u0006\u0004\bB\u0010CR\"\u0010\u000b\u001a\u00020\n8\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\b\u000b\u0010D\u001a\u0004\bE\u0010F\"\u0004\bG\u0010HR$\u0010>\u001a\u0004\u0018\u00010=8\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\b>\u0010I\u001a\u0004\bJ\u0010K\"\u0004\bL\u0010MR\u0016\u0010\f\u001a\u00020\n8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\f\u0010DR\u0016\u0010N\u001a\u00020\n8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bN\u0010DR\u0016\u0010\u001d\u001a\u00020\n8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001d\u0010DR\u0016\u0010\u001a\u001a\u00020\u00198\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001a\u0010OR\u0018\u0010\u0013\u001a\u0004\u0018\u00010\u00128\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0013\u0010PR\u0016\u0010R\u001a\u00020Q8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bR\u0010SR\u0016\u0010!\u001a\u00020\u001f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b!\u0010TR\u0016\u0010,\u001a\u00020\n8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b,\u0010DR\u0016\u0010V\u001a\u00020U8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bV\u0010WR\u0016\u0010.\u001a\u00020\n8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b.\u0010DR\u0018\u00108\u001a\u0004\u0018\u0001068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b8\u0010XR\u0016\u0010$\u001a\u00020#8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b$\u0010YR\u0016\u00101\u001a\u00020\n8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b1\u0010DR\u001c\u0010Z\u001a\b\u0012\u0004\u0012\u00020\u00020/8\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\bZ\u0010[R\u0016\u0010\u0017\u001a\u00020\n8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0017\u0010DR\u0016\u0010\u001e\u001a\u00020\n8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001e\u0010D\u00a8\u0006_"}, d2={"Lio/scanbot/sdk/ScanbotSDKInitializer;", "", "", "loadNativeLibraries", "()V", "Landroid/app/Application;", "application", "prepareBlobs", "(Landroid/app/Application;)V", "prepareTensorFlow", "", "useLog", "enableNativeLogging", "withLogging", "(ZZ)Lio/scanbot/sdk/ScanbotSDKInitializer;", "", "license", "(Landroid/app/Application;Ljava/lang/String;)Lio/scanbot/sdk/ScanbotSDKInitializer;", "Lio/scanbot/sap/IScanbotSDKLicenseErrorHandler;", "licenseErrorHandler", "licenceErrorHandler", "(Lio/scanbot/sap/IScanbotSDKLicenseErrorHandler;)Lio/scanbot/sdk/ScanbotSDKInitializer;", "ocrBlobsPath", "prepareOCRLanguagesBlobs", "(Z)Lio/scanbot/sdk/ScanbotSDKInitializer;", "Lio/scanbot/sdk/ocr/intelligence/OcrSettings;", "ocrSettings", "useOcrSettings", "(Lio/scanbot/sdk/ocr/intelligence/OcrSettings;)Lio/scanbot/sdk/ScanbotSDKInitializer;", "prepareMRZBlobs", "preparePayFormBlobs", "Lio/scanbot/sdk/core/contourdetector/ContourDetector$Type;", "type", "contourDetectorType", "(Lio/scanbot/sdk/core/contourdetector/ContourDetector$Type;)Lio/scanbot/sdk/ScanbotSDKInitializer;", "Lio/scanbot/sdk/process/ImageProcessor$Type;", "imageProcessorType", "(Lio/scanbot/sdk/process/ImageProcessor$Type;)Lio/scanbot/sdk/ScanbotSDKInitializer;", "enableFileEncryption", "Lio/scanbot/sdk/persistence/fileio/FileIOProcessor;", "fileIOProcessor", "useFileEncryption", "(ZLio/scanbot/sdk/persistence/fileio/FileIOProcessor;)Lio/scanbot/sdk/ScanbotSDKInitializer;", "enable", "allowXnnpackAcceleration", "useCameraXRtuUi", "allowGpuAcceleration", "Lkotlin/Function0;", "precompilingCallback", "precompileGpuMlModels", "(Lkotlin/jvm/functions/Function0;)Lio/scanbot/sdk/ScanbotSDKInitializer;", "Lio/scanbot/sap/SdkLicenseInfo;", "initialize", "(Landroid/app/Application;)Lio/scanbot/sap/SdkLicenseInfo;", "Lio/scanbot/sdk/docprocessing/draft/DocumentDraftExtractor;", "extractor", "documentDraftExtractor", "(Lio/scanbot/sdk/docprocessing/draft/DocumentDraftExtractor;)Lio/scanbot/sdk/ScanbotSDKInitializer;", "Ljava/io/File;", "sdkFilesDirectory", "(Landroid/app/Application;Ljava/io/File;)Lio/scanbot/sdk/ScanbotSDKInitializer;", "Lio/scanbot/sdk/util/log/Logger;", "logger", "(Lio/scanbot/sdk/util/log/Logger;)Lio/scanbot/sdk/ScanbotSDKInitializer;", "Lio/scanbot/sdk/persistence/PageStorageSettings;", "pageStorageSettings", "usePageStorageSettings", "(Lio/scanbot/sdk/persistence/PageStorageSettings;)Lio/scanbot/sdk/ScanbotSDKInitializer;", "Z", "getUseLog", "()Z", "setUseLog", "(Z)V", "Lio/scanbot/sdk/util/log/Logger;", "getLogger", "()Lio/scanbot/sdk/util/log/Logger;", "setLogger", "(Lio/scanbot/sdk/util/log/Logger;)V", "licenseSet", "Lio/scanbot/sdk/ocr/intelligence/OcrSettings;", "Lio/scanbot/sap/IScanbotSDKLicenseErrorHandler;", "Lio/scanbot/sdk/ui/camera/CameraUiSettings;", "cameraUiSettings", "Lio/scanbot/sdk/ui/camera/CameraUiSettings;", "Lio/scanbot/sdk/core/contourdetector/ContourDetector$Type;", "Lkotlinx/coroutines/CoroutineScope;", "mainScope", "Lkotlinx/coroutines/CoroutineScope;", "Lio/scanbot/sdk/docprocessing/draft/DocumentDraftExtractor;", "Lio/scanbot/sdk/process/ImageProcessor$Type;", "precompilingGpuMlModelsCallback", "Lkotlin/jvm/functions/Function0;", "<init>", "Companion", "PrepareBlobsTask", "sdk-bundle_release"})
public final class ScanbotSDKInitializer {
    private static boolean initialized;
    private static final ExecutorCoroutineDispatcher singleThreadDispatcher;
    @NotNull
    public static final Companion Companion;
    private boolean enableNativeLogging;
    private boolean useLog;
    @Nullable
    private Logger logger;
    private boolean licenseSet;
    private boolean prepareOCRLanguagesBlobs;
    private boolean prepareMRZBlobs;
    private boolean preparePayFormBlobs;
    private boolean allowXnnpackAcceleration = true;
    private boolean allowGpuAcceleration = true;
    private boolean precompileGpuMlModels;
    private Function0<Unit> precompilingGpuMlModelsCallback;
    private ContourDetector.Type contourDetectorType = ContourDetector.Type.ML_BASED;
    private ImageProcessor.Type imageProcessorType = ImageProcessor.Type.BASE;
    private OcrSettings ocrSettings = new OcrSettings.Builder().build();
    private IScanbotSDKLicenseErrorHandler licenseErrorHandler;
    private DocumentDraftExtractor documentDraftExtractor;
    private CameraUiSettings cameraUiSettings = new CameraUiSettings(false);
    private final CoroutineScope mainScope = CoroutineScopeKt.MainScope();

    public static /* synthetic */ ScanbotSDKInitializer withLogging$default(ScanbotSDKInitializer scanbotSDKInitializer, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl2 = false;
        }
        return scanbotSDKInitializer.withLogging(bl, bl2);
    }

    public static /* synthetic */ ScanbotSDKInitializer useFileEncryption$default(ScanbotSDKInitializer scanbotSDKInitializer, boolean bl, FileIOProcessor fileIOProcessor, int n, Object object) {
        if ((n & 2) != 0) {
            fileIOProcessor = null;
        }
        return scanbotSDKInitializer.useFileEncryption(bl, fileIOProcessor);
    }

    public static /* synthetic */ ScanbotSDKInitializer precompileGpuMlModels$default(ScanbotSDKInitializer scanbotSDKInitializer, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            function0 = a.a;
        }
        return scanbotSDKInitializer.precompileGpuMlModels((Function0<Unit>)function0);
    }

    private final void loadNativeLibraries() {
        System.loadLibrary("tflite");
        System.loadLibrary("scanbotsdk");
    }

    /*
     * WARNING - void declaration
     */
    private final void prepareBlobs(Application application) {
        void var1_1;
        Function2<CoroutineScope, Continuation<? super Unit>, Object> function2;
        Function2<CoroutineScope, Continuation<? super Unit>, Object> function22 = function2;
        function2 = new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, (Application)var1_1, null){
            int a;
            final /* synthetic */ ScanbotSDKInitializer b;
            final /* synthetic */ Application c;
            {
                this.b = scanbotSDKInitializer;
                this.c = application;
                super(2, continuation);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                if (object2.a == 0) {
                    ResultKt.throwOnFailure((Object)object);
                    b b2 = object2;
                    Object object2 = b2.b;
                    new PrepareBlobsTask((ScanbotSDKInitializer)object2, b2.c).prepareBlobs();
                    return Unit.INSTANCE;
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                void var2_2;
                Intrinsics.checkNotNullParameter(completion, (String)"completion");
                b b2 = object;
                Object object = b2.b;
                return new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        };
        BuildersKt.launch$default((CoroutineScope)this.mainScope, (CoroutineContext)singleThreadDispatcher, null, (Function2)function22, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void prepareTensorFlow(Application application) {
        ScanbotSDKInitializer scanbotSDKInitializer = this;
        boolean bl = scanbotSDKInitializer.allowXnnpackAcceleration;
        TensorFlowUtils.Companion.prepareTensorFlow(bl, scanbotSDKInitializer.allowGpuAcceleration);
        if (this.precompileGpuMlModels) {
            void var1_1;
            Function2<CoroutineScope, Continuation<? super Unit>, Object> function2;
            Function2<CoroutineScope, Continuation<? super Unit>, Object> function22 = function2;
            function2 = new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, (Application)var1_1, null){
                int a;
                final /* synthetic */ ScanbotSDKInitializer b;
                final /* synthetic */ Application c;
                {
                    this.b = scanbotSDKInitializer;
                    this.c = application;
                    super(2, continuation);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    int n = this.a;
                    if (n != 0) {
                        if (n != 1) throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        ResultKt.throwOnFailure((Object)object);
                        return Unit.INSTANCE;
                    } else {
                        Function2<CoroutineScope, Continuation<? super Unit>, Object> function2;
                        ResultKt.throwOnFailure((Object)object);
                        File file = this.c.getCodeCacheDir();
                        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"application.codeCacheDir");
                        String string = file.getAbsolutePath();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"application.codeCacheDir.absolutePath");
                        TensorFlowUtils.Companion.precompilePrograms(string);
                        Function2<CoroutineScope, Continuation<? super Unit>, Object> function22 = function2;
                        function2 = new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                            int a;
                            final /* synthetic */ c b;
                            {
                                this.b = c2;
                                super(2, continuation);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                if (this.a == 0) {
                                    ResultKt.throwOnFailure((Object)object);
                                    ScanbotSDKInitializer.access$getPrecompilingGpuMlModelsCallback$p(this.b.b).invoke();
                                    return Unit.INSTANCE;
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            /*
                             * WARNING - void declaration
                             */
                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                                void var2_2;
                                Intrinsics.checkNotNullParameter(completion, (String)"completion");
                                return new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(Object object, Object object2) {
                                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                            }
                        };
                        this.a = 1;
                        if (BuildersKt.withContext((CoroutineContext)Dispatchers.getMain(), (Function2)function22, (Continuation)this) != object2) return Unit.INSTANCE;
                        return object2;
                    }
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                    void var2_2;
                    Intrinsics.checkNotNullParameter(completion, (String)"completion");
                    c c2 = object;
                    Object object = c2.b;
                    return new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(Object object, Object object2) {
                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                }
            };
            BuildersKt.launch$default((CoroutineScope)this.mainScope, (CoroutineContext)singleThreadDispatcher, null, (Function2)function22, (int)2, null);
        }
    }

    static {
        Companion = new Companion(null);
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"Executors.newSingleThreadExecutor()");
        singleThreadDispatcher = ExecutorsKt.from((ExecutorService)executorService);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setPrepareOCRLanguagesBlobs$p(ScanbotSDKInitializer $this, boolean bl) {
        void var1_1;
        $this.prepareOCRLanguagesBlobs = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setPrepareMRZBlobs$p(ScanbotSDKInitializer $this, boolean bl) {
        void var1_1;
        $this.prepareMRZBlobs = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setPreparePayFormBlobs$p(ScanbotSDKInitializer $this, boolean bl) {
        void var1_1;
        $this.preparePayFormBlobs = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setImageProcessorType$p(ScanbotSDKInitializer $this, ImageProcessor.Type type) {
        void var1_1;
        $this.imageProcessorType = var1_1;
    }

    public static final /* synthetic */ Function0 access$getPrecompilingGpuMlModelsCallback$p(ScanbotSDKInitializer $this) {
        Function0<Unit> function0 = $this.precompilingGpuMlModelsCallback;
        if (function0 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"precompilingGpuMlModelsCallback");
        }
        return function0;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setPrecompilingGpuMlModelsCallback$p(ScanbotSDKInitializer $this, Function0 function0) {
        void var1_1;
        $this.precompilingGpuMlModelsCallback = var1_1;
    }

    public static final /* synthetic */ void access$setInitialized$cp(boolean bl) {
        initialized = bl;
    }

    @JvmStatic
    public static final boolean isInitialized() {
        return Companion.isInitialized();
    }

    protected final boolean getUseLog() {
        return this.useLog;
    }

    /*
     * WARNING - void declaration
     */
    protected final void setUseLog(boolean bl) {
        void var1_1;
        this.useLog = var1_1;
    }

    @Nullable
    protected final Logger getLogger() {
        return this.logger;
    }

    /*
     * WARNING - void declaration
     */
    protected final void setLogger(@Nullable Logger logger) {
        void var1_1;
        this.logger = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ScanbotSDKInitializer withLogging(boolean useLog, boolean enableNativeLogging) {
        void var2_3;
        void var1_1;
        if (useLog) {
            Log.w((String)"Scanbot SDK", (String)"Logging enabled in non-debug build, consider switching it off");
        }
        ScanbotSDKInitializer scanbotSDKInitializer = this;
        scanbotSDKInitializer.useLog = var1_1;
        scanbotSDKInitializer.enableNativeLogging = var2_3;
        if (var1_1 == false) {
            StubLogger stubLogger;
            StubLogger stubLogger2 = stubLogger;
            stubLogger = new StubLogger();
            this.logger = stubLogger2;
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ScanbotSDKInitializer license(@NotNull Application application, @NotNull String license) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"application");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"license");
        PreferenceManager.getDefaultSharedPreferences((Context)var1_1).edit().putString("SCANBOT_SDK_LICENSE_KEY", (String)var2_2).apply();
        this.licenseSet = true;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ScanbotSDKInitializer licenceErrorHandler(@NotNull IScanbotSDKLicenseErrorHandler licenseErrorHandler) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"licenseErrorHandler");
        this.licenseErrorHandler = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ScanbotSDKInitializer ocrBlobsPath(@NotNull Application application, @NotNull String ocrBlobsPath) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"application");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"ocrBlobsPath");
        PreferenceManager.getDefaultSharedPreferences((Context)var1_1).edit().putString("SCANBOT_SDK_OCR_BLOBS_PATH", (String)var2_2).apply();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ScanbotSDKInitializer prepareOCRLanguagesBlobs(boolean prepareOCRLanguagesBlobs) {
        void var1_1;
        this.prepareOCRLanguagesBlobs = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ScanbotSDKInitializer useOcrSettings(@NotNull OcrSettings ocrSettings) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"ocrSettings");
        this.ocrSettings = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ScanbotSDKInitializer prepareMRZBlobs(boolean prepareMRZBlobs) {
        void var1_1;
        this.prepareMRZBlobs = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ScanbotSDKInitializer preparePayFormBlobs(boolean preparePayFormBlobs) {
        void var1_1;
        this.preparePayFormBlobs = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ScanbotSDKInitializer contourDetectorType(@NotNull ContourDetector.Type type) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"type");
        this.contourDetectorType = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ScanbotSDKInitializer imageProcessorType(@NotNull ImageProcessor.Type type) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"type");
        this.imageProcessorType = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ScanbotSDKInitializer useFileEncryption(boolean enableFileEncryption, @Nullable FileIOProcessor fileIOProcessor) {
        void var1_1;
        FileStorageSettings.Builder builder = new FileStorageSettings.Builder().useFileEncryption((boolean)var1_1);
        if (fileIOProcessor != null) {
            void var2_3;
            builder.useCustomFileIOProcessor((FileIOProcessor)var2_3);
        }
        SdkStorageModule.Companion.setFileStorageSettings(builder.build());
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ScanbotSDKInitializer allowXnnpackAcceleration(boolean enable) {
        void var1_1;
        this.allowXnnpackAcceleration = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ScanbotSDKInitializer useCameraXRtuUi(boolean enable) {
        void var1_1;
        CameraUiSettings cameraUiSettings;
        ScanbotSDKInitializer scanbotSDKInitializer = this_;
        ScanbotSDKInitializer this_ = cameraUiSettings;
        cameraUiSettings = new CameraUiSettings((boolean)var1_1);
        scanbotSDKInitializer.cameraUiSettings = this_;
        return scanbotSDKInitializer;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ScanbotSDKInitializer allowGpuAcceleration(boolean enable) {
        void var1_1;
        this.allowGpuAcceleration = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ScanbotSDKInitializer precompileGpuMlModels(@NotNull Function0<Unit> precompilingCallback) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"precompilingCallback");
        this.precompilingGpuMlModelsCallback = var1_1;
        this.precompileGpuMlModels = true;
        return this;
    }

    @NotNull
    public final SdkLicenseInfo initialize(@NotNull Application application) {
        ScanbotSdkModule.Companion companion;
        Intrinsics.checkNotNullParameter((Object)companion, (String)"application");
        Logger logger = this.logger;
        if (logger == null) {
            if (this.useLog) {
                DebugLog debugLog;
                logger = debugLog;
                debugLog = new DebugLog((Context)companion);
            } else {
                StubLogger stubLogger;
                logger = stubLogger;
                stubLogger = new StubLogger();
            }
        }
        LoggerProvider.setLogger((Logger)logger);
        if (!this.licenseSet) {
            PreferenceManager.getDefaultSharedPreferences((Context)companion).edit().remove("SCANBOT_SDK_LICENSE_KEY").apply();
        }
        ScanbotSDKInitializer scanbotSDKInitializer = this;
        scanbotSDKInitializer.loadNativeLibraries();
        logger = LoggerProvider.getLogger();
        if (scanbotSDKInitializer.enableNativeLogging) {
            NativeLogger.setNativeLogger((Logger)logger);
        }
        SapSingleton.initializeSapManager((Context)companion);
        SapManager sapManager = SapSingleton.getInstance();
        sapManager.setLicenceErrorHandler((SDKLicenseErrorHandler)new SDKLicenseErrorHandlerImpl(this.licenseErrorHandler, logger));
        initialized = true;
        this.prepareBlobs((Application)companion);
        this.prepareTensorFlow((Application)companion);
        SdkLicenseInfo sdkLicenseInfo = sapManager.getLicenseStatus();
        logger.i("ScanbotSDKInitializer", sdkLicenseInfo.getLicenseStatusMessage());
        companion = ScanbotSdkModule.Companion;
        companion.setDocumentDraftExtractor(this.documentDraftExtractor);
        companion.setOcrSettings(this.ocrSettings);
        companion.setCameraUiSettings(this.cameraUiSettings);
        companion.setContourDetectorSettings(new ContourDetectorSettings.Builder().useType(this.contourDetectorType).build());
        companion.setImageProcessorSettings(new ImageProcessorSettings.Builder().useType(this.imageProcessorType).build());
        Intrinsics.checkNotNullExpressionValue((Object)sdkLicenseInfo, (String)"licenseStatus");
        return sdkLicenseInfo;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ScanbotSDKInitializer documentDraftExtractor(@NotNull DocumentDraftExtractor extractor) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"extractor");
        this.documentDraftExtractor = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ScanbotSDKInitializer sdkFilesDirectory(@NotNull Application application, @NotNull File sdkFilesDirectory) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"application");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"sdkFilesDirectory");
        PreferenceManager.getDefaultSharedPreferences((Context)var1_1).edit().putString("CUSTOM_SDK_FILES_PATH", var2_2.getPath()).apply();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ScanbotSDKInitializer logger(@NotNull Logger logger) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"logger");
        this.logger = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ScanbotSDKInitializer usePageStorageSettings(@NotNull PageStorageSettings pageStorageSettings) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"pageStorageSettings");
        SdkStorageModule.Companion.setPageStorageSettings((PageStorageSettings)var1_1);
        return this;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u001e\u001a\u00020\u001d\u00a2\u0006\u0004\b\"\u0010#J5\u0010\f\u001a\u00020\u000b2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\f\u0010\rJ-\u0010\f\u001a\u00020\u000b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\f\u0010\u0011J\u0017\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J&\u0010\u0019\u001a\u00020\u000b2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0018\u001a\u00020\u0017H\u0082\b\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\r\u0010\u001b\u001a\u00020\u000b\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u0019\u0010\u001e\u001a\u00020\u001d8\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010!\u00a8\u0006$"}, d2={"Lio/scanbot/sdk/ScanbotSDKInitializer$PrepareBlobsTask;", "", "", "Lio/scanbot/sdk/blob/BlobType;", "types", "Lio/scanbot/sdk/blob/BlobFactory;", "blobFactory", "Lio/scanbot/sdk/blob/BlobManager;", "blobManager", "Lio/scanbot/sdk/util/log/Logger;", "logger", "", "fetchBlobs", "(Ljava/util/List;Lio/scanbot/sdk/blob/BlobFactory;Lio/scanbot/sdk/blob/BlobManager;Lio/scanbot/sdk/util/log/Logger;)V", "", "Lio/scanbot/sdk/entity/Blob;", "blobs", "(Ljava/util/Collection;Lio/scanbot/sdk/blob/BlobManager;Lio/scanbot/sdk/util/log/Logger;)V", "cleanupDeprecatedBlobs", "(Lio/scanbot/sdk/blob/BlobManager;)V", "Lkotlin/Function0;", "Ljava/io/File;", "blobLazySafeGetter", "", "isDirectory", "cleanupBlob", "(Lkotlin/jvm/functions/Function0;Z)V", "prepareBlobs", "()V", "Landroid/app/Application;", "application", "Landroid/app/Application;", "getApplication", "()Landroid/app/Application;", "<init>", "(Lio/scanbot/sdk/ScanbotSDKInitializer;Landroid/app/Application;)V", "sdk-bundle_release"})
    public final class PrepareBlobsTask {
        @NotNull
        private final Application application;
        final /* synthetic */ ScanbotSDKInitializer this$0;

        /*
         * WARNING - void declaration
         */
        private final void fetchBlobs(List<? extends BlobType> types, BlobFactory blobFactory, BlobManager blobManager, Logger logger) {
            void var3_3;
            void var4_4;
            ArrayList<Blob> arrayList;
            ArrayList<Blob> arrayList2 = arrayList;
            arrayList = new ArrayList<Blob>();
            for (BlobType blobType : types) {
                try {
                    void var2_2;
                    arrayList2.addAll(var2_2.getBlobsForType(blobType));
                }
                catch (IOException iOException) {
                    void v1 = var4_4;
                    v1.logException((Throwable)iOException);
                    v1.e("PrepareBlobsTask", "Could not fetch " + blobType + " blobs!");
                }
            }
            this.fetchBlobs(arrayList2, (BlobManager)var3_3, (Logger)var4_4);
        }

        /*
         * WARNING - void declaration
         */
        private final void fetchBlobs(Collection<Blob> blobs, BlobManager blobManager, Logger logger) {
            for (Blob blob : blobs) {
                try {
                    void var2_2;
                    var2_2.fetch(blob);
                }
                catch (IOException iOException) {
                    void var3_3;
                    void v0 = var3_3;
                    v0.logException((Throwable)iOException);
                    v0.e("PrepareBlobsTask", "Could not fetch blob! /n Blob local path: " + blob.getLocalPath() + " /n Blob remote path: " + blob.getRemotePath());
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void cleanupDeprecatedBlobs(BlobManager blobManager) {
            void var1_1;
            try {
                FileUtils.deleteQuietly((File)blobManager.getDocumentDetectorModelFile());
            }
            catch (IOException iOException) {}
            try {
                FileUtils.deleteQuietly((File)var1_1.getBarcodeBinarizationModelFile());
            }
            catch (IOException iOException) {}
            try {
                FileUtils.deleteQuietly((File)var1_1.getFilterPredictionModelFile());
            }
            catch (IOException iOException) {}
            try {
                FileUtils.deleteQuietly((File)var1_1.getBarcodeDetectionModelFile());
            }
            catch (IOException iOException) {}
            try {
                FileUtils.deleteDirectory((File)var1_1.getIdCardScannerModelsFolderFile());
            }
            catch (IOException iOException) {}
            try {
                FileUtils.deleteDirectory((File)var1_1.getGenericTextRecognizerModelsFolderFile());
            }
            catch (IOException iOException) {}
            try {
                FileUtils.deleteDirectory((File)var1_1.getDcModelsFolderFile());
            }
            catch (IOException iOException) {}
            try {
                FileUtils.deleteQuietly((File)var1_1.getBlurEstimatorModelFile());
            }
            catch (IOException iOException) {}
            try {
                FileUtils.deleteQuietly((File)var1_1.getCheckDigitPredictionModelFile());
            }
            catch (IOException iOException) {}
        }

        private final void cleanupBlob(Function0<? extends File> blobLazySafeGetter, boolean isDirectory) {
            File file;
            boolean $i$f$cleanupBlob = false;
            try {
                file = (File)blobLazySafeGetter.invoke();
            }
            catch (IOException e2) {
                return;
            }
            File blobFile = file;
            try {
                if (isDirectory) {
                    FileUtils.deleteDirectory((File)blobFile);
                } else {
                    FileUtils.deleteQuietly((File)blobFile);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        /*
         * WARNING - void declaration
         */
        public PrepareBlobsTask(@NotNull ScanbotSDKInitializer this$0, Application application) {
            void var1_1;
            void var2_2;
            Intrinsics.checkNotNullParameter((Object)var2_2, (String)"application");
            this.this$0 = var1_1;
            this.application = var2_2;
        }

        public final void prepareBlobs() {
            ScanbotSDK scanbotSDK = new ScanbotSDK(this.application);
            BlobManager blobManager = scanbotSDK.createBlobManager();
            BlobFactory blobFactory = scanbotSDK.createBlobFactory();
            Logger logger = LoggerProvider.getLogger();
            if (this.this$0.prepareOCRLanguagesBlobs) {
                this.fetchBlobs(CollectionsKt.listOf((Object[])new BlobType[]{BlobType.OCR_BLOBS, BlobType.PDF_FONT}), blobFactory, blobManager, logger);
            }
            if (this.this$0.prepareMRZBlobs) {
                this.fetchBlobs(CollectionsKt.listOf((Object[])new BlobType[]{BlobType.MRZ_CASCADE, BlobType.MRZ_TRAINEDDATA}), blobFactory, blobManager, logger);
            }
            if (this.this$0.preparePayFormBlobs) {
                this.fetchBlobs(CollectionsKt.listOf((Object)BlobType.BANKS_DATA), blobFactory, blobManager, logger);
            }
            if (this.this$0.imageProcessorType == ImageProcessor.Type.ML_BASED) {
                if (blobFactory.isAvailableInAssets(BlobType.IMAGE_PROCESSOR_MODELS)) {
                    this.fetchBlobs(CollectionsKt.listOf((Object)BlobType.IMAGE_PROCESSOR_MODELS), blobFactory, blobManager, logger);
                } else {
                    throw new ImageProcessorBlobRuntimeException("Could not fetch image processor Model blobs! Please, check that you added dependency on io.scanbot:sdk-ml-imageprocessor-assets:VERSION");
                }
            }
            this.cleanupDeprecatedBlobs(blobManager);
        }

        @NotNull
        public final Application getApplication() {
            return this.application;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\u0003\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004R\u0016\u0010\u0005\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0016\u0010\b\u001a\u00020\u00078\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Lio/scanbot/sdk/ScanbotSDKInitializer$Companion;", "", "", "isInitialized", "()Z", "initialized", "Z", "Lkotlinx/coroutines/ExecutorCoroutineDispatcher;", "singleThreadDispatcher", "Lkotlinx/coroutines/ExecutorCoroutineDispatcher;", "<init>", "()V", "sdk-bundle_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @JvmStatic
        public final boolean isInitialized() {
            return initialized;
        }
    }
}

