/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.di;

import android.app.Application;
import android.content.Context;
import android.preference.PreferenceManager;
import dagger.Module;
import dagger.Provides;
import io.scanbot.sdk.exceptions.crypto.EncryptionInitException;
import io.scanbot.sdk.persistence.CustomDraftPageStorage;
import io.scanbot.sdk.persistence.CustomPageStorage;
import io.scanbot.sdk.persistence.DraftPageStorage;
import io.scanbot.sdk.persistence.FileStorageSettings;
import io.scanbot.sdk.persistence.InternalDraftPageStorage;
import io.scanbot.sdk.persistence.InternalPageStorage;
import io.scanbot.sdk.persistence.PageFileStorage;
import io.scanbot.sdk.persistence.PageStorage;
import io.scanbot.sdk.persistence.PageStorageProcessor;
import io.scanbot.sdk.persistence.PageStorageSettings;
import io.scanbot.sdk.persistence.fileio.DefaultFileIOProcessor;
import io.scanbot.sdk.persistence.fileio.EncryptedFileIOProcessor;
import io.scanbot.sdk.persistence.fileio.FileIOProcessor;
import io.scanbot.sdk.persistence.fileio.ImageFileIOProcessor;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Module
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\b\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0007J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\nH\u0007J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\bH\u0007J\b\u0010\u0015\u001a\u00020\bH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/scanbot/sdk/di/SdkStorageModule;", "", "application", "Landroid/app/Application;", "(Landroid/app/Application;)V", "provideDraftPageStorage", "Lio/scanbot/sdk/persistence/DraftPageStorage;", "pageStorageSettings", "Lio/scanbot/sdk/persistence/PageStorageSettings;", "provideFileIOProcessor", "Lio/scanbot/sdk/persistence/fileio/FileIOProcessor;", "provideImageFileIOProcessor", "Lio/scanbot/sdk/persistence/fileio/ImageFileIOProcessor;", "fileIOProcessor", "providePageFileStorage", "Lio/scanbot/sdk/persistence/PageFileStorage;", "pageStorageProcessor", "Lio/scanbot/sdk/persistence/PageStorageProcessor;", "pageStorage", "Lio/scanbot/sdk/persistence/PageStorage;", "providePageStorage", "providePageStorageSettings", "Companion", "sdk-bundle_release"})
public final class SdkStorageModule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private static PageStorageSettings a;
    @NotNull
    private static FileStorageSettings b;
    @NotNull
    private final Application c;

    /*
     * WARNING - void declaration
     */
    public SdkStorageModule(@NotNull Application application) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"application");
        this.c = var1_1;
    }

    @JvmStatic
    public static final void setPageStorageSettings(@NotNull PageStorageSettings pageStorageSettings) {
        PageStorageSettings pageStorageSettings2;
        Companion.setPageStorageSettings(pageStorageSettings2);
    }

    @JvmStatic
    public static final void setFileStorageSettings(@NotNull FileStorageSettings fileStorageSettings) {
        FileStorageSettings fileStorageSettings2;
        Companion.setFileStorageSettings(fileStorageSettings2);
    }

    static {
        b = new FileStorageSettings.Builder().useFileEncryption(false).build();
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @Singleton
    @NotNull
    public final PageStorage providePageStorage(@NotNull PageStorageSettings pageStorageSettings) {
        CustomPageStorage customPageStorage;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"pageStorageSettings");
        if (PreferenceManager.getDefaultSharedPreferences((Context)this.c).contains("CUSTOM_SDK_FILES_PATH")) {
            CustomPageStorage customPageStorage2;
            customPageStorage = customPageStorage2;
            customPageStorage2 = new CustomPageStorage(this.c, (PageStorageSettings)var1_1);
        } else {
            InternalPageStorage internalPageStorage;
            customPageStorage = internalPageStorage;
            internalPageStorage = new InternalPageStorage(this.c, (PageStorageSettings)var1_1);
        }
        return customPageStorage;
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @Singleton
    @NotNull
    public final DraftPageStorage provideDraftPageStorage(@NotNull PageStorageSettings pageStorageSettings) {
        CustomDraftPageStorage customDraftPageStorage;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"pageStorageSettings");
        if (PreferenceManager.getDefaultSharedPreferences((Context)this.c).contains("CUSTOM_SDK_FILES_PATH")) {
            CustomDraftPageStorage customDraftPageStorage2;
            customDraftPageStorage = customDraftPageStorage2;
            customDraftPageStorage2 = new CustomDraftPageStorage(this.c, (PageStorageSettings)var1_1);
        } else {
            InternalDraftPageStorage internalDraftPageStorage;
            customDraftPageStorage = internalDraftPageStorage;
            internalDraftPageStorage = new InternalDraftPageStorage(this.c, (PageStorageSettings)var1_1);
        }
        return customDraftPageStorage;
    }

    @Provides
    @Singleton
    @NotNull
    public final PageStorageSettings providePageStorageSettings() {
        SdkStorageModule sdkStorageModule = a;
        if (sdkStorageModule == null) {
            sdkStorageModule = new PageStorageSettings.Builder().build();
        }
        return sdkStorageModule;
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @Singleton
    @NotNull
    public final PageFileStorage providePageFileStorage(@NotNull PageStorageProcessor pageStorageProcessor, @NotNull PageStorage pageStorage, @NotNull FileIOProcessor fileIOProcessor) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"pageStorageProcessor");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"pageStorage");
        Intrinsics.checkNotNullParameter((Object)fileIOProcessor, (String)"fileIOProcessor");
        return new PageFileStorage((PageStorageProcessor)var1_1, (PageStorage)var2_2, (FileIOProcessor)var3_3);
    }

    @Provides
    @Singleton
    @NotNull
    public final FileIOProcessor provideFileIOProcessor() {
        if (b.getEncryptionEnabled()) {
            if (b.getCustomFileIOProcessor() != null) {
                FileIOProcessor fileIOProcessor = b.getCustomFileIOProcessor();
                Intrinsics.checkNotNull((Object)fileIOProcessor);
                return fileIOProcessor;
            }
            try {
                return new EncryptedFileIOProcessor((Context)this.c);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                throw new EncryptionInitException("Could not initialize an encrypted image storage! Please, check that you added dependency on io.scanbot:sdk-crypto-persistence:VERSION");
            }
        }
        return new DefaultFileIOProcessor((Context)this.c);
    }

    @Provides
    @Singleton
    @NotNull
    public final ImageFileIOProcessor provideImageFileIOProcessor(@NotNull FileIOProcessor fileIOProcessor) {
        FileIOProcessor fileIOProcessor2 = fileIOProcessor;
        Intrinsics.checkNotNullParameter((Object)fileIOProcessor2, (String)"fileIOProcessor");
        return fileIOProcessor2;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u0004H\u0007J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lio/scanbot/sdk/di/SdkStorageModule$Companion;", "", "()V", "fileStorageSettings", "Lio/scanbot/sdk/persistence/FileStorageSettings;", "pageStorageSettings", "Lio/scanbot/sdk/persistence/PageStorageSettings;", "setFileStorageSettings", "", "setPageStorageSettings", "sdk-bundle_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @JvmStatic
        public final void setPageStorageSettings(@NotNull PageStorageSettings pageStorageSettings) {
            PageStorageSettings pageStorageSettings2 = pageStorageSettings;
            Intrinsics.checkNotNullParameter((Object)pageStorageSettings2, (String)"pageStorageSettings");
            a = pageStorageSettings2;
        }

        @JvmStatic
        public final void setFileStorageSettings(@NotNull FileStorageSettings fileStorageSettings) {
            FileStorageSettings fileStorageSettings2 = fileStorageSettings;
            Intrinsics.checkNotNullParameter((Object)fileStorageSettings2, (String)"fileStorageSettings");
            b = fileStorageSettings2;
        }
    }
}

