/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import io.scanbot.sdk.bundle.R;
import io.scanbot.sdk.ui.EditPolygonImageView;
import io.scanbot.sdk.util.bitmap.BitmapUtils;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001(B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u0010\u0010\u0018\u001a\u00020\u00152\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u0006\u0010\u0019\u001a\u00020\u0015J\b\u0010\u001a\u001a\u00020\u0015H\u0016J\b\u0010\u001b\u001a\u00020\u0015H\u0016J0\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\f2\u0006\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\fH\u0014J\u000e\u0010\"\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010#\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\u0010J\u000e\u0010%\u001a\u00020\u00152\u0006\u0010&\u001a\u00020'R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00060\nR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lio/scanbot/sdk/ui/MagnifierView;", "Landroid/view/View;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "enableBounding", "", "magnifier", "Lio/scanbot/sdk/ui/MagnifierView$Magnifier;", "magnifierDrawableResourceId", "", "magnifierFrameBitmap", "Landroid/graphics/Bitmap;", "magnifierMargin", "", "magnifierRadius", "zoomPoint", "Landroid/graphics/PointF;", "dispatchDraw", "", "canvas", "Landroid/graphics/Canvas;", "drawMagnifier", "eraseMagnifier", "onAttachedToWindow", "onDetachedFromWindow", "onLayout", "changed", "left", "top", "right", "bottom", "setEnableBounding", "setImageRotation", "rotation", "setupMagnifier", "view", "Lio/scanbot/sdk/ui/EditPolygonImageView;", "Magnifier", "sdk-bundle_release"})
public final class MagnifierView
extends View {
    private float magnifierRadius;
    private float magnifierMargin;
    private int magnifierDrawableResourceId;
    @NotNull
    private final a magnifier;
    @Nullable
    private PointF zoomPoint;
    @Nullable
    private Bitmap magnifierFrameBitmap;
    private boolean enableBounding;

    /*
     * WARNING - void declaration
     */
    public MagnifierView(@NotNull Context context, @Nullable AttributeSet attrs) {
        void var2_2;
        TypedArray typedArray;
        Intrinsics.checkNotNullParameter((Object)typedArray, (String)"context");
        super((Context)typedArray, (AttributeSet)var2_2);
        this.magnifier = new a(this);
        TypedArray typedArray2 = typedArray = context.getTheme().obtainStyledAttributes((AttributeSet)var2_2, R.styleable.MagnifierView, 0, 0);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray2, (String)"context.theme.obtainStyl\u2026ew,\n                0, 0)");
        try {
            this.magnifierDrawableResourceId = typedArray2.getResourceId(R.styleable.MagnifierView_magnifierImageSrc, 0);
            this.magnifierRadius = typedArray.getDimension(R.styleable.MagnifierView_magnifierRadius, this.getResources().getDimension(R.dimen.magnifier_raduis));
            this.magnifierMargin = typedArray.getDimension(R.styleable.MagnifierView_magnifierMargin, this.getResources().getDimension(R.dimen.magnifier_margin));
            this.enableBounding = typedArray.getBoolean(R.styleable.MagnifierView_magnifierEnableBounding, true);
        }
        catch (Throwable throwable) {
            typedArray.recycle();
            throw throwable;
        }
        typedArray.recycle();
    }

    /*
     * WARNING - void declaration
     */
    public final void drawMagnifier(@Nullable PointF zoomPoint) {
        void var1_1;
        this.zoomPoint = var1_1;
        this.invalidate();
    }

    public final void eraseMagnifier() {
        this.zoomPoint = null;
        this.invalidate();
    }

    /*
     * WARNING - void declaration
     */
    public final void setImageRotation(float rotation) {
        void var1_1;
        MagnifierView magnifierView = this;
        magnifierView.magnifier.a((float)var1_1);
        magnifierView.invalidate();
    }

    /*
     * WARNING - void declaration
     */
    public final void setupMagnifier(@NotNull EditPolygonImageView view) {
        void var1_1;
        MagnifierView magnifierView = magnifierView2;
        void v1 = var1_1;
        Intrinsics.checkNotNullParameter((Object)v1, (String)"view");
        Drawable drawable = v1.getDrawable();
        Intrinsics.checkNotNullExpressionValue((Object)drawable, (String)"view.drawable");
        MagnifierView magnifierView2 = BitmapUtils.drawableToBitmap((Drawable)drawable);
        magnifierView.magnifier.a((Bitmap)magnifierView2, var1_1.getRotation(), -16777216);
        view.setMagnifier(magnifierView);
    }

    /*
     * WARNING - void declaration
     */
    protected void dispatchDraw(@NotNull Canvas canvas) {
        Unit unit;
        void var1_1;
        MagnifierView magnifierView = this;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"canvas");
        super.dispatchDraw((Canvas)var1_1);
        PointF pointF = magnifierView.zoomPoint;
        if (pointF == null) {
            unit = null;
        } else {
            this.magnifier.a((Canvas)var1_1, pointF);
            unit = Unit.INSTANCE;
        }
        if (unit == null) {
            var1_1.drawColor(0);
        }
    }

    public void onAttachedToWindow() {
        BitmapFactory.Options options;
        MagnifierView magnifierView = this;
        super.onAttachedToWindow();
        BitmapFactory.Options options2 = options;
        new BitmapFactory.Options().inPreferredConfig = Bitmap.Config.ARGB_8888;
        this.magnifierFrameBitmap = BitmapFactory.decodeResource((Resources)magnifierView.getResources(), (int)this.magnifierDrawableResourceId, (BitmapFactory.Options)options2);
        if (this.magnifierFrameBitmap == null) {
            Drawable drawable = this.getResources().getDrawable(this.magnifierDrawableResourceId);
            Intrinsics.checkNotNullExpressionValue((Object)drawable, (String)"resources.getDrawable(magnifierDrawableResourceId)");
            this.magnifierFrameBitmap = BitmapUtils.drawableToBitmap((Drawable)drawable);
        }
    }

    public void onDetachedFromWindow() {
        MagnifierView magnifierView = this;
        super.onDetachedFromWindow();
        Bitmap bitmap = magnifierView.magnifierFrameBitmap;
        if (bitmap != null) {
            bitmap.recycle();
        }
        this.magnifierFrameBitmap = null;
        this.magnifier.a();
    }

    /*
     * WARNING - void declaration
     */
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        MagnifierView magnifierView = this;
        super.onLayout((boolean)var1_1, (int)var2_2, (int)var3_3, (int)var4_4, (int)var5_5);
        magnifierView.magnifier.a(this.getWidth() - this.getPaddingLeft() - this.getPaddingRight(), this.getHeight() - this.getPaddingTop() - this.getPaddingBottom());
    }

    /*
     * WARNING - void declaration
     */
    public final void setEnableBounding(boolean enableBounding) {
        void var1_1;
        this.enableBounding = var1_1;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\b\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0014\u001a\u00020\u0015J\u0016\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u00072\b\u0010\u001c\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001d\u001a\u00020\u0012H\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001aH\u0002J\u000e\u0010!\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\u0004J\u0016\u0010\"\u001a\u00020\u00152\u0006\u0010#\u001a\u00020\u00122\u0006\u0010$\u001a\u00020\u0012J \u0010%\u001a\u00020\u00152\b\u0010\u001c\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lio/scanbot/sdk/ui/MagnifierView$Magnifier;", "", "(Lio/scanbot/sdk/ui/MagnifierView;)V", "ZOOM", "", "bitmapScale", "magnifierBitmap", "Landroid/graphics/Bitmap;", "matrix", "Landroid/graphics/Matrix;", "offsetX", "offsetY", "rotation", "shader", "Landroid/graphics/BitmapShader;", "shaderPaint", "Landroid/graphics/Paint;", "viewHeight", "", "viewWidth", "cleanup", "", "draw", "canvas", "Landroid/graphics/Canvas;", "zoomPointF", "Landroid/graphics/PointF;", "drawOutline", "bitmap", "outlineColor", "isInLeftTop", "", "point", "setImageRotation", "setViewDimensions", "width", "height", "setup", "outsideColor", "sdk-bundle_release"})
    private final class a {
        private final float a;
        private float b;
        private int c;
        private int d;
        @Nullable
        private BitmapShader e;
        @Nullable
        private Paint f;
        @NotNull
        private final Matrix g;
        private float h;
        private float i;
        private float j;
        @Nullable
        private Bitmap k;
        final /* synthetic */ MagnifierView l;

        /*
         * WARNING - void declaration
         */
        public a(MagnifierView this$0) {
            Matrix matrix;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"this$0");
            this_.l = var1_1;
            this_.a = 2.0f;
            a this_ = matrix;
            matrix = new Matrix();
            v1.g = this_;
        }

        /*
         * WARNING - void declaration
         */
        private final Bitmap a(Bitmap bitmap, int outlineColor) {
            void var1_1;
            if (bitmap != null) {
                void var2_2;
                Paint paint;
                Canvas canvas;
                a a2 = canvas;
                void v1 = var1_1;
                a2((Bitmap)var1_1);
                a2 = paint;
                a2();
                paint.setColor((int)var2_2);
                paint.setStyle(Paint.Style.STROKE);
                paint.setStrokeWidth(0.0f);
                float f = (float)v1.getWidth() - 1.0f;
                float f2 = (float)v1.getHeight() - 1.0f;
                canvas.drawRect(0.0f, 0.0f, f, f2, (Paint)a2);
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private final boolean a(PointF point) {
            void var1_1;
            int n = 1;
            Bitmap bitmap = this.k;
            int n2 = bitmap == null ? n : (var1_1.x + this.h < (float)(bitmap.getWidth() >> 1) ? (var1_1.y + this.i < (float)(bitmap.getHeight() >> 1) ? 1 : 4) : (var1_1.y + this.i < (float)(bitmap.getHeight() >> 1) ? 2 : 3));
            float f = 360;
            return n2 - (int)((f - this.j) % f / (float)90) == 1;
        }

        /*
         * WARNING - void declaration
         */
        public final void a(int width, int height) {
            void var2_3;
            void var1_1;
            this.c = var1_1;
            this.d = var2_3;
            Bitmap bitmap = this.k;
            if (bitmap != null && var1_1 != false && var2_3 != false) {
                a a2 = this;
                a2.b = Math.max((float)bitmap.getWidth() / (float)this.c, (float)bitmap.getHeight() / (float)this.d);
                float f = 2;
                a2.h = ((float)a2.c - (float)bitmap.getWidth() / this.b) / f;
                a2.i = ((float)a2.d - (float)bitmap.getHeight() / this.b) / f;
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void a(@Nullable Bitmap bitmap, float rotation, int outsideColor) {
            if (BitmapUtils.isBitmapValid((Bitmap)bitmap)) {
                void var2_2;
                void var3_3;
                Bitmap bitmap2;
                if (this.e != null) {
                    this.a();
                }
                this.k = bitmap2 = this.a(bitmap2, (int)var3_3);
                if (bitmap2 != null) {
                    Paint paint;
                    BitmapShader bitmapShader;
                    BitmapShader bitmapShader2 = bitmapShader;
                    Shader.TileMode tileMode = Shader.TileMode.CLAMP;
                    bitmapShader = new BitmapShader(bitmap2, tileMode, tileMode);
                    this.e = bitmapShader2;
                    bitmap2 = paint;
                    bitmap2();
                    this.f = bitmap2;
                    if (paint != null) {
                        bitmap2.setShader((Shader)this.e);
                    }
                }
                a a2 = this;
                a2.j = var2_2;
                a2.a(a2.l.getWidth() - this.l.getPaddingLeft() - this.l.getPaddingRight(), this.l.getHeight() - this.l.getPaddingTop() - this.l.getPaddingBottom());
            }
        }

        public final void a() {
            Bitmap bitmap = this.k;
            if (bitmap != null) {
                bitmap.recycle();
            }
            a a2 = this;
            a2.k = null;
            a2.f = null;
            a2.e = null;
        }

        /*
         * WARNING - void declaration
         */
        public final void a(@NotNull Canvas canvas, @NotNull PointF zoomPointF) {
            void var2_3;
            void var1_2;
            Intrinsics.checkNotNullParameter((Object)var1_2, (String)"canvas");
            Intrinsics.checkNotNullParameter((Object)var2_3, (String)"zoomPointF");
            Bitmap bitmap = this_.k;
            if (bitmap != null) {
                PointF pointF;
                MagnifierView magnifierView = this_.l;
                PointF pointF2 = pointF;
                pointF = new PointF(var2_3.x * (float)bitmap.getWidth(), var2_3.y * (float)bitmap.getHeight());
                float f = magnifierView.magnifierMargin;
                float f2 = magnifierView.magnifierMargin;
                if (magnifierView.enableBounding && this_.a(pointF2)) {
                    f = (float)magnifierView.getWidth() - magnifierView.magnifierRadius * (float)2 - magnifierView.magnifierMargin;
                }
                a a2 = this_;
                float f3 = this_.a;
                a2.g.setScale(f3, f3);
                a2.g.postTranslate(-pointF2.x * this_.a + magnifierView.magnifierRadius + f, -pointF2.y * this_.a + magnifierView.magnifierRadius + f2);
                pointF2 = a2.e;
                if (pointF2 != null) {
                    pointF2.setLocalMatrix(this_.g);
                }
                pointF2 = this_.f;
                if (pointF2 != null) {
                    void v3 = var1_2;
                    var1_2.save();
                    float f4 = this_.j;
                    float f5 = f + magnifierView.magnifierRadius;
                    float f6 = f2 + magnifierView.magnifierRadius;
                    var1_2.rotate(f4, f5, f6);
                    f4 = f + magnifierView.magnifierRadius;
                    f5 = f2 + magnifierView.magnifierRadius;
                    f6 = magnifierView.magnifierRadius;
                    v3.drawCircle(f4, f5, f6, (Paint)pointF2);
                    v3.restore();
                }
                a this_ = magnifierView.magnifierFrameBitmap;
                if (this_ != null) {
                    var1_2.drawBitmap((Bitmap)this_, f, f2, null);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void a(float rotation) {
            void var1_1;
            this.j = var1_1;
        }
    }
}

