/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.barcodescanner.model;

import android.graphics.Bitmap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.scanbot.barcodescanner.model.BarCodeScannerDocumentFormat;
import io.scanbot.barcodescanner.model.BarCodeType;
import io.scanbot.barcodescanner.model.DEMedicalPlan.DEMedicalPlanDocument;
import io.scanbot.barcodescanner.model.DisabilityCertificate.DisabilityCertificateDocument;
import io.scanbot.barcodescanner.model.IDCardPDF417.IDCardPDF417Document;
import io.scanbot.barcodescanner.model.SEPA.SEPADocument;
import io.scanbot.barcodescanner.model.VCard.VCardDocument;
import io.scanbot.barcodescanner.model.aamva.AAMVADocument;
import io.scanbot.barcodescanner.model.boardingPass.BoardingPassDocument;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0004\u001a\u00020\u0003H\u0002J\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0006H\u0002R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0019"}, d2={"Lio/scanbot/barcodescanner/model/BarCodeItem;", "", "rawString", "", "jsonString", "decodedType", "", "image", "Landroid/graphics/Bitmap;", "(Ljava/lang/String;Ljava/lang/String;ILandroid/graphics/Bitmap;)V", "documentFormat", "Lio/scanbot/barcodescanner/model/BarCodeScannerDocumentFormat;", "getDocumentFormat", "()Lio/scanbot/barcodescanner/model/BarCodeScannerDocumentFormat;", "getImage", "()Landroid/graphics/Bitmap;", "getRawString", "()Ljava/lang/String;", "type", "Lio/scanbot/barcodescanner/model/BarCodeType;", "getType", "()Lio/scanbot/barcodescanner/model/BarCodeType;", "barCodeDocumentFromJSON", "typeFromInt", "value", "core-barcode_release"})
public final class BarCodeItem {
    @NotNull
    private final BarCodeType type;
    @Nullable
    private final BarCodeScannerDocumentFormat documentFormat;
    @NotNull
    private final String rawString;
    @Nullable
    private final Bitmap image;

    @NotNull
    public final BarCodeType getType() {
        return this.type;
    }

    @Nullable
    public final BarCodeScannerDocumentFormat getDocumentFormat() {
        return this.documentFormat;
    }

    private final BarCodeScannerDocumentFormat barCodeDocumentFromJSON(String jsonString) {
        CharSequence charSequence = jsonString;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return null;
        }
        Gson gson = new Gson();
        JsonObject jobj = (JsonObject)gson.fromJson(jsonString, JsonObject.class);
        JsonElement documentClassNameElement = jobj.get("documentFormat");
        if (documentClassNameElement != null) {
            String string = documentClassNameElement.getAsString();
            if (string != null) {
                switch (string) {
                    case "AAMVA": {
                        return (BarCodeScannerDocumentFormat)gson.fromJson(jsonString, AAMVADocument.class);
                    }
                    case "BoardingPass": {
                        return (BarCodeScannerDocumentFormat)gson.fromJson(jsonString, BoardingPassDocument.class);
                    }
                    case "DEMedicalPlan": {
                        return (BarCodeScannerDocumentFormat)gson.fromJson(jsonString, DEMedicalPlanDocument.class);
                    }
                    case "DisabilityCertificate": {
                        return (BarCodeScannerDocumentFormat)gson.fromJson(jsonString, DisabilityCertificateDocument.class);
                    }
                    case "IDCardPDF417": {
                        return (BarCodeScannerDocumentFormat)gson.fromJson(jsonString, IDCardPDF417Document.class);
                    }
                    case "SEPA": {
                        return (BarCodeScannerDocumentFormat)gson.fromJson(jsonString, SEPADocument.class);
                    }
                    case "VCard": {
                        return (BarCodeScannerDocumentFormat)gson.fromJson(jsonString, VCardDocument.class);
                    }
                }
            }
        }
        return null;
    }

    private final BarCodeType typeFromInt(int value) {
        BarCodeType barCodeType;
        switch (value) {
            case 0: {
                barCodeType = BarCodeType.AZTEC;
                break;
            }
            case 1: {
                barCodeType = BarCodeType.CODABAR;
                break;
            }
            case 2: {
                barCodeType = BarCodeType.CODE_39;
                break;
            }
            case 3: {
                barCodeType = BarCodeType.CODE_93;
                break;
            }
            case 4: {
                barCodeType = BarCodeType.CODE_128;
                break;
            }
            case 5: {
                barCodeType = BarCodeType.DATA_MATRIX;
                break;
            }
            case 6: {
                barCodeType = BarCodeType.EAN_8;
                break;
            }
            case 7: {
                barCodeType = BarCodeType.EAN_13;
                break;
            }
            case 8: {
                barCodeType = BarCodeType.ITF;
                break;
            }
            case 10: {
                barCodeType = BarCodeType.PDF_417;
                break;
            }
            case 11: {
                barCodeType = BarCodeType.QR_CODE;
                break;
            }
            case 12: {
                barCodeType = BarCodeType.RSS_14;
                break;
            }
            case 13: {
                barCodeType = BarCodeType.RSS_EXPANDED;
                break;
            }
            case 14: {
                barCodeType = BarCodeType.UPC_A;
                break;
            }
            case 15: {
                barCodeType = BarCodeType.UPC_E;
                break;
            }
            case 17: {
                barCodeType = BarCodeType.UNKNOWN;
                break;
            }
            default: {
                barCodeType = BarCodeType.UNKNOWN;
            }
        }
        return barCodeType;
    }

    @NotNull
    public final String getRawString() {
        return this.rawString;
    }

    @Nullable
    public final Bitmap getImage() {
        return this.image;
    }

    public BarCodeItem(@NotNull String rawString, @NotNull String jsonString, int decodedType, @Nullable Bitmap image) {
        Intrinsics.checkParameterIsNotNull((Object)rawString, (String)"rawString");
        Intrinsics.checkParameterIsNotNull((Object)jsonString, (String)"jsonString");
        this.rawString = rawString;
        this.image = image;
        this.type = this.typeFromInt(decodedType);
        this.documentFormat = this.barCodeDocumentFromJSON(jsonString);
    }
}

