/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.barcodescanner;

import android.graphics.Bitmap;
import android.graphics.Rect;
import io.scanbot.barcodescanner.BarCodeScanner$WhenMappings;
import io.scanbot.barcodescanner.model.BarCodeScannerResult;
import io.scanbot.barcodescanner.model.BarCodeType;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0016\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\rH\u0002J\u0019\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0082 J6\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\r2\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0007J6\u0010\u0017\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0018\u001a\u00020\u00132\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\r2\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0007J&\u0010\u0019\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\r2\u0006\u0010\u0016\u001a\u00020\u0007J>\u0010\u001c\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\r2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0007J6\u0010\u001f\u001a\u0004\u0018\u00010\u00112\u0006\u0010 \u001a\u00020\u00132\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\r2\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0007J6\u0010!\u001a\u0004\u0018\u00010\u00112\u0006\u0010\"\u001a\u00020\u00132\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\r2\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0007J3\u0010#\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0007H\u0082 J3\u0010$\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0007H\u0082 J#\u0010%\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0007H\u0082 JS\u0010&\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010'\u001a\u00020\u00072\u0006\u0010(\u001a\u00020\u00072\u0006\u0010)\u001a\u00020\u00072\u0006\u0010*\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0007H\u0082 J3\u0010+\u001a\u0004\u0018\u00010\u00112\u0006\u0010 \u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0007H\u0082 J3\u0010,\u001a\u0004\u0018\u00010\u00112\u0006\u0010\"\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0007H\u0082 J\u000e\u0010-\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020/J\u0011\u00100\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020/H\u0082 \u00a8\u00061"}, d2={"Lio/scanbot/barcodescanner/BarCodeScanner;", "", "detectionModelPath", "", "binarizationModelPath", "(Ljava/lang/String;Ljava/lang/String;)V", "barCodeTypeToNativeValue", "", "type", "Lio/scanbot/barcodescanner/model/BarCodeType;", "barcodesListToIntegerArray", "", "barcodeTypes", "", "ctor", "", "detectAndDecode", "Lio/scanbot/barcodescanner/model/BarCodeScannerResult;", "nv21", "", "width", "height", "orientation", "detectAndDecodeBGR", "bgr", "detectAndDecodeBitmap", "bitmap", "Landroid/graphics/Bitmap;", "detectAndDecodeInArea", "areaRect", "Landroid/graphics/Rect;", "detectAndDecodeJPEG", "jpeg", "detectAndDecodeRgba", "img", "recognize", "recognizeBGR", "recognizeBitmap", "recognizeInArea", "areaLeft", "areaTop", "areaWidth", "areaHeight", "recognizeJPEG", "recognizeRGBA", "setHighSensitivityMode", "enableHighSensitivityMode", "", "turnOnHighSensitivityMode", "core-barcode_release"})
public final class BarCodeScanner {
    @Nullable
    public final BarCodeScannerResult detectAndDecode(@NotNull byte[] nv21, @NotNull List<? extends BarCodeType> barcodeTypes, int width, int height, int orientation) {
        Intrinsics.checkNotNullParameter((Object)nv21, (String)"nv21");
        Intrinsics.checkNotNullParameter(barcodeTypes, (String)"barcodeTypes");
        return this.recognize(nv21, this.barcodesListToIntegerArray(barcodeTypes), width, height, orientation);
    }

    @Nullable
    public final BarCodeScannerResult detectAndDecodeInArea(@NotNull byte[] nv21, @NotNull List<? extends BarCodeType> barcodeTypes, @NotNull Rect areaRect, int width, int height, int orientation) {
        Intrinsics.checkNotNullParameter((Object)nv21, (String)"nv21");
        Intrinsics.checkNotNullParameter(barcodeTypes, (String)"barcodeTypes");
        Intrinsics.checkNotNullParameter((Object)areaRect, (String)"areaRect");
        return this.recognizeInArea(nv21, this.barcodesListToIntegerArray(barcodeTypes), width, height, areaRect.left, areaRect.top, areaRect.width(), areaRect.height(), orientation);
    }

    @Nullable
    public final BarCodeScannerResult detectAndDecodeBGR(@NotNull byte[] bgr, @NotNull List<? extends BarCodeType> barcodeTypes, int width, int height, int orientation) {
        Intrinsics.checkNotNullParameter((Object)bgr, (String)"bgr");
        Intrinsics.checkNotNullParameter(barcodeTypes, (String)"barcodeTypes");
        return this.recognizeBGR(bgr, this.barcodesListToIntegerArray(barcodeTypes), width, height, orientation);
    }

    @Nullable
    public final BarCodeScannerResult detectAndDecodeRgba(@NotNull byte[] img, @NotNull List<? extends BarCodeType> barcodeTypes, int width, int height, int orientation) {
        Intrinsics.checkNotNullParameter((Object)img, (String)"img");
        Intrinsics.checkNotNullParameter(barcodeTypes, (String)"barcodeTypes");
        return this.recognizeRGBA(img, this.barcodesListToIntegerArray(barcodeTypes), width, height, orientation);
    }

    @Nullable
    public final BarCodeScannerResult detectAndDecodeJPEG(@NotNull byte[] jpeg, @NotNull List<? extends BarCodeType> barcodeTypes, int width, int height, int orientation) {
        Intrinsics.checkNotNullParameter((Object)jpeg, (String)"jpeg");
        Intrinsics.checkNotNullParameter(barcodeTypes, (String)"barcodeTypes");
        return this.recognizeJPEG(jpeg, this.barcodesListToIntegerArray(barcodeTypes), width, height, orientation);
    }

    @Nullable
    public final BarCodeScannerResult detectAndDecodeBitmap(@NotNull Bitmap bitmap, @NotNull List<? extends BarCodeType> barcodeTypes, int orientation) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        Intrinsics.checkNotNullParameter(barcodeTypes, (String)"barcodeTypes");
        return this.recognizeBitmap(bitmap, this.barcodesListToIntegerArray(barcodeTypes), orientation);
    }

    public final void setHighSensitivityMode(boolean enableHighSensitivityMode) {
        this.turnOnHighSensitivityMode(enableHighSensitivityMode);
    }

    private final int barCodeTypeToNativeValue(BarCodeType type) {
        int n;
        switch (BarCodeScanner$WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                n = 0;
                break;
            }
            case 2: {
                n = 1;
                break;
            }
            case 3: {
                n = 2;
                break;
            }
            case 4: {
                n = 3;
                break;
            }
            case 5: {
                n = 4;
                break;
            }
            case 6: {
                n = 5;
                break;
            }
            case 7: {
                n = 6;
                break;
            }
            case 8: {
                n = 7;
                break;
            }
            case 9: {
                n = 8;
                break;
            }
            case 10: {
                n = 10;
                break;
            }
            case 11: {
                n = 11;
                break;
            }
            case 12: {
                n = 12;
                break;
            }
            case 13: {
                n = 13;
                break;
            }
            case 14: {
                n = 14;
                break;
            }
            case 15: {
                n = 15;
                break;
            }
            case 16: {
                n = 17;
                break;
            }
            default: {
                n = 18;
            }
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    private final int[] barcodesListToIntegerArray(List<? extends BarCodeType> barcodeTypes) {
        int[] result = new int[barcodeTypes.size()];
        int n = 0;
        int n2 = ((Collection)barcodeTypes).size();
        while (n < n2) {
            void index;
            result[index] = this.barCodeTypeToNativeValue(barcodeTypes.get((int)index));
            ++index;
        }
        return result;
    }

    private final native void ctor(String var1, String var2);

    private final native BarCodeScannerResult recognize(byte[] var1, int[] var2, int var3, int var4, int var5);

    private final native BarCodeScannerResult recognizeInArea(byte[] var1, int[] var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

    private final native BarCodeScannerResult recognizeBGR(byte[] var1, int[] var2, int var3, int var4, int var5);

    private final native BarCodeScannerResult recognizeJPEG(byte[] var1, int[] var2, int var3, int var4, int var5);

    private final native BarCodeScannerResult recognizeRGBA(byte[] var1, int[] var2, int var3, int var4, int var5);

    private final native BarCodeScannerResult recognizeBitmap(Bitmap var1, int[] var2, int var3);

    private final native void turnOnHighSensitivityMode(boolean var1);

    public BarCodeScanner(@NotNull String detectionModelPath, @NotNull String binarizationModelPath) {
        Intrinsics.checkNotNullParameter((Object)detectionModelPath, (String)"detectionModelPath");
        Intrinsics.checkNotNullParameter((Object)binarizationModelPath, (String)"binarizationModelPath");
        this.ctor(detectionModelPath, binarizationModelPath);
    }
}

