/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.barcodescanner.model;

import android.graphics.Bitmap;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import io.scanbot.barcodescanner.model.BarCodeFormattedResult;
import io.scanbot.barcodescanner.model.BarCodeType;
import io.scanbot.barcodescanner.model.DEMedicalPlan.DEMedicalPlanDocument;
import io.scanbot.barcodescanner.model.DisabilityCertificate.DisabilityCertificateDocument;
import io.scanbot.barcodescanner.model.IDCardPDF417.IDCardPDF417Document;
import io.scanbot.barcodescanner.model.SEPA.SEPADocument;
import io.scanbot.barcodescanner.model.VCard.VCardDocument;
import io.scanbot.barcodescanner.model.aamva.AAMVADocument;
import io.scanbot.barcodescanner.model.boardingPass.BoardingPassDocument;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0010\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\f\u001a\u00020\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0016\u001a\u00020\u0015\u0012\u0006\u0010\"\u001a\u00020\u0007\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0004\b#\u0010$J\u0019\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\n\u0010\u000bR\u0019\u0010\f\u001a\u00020\u00028\u0006@\u0006\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fR\u001b\u0010\u0011\u001a\u0004\u0018\u00010\u00108\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R\u0019\u0010\u0016\u001a\u00020\u00158\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019R\u0019\u0010\u001a\u001a\u00020\t8\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\u001dR\u001b\u0010\u001e\u001a\u0004\u0018\u00010\u00048\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010!\u00a8\u0006%"}, d2={"Lio/scanbot/barcodescanner/model/BarCodeItem;", "", "", "jsonString", "Lio/scanbot/barcodescanner/model/BarCodeFormattedResult;", "barCodeDocumentFromJSON", "(Ljava/lang/String;)Lio/scanbot/barcodescanner/model/BarCodeFormattedResult;", "", "value", "Lio/scanbot/barcodescanner/model/BarCodeType;", "typeFromInt", "(I)Lio/scanbot/barcodescanner/model/BarCodeType;", "rawString", "Ljava/lang/String;", "getRawString", "()Ljava/lang/String;", "Landroid/graphics/Bitmap;", "image", "Landroid/graphics/Bitmap;", "getImage", "()Landroid/graphics/Bitmap;", "", "rawBytes", "[B", "getRawBytes", "()[B", "type", "Lio/scanbot/barcodescanner/model/BarCodeType;", "getType", "()Lio/scanbot/barcodescanner/model/BarCodeType;", "formattedResult", "Lio/scanbot/barcodescanner/model/BarCodeFormattedResult;", "getFormattedResult", "()Lio/scanbot/barcodescanner/model/BarCodeFormattedResult;", "decodedType", "<init>", "(Ljava/lang/String;Ljava/lang/String;[BILandroid/graphics/Bitmap;)V", "core-barcode_release"})
public final class BarCodeItem {
    @NotNull
    private final BarCodeType type;
    @Nullable
    private final BarCodeFormattedResult formattedResult;
    @NotNull
    private final String rawString;
    @NotNull
    private final byte[] rawBytes;
    @Nullable
    private final Bitmap image;

    private final BarCodeFormattedResult barCodeDocumentFromJSON(String string) {
        Gson gson;
        if (string.length() == 0) {
            return null;
        }
        BarCodeItem barCodeItem = gson;
        barCodeItem();
        Object object = ((JsonObject)gson.fromJson(string, JsonObject.class)).get("documentFormat");
        if (object != null && (object = object.getAsString()) != null) {
            switch (((String)object).hashCode()) {
                default: {
                    break;
                }
                case 1411774931: {
                    if (!((String)object).equals("IDCardPDF417")) break;
                    return (BarCodeFormattedResult)barCodeItem.fromJson(string, IDCardPDF417Document.class);
                }
                case 1043357209: {
                    if (!((String)object).equals("DEMedicalPlan")) break;
                    return (BarCodeFormattedResult)barCodeItem.fromJson(string, DEMedicalPlanDocument.class);
                }
                case 690857357: {
                    if (!((String)object).equals("BoardingPass")) break;
                    return (BarCodeFormattedResult)barCodeItem.fromJson(string, BoardingPassDocument.class);
                }
                case 81515654: {
                    if (!((String)object).equals("VCard")) break;
                    return (BarCodeFormattedResult)barCodeItem.fromJson(string, VCardDocument.class);
                }
                case 62042008: {
                    if (!((String)object).equals("AAMVA")) break;
                    return (BarCodeFormattedResult)barCodeItem.fromJson(string, AAMVADocument.class);
                }
                case 2541507: {
                    if (!((String)object).equals("SEPA")) break;
                    return (BarCodeFormattedResult)barCodeItem.fromJson(string, SEPADocument.class);
                }
                case -1185594629: {
                    if (!((String)object).equals("DisabilityCertificate")) break;
                    return (BarCodeFormattedResult)barCodeItem.fromJson(string, DisabilityCertificateDocument.class);
                }
            }
        }
        return null;
    }

    private final BarCodeType typeFromInt(int n) {
        BarCodeType barCodeType;
        switch (n) {
            default: {
                barCodeType = BarCodeType.UNKNOWN;
                break;
            }
            case 18: {
                barCodeType = BarCodeType.UNKNOWN;
                break;
            }
            case 17: {
                barCodeType = BarCodeType.MSI_PLESSEY;
                break;
            }
            case 15: {
                barCodeType = BarCodeType.UPC_E;
                break;
            }
            case 14: {
                barCodeType = BarCodeType.UPC_A;
                break;
            }
            case 13: {
                barCodeType = BarCodeType.RSS_EXPANDED;
                break;
            }
            case 12: {
                barCodeType = BarCodeType.RSS_14;
                break;
            }
            case 11: {
                barCodeType = BarCodeType.QR_CODE;
                break;
            }
            case 10: {
                barCodeType = BarCodeType.PDF_417;
                break;
            }
            case 8: {
                barCodeType = BarCodeType.ITF;
                break;
            }
            case 7: {
                barCodeType = BarCodeType.EAN_13;
                break;
            }
            case 6: {
                barCodeType = BarCodeType.EAN_8;
                break;
            }
            case 5: {
                barCodeType = BarCodeType.DATA_MATRIX;
                break;
            }
            case 4: {
                barCodeType = BarCodeType.CODE_128;
                break;
            }
            case 3: {
                barCodeType = BarCodeType.CODE_93;
                break;
            }
            case 2: {
                barCodeType = BarCodeType.CODE_39;
                break;
            }
            case 1: {
                barCodeType = BarCodeType.CODABAR;
                break;
            }
            case 0: {
                barCodeType = BarCodeType.AZTEC;
            }
        }
        return barCodeType;
    }

    public BarCodeItem(@NotNull String string, @NotNull String string2, @NotNull byte[] byArray, int n, @Nullable Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"rawString");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"jsonString");
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"rawBytes");
        this.rawString = string;
        this.rawBytes = byArray;
        this.image = bitmap;
        this.type = this.typeFromInt(n);
        this.formattedResult = this.barCodeDocumentFromJSON(string2);
    }

    @NotNull
    public final BarCodeType getType() {
        return this.type;
    }

    @Nullable
    public final BarCodeFormattedResult getFormattedResult() {
        return this.formattedResult;
    }

    @NotNull
    public final String getRawString() {
        return this.rawString;
    }

    @NotNull
    public final byte[] getRawBytes() {
        return this.rawBytes;
    }

    @Nullable
    public final Bitmap getImage() {
        return this.image;
    }
}

