/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.barcodescanner.model;

import android.graphics.Bitmap;
import android.graphics.Point;
import io.scanbot.barcodescanner.InternalDocumentJsonDecoder;
import io.scanbot.barcodescanner.model.BarCodeFormattedResult;
import io.scanbot.barcodescanner.model.BarcodeMetadataKey;
import io.scanbot.barcodescanner.model.BarcodeType;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001BQ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u0012\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u000f\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010%\u001a\u00020\"2\u0006\u0010&\u001a\u00020\bH\u0002R\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001d\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00030\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010!\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$\u00a8\u0006'"}, d2={"Lio/scanbot/barcodescanner/model/BarcodeItem;", "", "rawString", "", "jsonString", "rawBytes", "", "decodedType", "", "image", "Landroid/graphics/Bitmap;", "pointsList", "", "Landroid/graphics/Point;", "metadataInternal", "", "(Ljava/lang/String;Ljava/lang/String;[BILandroid/graphics/Bitmap;Ljava/util/List;Ljava/util/Map;)V", "formattedResult", "Lio/scanbot/barcodescanner/model/BarCodeFormattedResult;", "getFormattedResult", "()Lio/scanbot/barcodescanner/model/BarCodeFormattedResult;", "getImage", "()Landroid/graphics/Bitmap;", "metadata", "Lio/scanbot/barcodescanner/model/BarcodeMetadataKey;", "getMetadata", "()Ljava/util/Map;", "getPointsList", "()Ljava/util/List;", "getRawBytes", "()[B", "getRawString", "()Ljava/lang/String;", "type", "Lio/scanbot/barcodescanner/model/BarcodeType;", "getType", "()Lio/scanbot/barcodescanner/model/BarcodeType;", "typeFromInt", "value", "core-barcode_release"})
public final class BarcodeItem {
    @NotNull
    private final String rawString;
    @NotNull
    private final byte[] rawBytes;
    @Nullable
    private final Bitmap image;
    @NotNull
    private final List<Point> pointsList;
    @NotNull
    private final BarcodeType type;
    @Nullable
    private final BarCodeFormattedResult formattedResult;
    @NotNull
    private final Map<BarcodeMetadataKey, String> metadata;

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public BarcodeItem(@NotNull String rawString, @NotNull String jsonString, @NotNull byte[] rawBytes, int decodedType, @Nullable Bitmap image, @NotNull List<? extends Point> pointsList, @NotNull Map<String, String> metadataInternal) {
        LinkedHashMap linkedHashMap;
        LinkedHashMap linkedHashMap2;
        void var4_9;
        Object object;
        void var7_13;
        ArrayList<String> arrayList;
        void var3_3;
        LinkedHashMap linkedHashMap3;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)object2, (String)"rawString");
        Intrinsics.checkNotNullParameter((Object)linkedHashMap3, (String)"jsonString");
        Intrinsics.checkNotNullParameter((Object)var3_3, (String)"rawBytes");
        Intrinsics.checkNotNullParameter((Object)arrayList, (String)"pointsList");
        Intrinsics.checkNotNullParameter((Object)var7_13, (String)"metadataInternal");
        this.rawString = object2;
        this.rawBytes = var3_3;
        this.image = object;
        this.pointsList = arrayList;
        this.type = this.typeFromInt((int)var4_9);
        this.formattedResult = InternalDocumentJsonDecoder.INSTANCE.barcodeDocumentFromJson$core_barcode_release((String)((Object)linkedHashMap3));
        object2 = linkedHashMap2;
        linkedHashMap2 = new LinkedHashMap();
        for (Map.Entry entry : metadataInternal.entrySet()) {
            boolean bl;
            ArrayList<String> arrayList2;
            String string = (String)entry.getKey();
            object = BarcodeMetadataKey.values();
            arrayList = arrayList2;
            arrayList2 = new ArrayList<String>(((BarcodeMetadataKey[])object).length);
            int n = ((BarcodeMetadataKey[])object).length;
            for (int i = 0; i < n; ++i) {
                arrayList.add(object[i].name());
            }
            if (!arrayList.isEmpty()) {
                object = arrayList.iterator();
                while (object.hasNext()) {
                    if (!Intrinsics.areEqual((Object)((String)object.next()), (Object)string)) continue;
                    bl = true;
                    break;
                }
            } else {
                bl = false;
            }
            if (!bl) continue;
            Map.Entry entry2 = entry;
            Object k = entry2.getKey();
            ((AbstractMap)object2).put(k, entry2.getValue());
        }
        linkedHashMap3 = linkedHashMap;
        linkedHashMap = new LinkedHashMap(MapsKt.mapCapacity((int)object2.size()));
        object2 = object2.entrySet().iterator();
        while (true) {
            if (!object2.hasNext()) {
                this.metadata = linkedHashMap3;
                return;
            }
            Map.Entry entry = (Map.Entry)object2.next();
            BarcodeMetadataKey barcodeMetadataKey = BarcodeMetadataKey.valueOf((String)entry.getKey());
            linkedHashMap3.put(barcodeMetadataKey, entry.getValue());
        }
    }

    private final BarcodeType typeFromInt(int value) {
        BarcodeType barcodeType;
        switch (value) {
            default: {
                barcodeType = BarcodeType.UNKNOWN;
                break;
            }
            case 19: {
                barcodeType = BarcodeType.INDUSTRIAL_2_OF_5;
                break;
            }
            case 18: {
                barcodeType = BarcodeType.IATA_2_OF_5;
                break;
            }
            case 17: {
                barcodeType = BarcodeType.MSI_PLESSEY;
                break;
            }
            case 15: {
                barcodeType = BarcodeType.UPC_E;
                break;
            }
            case 14: {
                barcodeType = BarcodeType.UPC_A;
                break;
            }
            case 13: {
                barcodeType = BarcodeType.RSS_EXPANDED;
                break;
            }
            case 12: {
                barcodeType = BarcodeType.RSS_14;
                break;
            }
            case 11: {
                barcodeType = BarcodeType.QR_CODE;
                break;
            }
            case 10: {
                barcodeType = BarcodeType.PDF_417;
                break;
            }
            case 8: {
                barcodeType = BarcodeType.ITF;
                break;
            }
            case 7: {
                barcodeType = BarcodeType.EAN_13;
                break;
            }
            case 6: {
                barcodeType = BarcodeType.EAN_8;
                break;
            }
            case 5: {
                barcodeType = BarcodeType.DATA_MATRIX;
                break;
            }
            case 4: {
                barcodeType = BarcodeType.CODE_128;
                break;
            }
            case 3: {
                barcodeType = BarcodeType.CODE_93;
                break;
            }
            case 2: {
                barcodeType = BarcodeType.CODE_39;
                break;
            }
            case 1: {
                barcodeType = BarcodeType.CODABAR;
                break;
            }
            case 0: {
                barcodeType = BarcodeType.AZTEC;
            }
        }
        return barcodeType;
    }

    @NotNull
    public final String getRawString() {
        return this.rawString;
    }

    @NotNull
    public final byte[] getRawBytes() {
        return this.rawBytes;
    }

    @Nullable
    public final Bitmap getImage() {
        return this.image;
    }

    @NotNull
    public final List<Point> getPointsList() {
        return this.pointsList;
    }

    @NotNull
    public final BarcodeType getType() {
        return this.type;
    }

    @Nullable
    public final BarCodeFormattedResult getFormattedResult() {
        return this.formattedResult;
    }

    @NotNull
    public final Map<BarcodeMetadataKey, String> getMetadata() {
        return this.metadata;
    }
}

