/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.core.contourdetector;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.RectF;
import androidx.annotation.RestrictTo;
import io.scanbot.sdk.core.contourdetector.DetectionResult;
import io.scanbot.sdk.core.contourdetector.Line2D;
import io.scanbot.sdk.core.contourdetector.PageAspectRatio;
import java.io.IOException;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 :2\u00020\u0001:\u0002:;B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0082 J\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001f\u001a\u00020 J \u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#J\u001b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010%\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001eH\u0082 J\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010&\u001a\u00020'J+\u0010(\u001a\u0004\u0018\u00010\u001c2\u0006\u0010%\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#H\u0082 J\u0011\u0010)\u001a\u00020*2\u0006\u0010%\u001a\u00020\u000fH\u0086 J\b\u0010+\u001a\u00020*H\u0004J\u0011\u0010\u0007\u001a\u00020\u00062\u0006\u0010%\u001a\u00020\u000fH\u0082 J\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010%\u001a\u00020\u000fH\u0082 J\u0019\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\n2\u0006\u0010%\u001a\u00020\u000fH\u0082 J\u0019\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\n2\u0006\u0010%\u001a\u00020\u000fH\u0082 J\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010%\u001a\u00020\u000fH\u0082 J\u0006\u0010,\u001a\u00020*J\u0011\u0010,\u001a\u00020*2\u0006\u0010%\u001a\u00020\u000fH\u0082 J\u000e\u0010-\u001a\u00020*2\u0006\u0010.\u001a\u00020\u0006J\u0019\u0010-\u001a\u00020*2\u0006\u0010%\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020\u0006H\u0082 J\u000e\u0010/\u001a\u00020*2\u0006\u00100\u001a\u00020\u0006J\u0019\u0010/\u001a\u00020*2\u0006\u0010%\u001a\u00020\u000f2\u0006\u00100\u001a\u00020\u0006H\u0082 J\u000e\u00101\u001a\u00020*2\u0006\u00102\u001a\u000203J1\u00101\u001a\u00020*2\u0006\u0010%\u001a\u00020\u000f2\u0006\u00104\u001a\u00020\u00062\u0006\u00105\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u0006H\u0082 J\u001f\u00106\u001a\u00020*2\u0006\u0010%\u001a\u00020\u000f2\f\u00107\u001a\b\u0012\u0004\u0012\u0002080\nH\u0082 J\u0014\u00106\u001a\u00020*2\f\u00109\u001a\b\u0012\u0004\u0012\u0002080\nR\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\rR\u0019\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\rR\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\r\u00a8\u0006<"}, d2={"Lio/scanbot/sdk/core/contourdetector/ContourDetector;", "", "contourDetectorType", "Lio/scanbot/sdk/core/contourdetector/ContourDetector$Type;", "(Lio/scanbot/sdk/core/contourdetector/ContourDetector$Type;)V", "detectionScore", "", "getDetectionScore", "()D", "horizontalLines", "", "Lio/scanbot/sdk/core/contourdetector/Line2D;", "getHorizontalLines", "()Ljava/util/List;", "pointer", "", "polygon", "Landroid/graphics/Point;", "getPolygon", "polygonF", "Landroid/graphics/PointF;", "getPolygonF", "verticalLines", "getVerticalLines", "ctor", "useMlBased", "", "detect", "Lio/scanbot/sdk/core/contourdetector/DetectionResult;", "bitmap", "Landroid/graphics/Bitmap;", "data", "", "nv21", "width", "", "height", "ptr", "fileName", "", "detectNV21", "dtor", "", "finalize", "resetPolygonHistory", "setAcceptedAngleScore", "acceptedAngleScore", "setAcceptedSizeScore", "acceptedSizeScore", "setRectOfInterest", "rectOfInterest", "Landroid/graphics/RectF;", "x", "y", "setRequiredAspectRatios", "requiredAspectRatios", "Lio/scanbot/sdk/core/contourdetector/PageAspectRatio;", "requiredPageAspectRatios", "Companion", "Type", "core-imageprocessing_release"})
public final class ContourDetector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long a;

    /*
     * WARNING - void declaration
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public ContourDetector(@NotNull Type contourDetectorType) {
        long l;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"contourDetectorType");
        boolean bl = contourDetectorType == Type.ML_BASED;
        this.a = l = this.ctor(bl);
        if (l != 0L) {
            return;
        }
        throw new IllegalStateException("Failed to create native resources.".toString());
    }

    private final native long ctor(boolean var1);

    private final native void resetPolygonHistory(long var1);

    private final native List<Point> getPolygon(long var1);

    private final native List<PointF> getPolygonF(long var1);

    private final native double getDetectionScore(long var1);

    private final native DetectionResult detectNV21(long var1, byte[] var3, int var4, int var5);

    private final native DetectionResult detect(long var1, Bitmap var3);

    private final native List<Line2D> getVerticalLines(long var1);

    private final native List<Line2D> getHorizontalLines(long var1);

    private final native void setAcceptedSizeScore(long var1, double var3);

    private final native void setAcceptedAngleScore(long var1, double var3);

    private final native void setRequiredAspectRatios(long var1, List<PageAspectRatio> var3);

    private final native void setRectOfInterest(long var1, double var3, double var5, double var7, double var9);

    @JvmStatic
    @NotNull
    public static final Bitmap createBitmapFromEncodedData(@NotNull byte[] data) {
        byte[] byArray;
        return Companion.createBitmapFromEncodedData(byArray);
    }

    @JvmStatic
    @NotNull
    public static final Bitmap createBitmapFromEncodedFile(@Nullable String fileName) throws IOException {
        String string;
        return Companion.createBitmapFromEncodedFile(string);
    }

    public final void finalize() {
        ContourDetector contourDetector = this;
        contourDetector.dtor(contourDetector.a);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final DetectionResult detect(@NotNull byte[] nv21, int width, int height) {
        void var3_3;
        void var2_2;
        void var1_1;
        ContourDetector contourDetector = this;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"nv21");
        return contourDetector.detectNV21(contourDetector.a, (byte[])var1_1, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final DetectionResult detect(@NotNull byte[] data) {
        void var1_1;
        ContourDetector contourDetector = this_;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"data");
        ContourDetector this_ = Companion.createBitmapFromEncodedData((byte[])var1_1);
        DetectionResult detectionResult = contourDetector.detect(contourDetector.a, (Bitmap)this_);
        this_.recycle();
        return detectionResult;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final DetectionResult detect(@NotNull String fileName) throws IOException {
        void var1_1;
        ContourDetector contourDetector = this_;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"fileName");
        ContourDetector this_ = Companion.createBitmapFromEncodedFile((String)var1_1);
        DetectionResult detectionResult = contourDetector.detect(contourDetector.a, (Bitmap)this_);
        this_.recycle();
        return detectionResult;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final DetectionResult detect(@NotNull Bitmap bitmap) {
        void var1_1;
        ContourDetector contourDetector = this;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"bitmap");
        return contourDetector.detect(contourDetector.a, (Bitmap)var1_1);
    }

    @Nullable
    public final List<Point> getPolygon() {
        ContourDetector contourDetector = this;
        return contourDetector.getPolygon(contourDetector.a);
    }

    @Nullable
    public final List<PointF> getPolygonF() {
        ContourDetector contourDetector = this;
        return contourDetector.getPolygonF(contourDetector.a);
    }

    public final double getDetectionScore() {
        ContourDetector contourDetector = this;
        return contourDetector.getDetectionScore(contourDetector.a);
    }

    @NotNull
    public final List<Line2D> getVerticalLines() {
        ContourDetector contourDetector = this;
        return contourDetector.getVerticalLines(contourDetector.a);
    }

    @NotNull
    public final List<Line2D> getHorizontalLines() {
        ContourDetector contourDetector = this;
        return contourDetector.getHorizontalLines(contourDetector.a);
    }

    /*
     * WARNING - void declaration
     */
    public final void setAcceptedAngleScore(double acceptedAngleScore) {
        void var1_1;
        ContourDetector contourDetector = this;
        contourDetector.setAcceptedAngleScore(contourDetector.a, (double)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void setAcceptedSizeScore(double acceptedSizeScore) {
        void var1_1;
        ContourDetector contourDetector = this;
        contourDetector.setAcceptedSizeScore(contourDetector.a, (double)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void setRequiredAspectRatios(@NotNull List<PageAspectRatio> requiredPageAspectRatios) {
        void var1_1;
        ContourDetector contourDetector = this;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"requiredPageAspectRatios");
        contourDetector.setRequiredAspectRatios(contourDetector.a, (List<PageAspectRatio>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void setRectOfInterest(@NotNull RectF rectOfInterest) {
        void var1_2;
        ContourDetector contourDetector = this;
        Intrinsics.checkNotNullParameter((Object)var1_2, (String)"rectOfInterest");
        void v1 = var1_2;
        double d = v1.left;
        double d2 = v1.top;
        double d3 = v1.width();
        double d4 = v1.height();
        contourDetector.setRectOfInterest(contourDetector.a, d, d2, d3, d4);
    }

    public final void resetPolygonHistory() {
        ContourDetector contourDetector = this;
        contourDetector.resetPolygonHistory(contourDetector.a);
    }

    public final native void dtor(long var1);

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lio/scanbot/sdk/core/contourdetector/ContourDetector$Type;", "", "(Ljava/lang/String;I)V", "EDGE_BASED", "ML_BASED", "core-imageprocessing_release"})
    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type EDGE_BASED = new Type();
        public static final /* enum */ Type ML_BASED = new Type();
        private static final /* synthetic */ Type[] a;

        /*
         * WARNING - void declaration
         */
        private Type() {
            void var2_2;
            void var1_1;
        }

        public static Type[] values() {
            return (Type[])a.clone();
        }

        public static Type valueOf(String value) {
            String string;
            return Enum.valueOf(Type.class, string);
        }

        private static final /* synthetic */ Type[] a() {
            return new Type[]{EDGE_BASED, ML_BASED};
        }

        static {
            a = Type.a();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0012\u0010\u0007\u001a\u00020\u00042\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0007\u00a8\u0006\n"}, d2={"Lio/scanbot/sdk/core/contourdetector/ContourDetector$Companion;", "", "()V", "createBitmapFromEncodedData", "Landroid/graphics/Bitmap;", "data", "", "createBitmapFromEncodedFile", "fileName", "", "core-imageprocessing_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @JvmStatic
        @NotNull
        public final Bitmap createBitmapFromEncodedData(@NotNull byte[] data) {
            BitmapFactory.Options options;
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Companion companion = options;
            new BitmapFactory.Options().inDither = false;
            new BitmapFactory.Options().inPreferredConfig = Bitmap.Config.ARGB_8888;
            Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length, (BitmapFactory.Options)companion);
            Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"decodeByteArray(data, 0, data.size, options)");
            return bitmap;
        }

        @JvmStatic
        @NotNull
        public final Bitmap createBitmapFromEncodedFile(@Nullable String fileName) throws IOException {
            new BitmapFactory.Options().inDither = false;
            new BitmapFactory.Options().inPreferredConfig = Bitmap.Config.ARGB_8888;
            Companion companion = BitmapFactory.decodeFile((String)fileName, (BitmapFactory.Options)new BitmapFactory.Options());
            if (companion != null) {
                return companion;
            }
            throw new IOException("Can't open Bitmap");
        }
    }
}

