/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.payformscanner;

import android.util.Log;
import io.scanbot.payformscanner.model.DetectedForm;
import io.scanbot.payformscanner.model.RecognizedField;
import java.util.List;

public class PayFormScanner {
    public PayFormScanner(String tessDataPath, String banksFilePath) {
        PayFormScanner.ctor(tessDataPath, banksFilePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RecognizedField> recognizeForm(byte[] nv21, int width, int height, int orientation) {
        long a = System.currentTimeMillis();
        try {
            List<RecognizedField> list = PayFormScanner.recognize(nv21, width, height, orientation);
            return list;
        }
        finally {
            long b = System.currentTimeMillis();
            Log.d((String)"PayFormScanner", (String)("Total recognition (sec): " + (float)(b - a) / 1000.0f));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RecognizedField> recognizeFormBGR(byte[] bgr, int width, int height, int orientation) {
        long a = System.currentTimeMillis();
        try {
            List<RecognizedField> list = PayFormScanner.recognizeBGR(bgr, width, height, orientation);
            return list;
        }
        finally {
            long b = System.currentTimeMillis();
            Log.d((String)"PayFormScanner", (String)("Total recognition (sec): " + (float)(b - a) / 1000.0f));
        }
    }

    public DetectionResult preVerifyForm(byte[] image, int previewWidth, int previewHeight) {
        DetectedForm form = PayFormScanner.detect(image, previewWidth, previewHeight);
        return new DetectionResult(form, image, previewWidth, previewHeight);
    }

    public DetectionResult preVerifyFormBGR(byte[] image, int previewWidth, int previewHeight) {
        DetectedForm form = PayFormScanner.detectBGR(image, previewWidth, previewHeight);
        return new DetectionResult(form, image, previewWidth, previewHeight);
    }

    private static native void ctor(String var0, String var1);

    private static native DetectedForm detect(byte[] var0, int var1, int var2);

    private static native DetectedForm detectBGR(byte[] var0, int var1, int var2);

    private static native List<RecognizedField> recognize(byte[] var0, int var1, int var2, int var3);

    private static native List<RecognizedField> recognizeBGR(byte[] var0, int var1, int var2, int var3);

    static {
        System.loadLibrary("lept");
        System.loadLibrary("tess");
        System.loadLibrary("scanbotsdk");
    }

    public static class DetectionResult {
        public final DetectedForm form;
        public final byte[] lastFrame;
        public final int frameWidth;
        public final int frameHeight;

        public DetectionResult(DetectedForm form, byte[] lastFrame, int frameWidth, int frameHeight) {
            this.form = form;
            this.lastFrame = lastFrame;
            this.frameWidth = frameWidth;
            this.frameHeight = frameHeight;
        }
    }
}

