/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.mrzscanner;

import android.util.Log;
import io.scanbot.mrzscanner.model.MRZRecognitionResult;

public class MRZRecognizer {
    public MRZRecognizer(String tessDataPath) {
        MRZRecognizer.ctor(tessDataPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MRZRecognitionResult recognizeMRZ(byte[] nv21, int width, int height, int orientation) {
        long a = System.currentTimeMillis();
        try {
            MRZRecognitionResult mRZRecognitionResult = MRZRecognizer.recognize(nv21, width, height, orientation);
            return mRZRecognitionResult;
        }
        finally {
            long b = System.currentTimeMillis();
            Log.d((String)"MRZRecognizer", (String)("Total recognition time (sec): " + (float)(b - a) / 1000.0f));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MRZRecognitionResult recognizeMRZBGR(byte[] bgr, int width, int height, int orientation) {
        long a = System.currentTimeMillis();
        try {
            MRZRecognitionResult mRZRecognitionResult = MRZRecognizer.recognizeBGR(bgr, width, height, orientation);
            return mRZRecognitionResult;
        }
        finally {
            long b = System.currentTimeMillis();
            Log.d((String)"MRZRecognizer", (String)("Total recognition time (sec): " + (float)(b - a) / 1000.0f));
        }
    }

    private static native void ctor(String var0);

    private static native MRZRecognitionResult recognize(byte[] var0, int var1, int var2, int var3);

    private static native MRZRecognitionResult recognizeBGR(byte[] var0, int var1, int var2, int var3);

    static {
        System.loadLibrary("lept");
        System.loadLibrary("tess");
        System.loadLibrary("scanbotsdk");
    }
}

