/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.mrzscanner.model;

import android.os.Parcel;
import android.os.Parcelable;
import io.scanbot.mrzscanner.model.MRZCheckDigitType;

public class MRZCheckDigit
implements Parcelable {
    public byte checkDigitCharacter;
    public boolean successfullyValidated;
    public MRZCheckDigitType type;
    public String validatedString;
    public static final Parcelable.Creator<MRZCheckDigit> CREATOR = new Parcelable.Creator<MRZCheckDigit>(){

        public MRZCheckDigit createFromParcel(Parcel in) {
            return new MRZCheckDigit(in);
        }

        public MRZCheckDigit[] newArray(int size) {
            return new MRZCheckDigit[size];
        }
    };

    public MRZCheckDigit(byte checkDigitCharacter, boolean successfullyValidated, int type, String validatedString) {
        this.checkDigitCharacter = checkDigitCharacter;
        this.successfullyValidated = successfullyValidated;
        this.type = this.checkDigitTypeFromInt(type);
        this.validatedString = validatedString;
    }

    protected MRZCheckDigit(Parcel in) {
        this.checkDigitCharacter = in.readByte();
        this.successfullyValidated = in.readInt() == 1;
        this.validatedString = in.readString();
        this.type = this.checkDigitTypeFromInt(in.readInt());
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeByte(this.checkDigitCharacter);
        parcel.writeInt(this.successfullyValidated ? 1 : 0);
        parcel.writeString(this.validatedString);
        parcel.writeInt(this.intValueFromMRZCheckDigitType());
    }

    protected int intValueFromMRZCheckDigitType() {
        switch (this.type) {
            case MRZCheckDigitTypeDocumentNumber: {
                return 1;
            }
            case MRZCheckDigitTypeDateOfBirth: {
                return 2;
            }
            case MRZCheckDigitTypeExpirationDate: {
                return 3;
            }
            case MRZCheckDigitTypePersonalNumber: {
                return 4;
            }
            case MRZCheckDigitTypeGeneral: {
                return 5;
            }
        }
        return 0;
    }

    protected MRZCheckDigitType checkDigitTypeFromInt(int i) {
        switch (i) {
            case 1: {
                return MRZCheckDigitType.MRZCheckDigitTypeDocumentNumber;
            }
            case 2: {
                return MRZCheckDigitType.MRZCheckDigitTypeDateOfBirth;
            }
            case 3: {
                return MRZCheckDigitType.MRZCheckDigitTypeExpirationDate;
            }
            case 4: {
                return MRZCheckDigitType.MRZCheckDigitTypePersonalNumber;
            }
            case 5: {
                return MRZCheckDigitType.MRZCheckDigitTypeGeneral;
            }
        }
        return MRZCheckDigitType.MRZCheckDigitTypeUndefined;
    }
}

