/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.hicscanner;

import android.graphics.Bitmap;
import android.graphics.Rect;
import android.util.Log;
import io.scanbot.hicscanner.model.HealthInsuranceCardRecognitionResult;

public class HICRecognizer {
    public HICRecognizer(String tessDataPath) {
        HICRecognizer.ctor(tessDataPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HealthInsuranceCardRecognitionResult recognizeFromNV21(byte[] nv21, int width, int height, int orientation) {
        long a = System.currentTimeMillis();
        try {
            HealthInsuranceCardRecognitionResult healthInsuranceCardRecognitionResult = HICRecognizer.recognize(nv21, width, height, orientation);
            return healthInsuranceCardRecognitionResult;
        }
        finally {
            long b = System.currentTimeMillis();
            Log.d((String)"HICRecognizer", (String)("Total recognition time (sec): " + (float)(b - a) / 1000.0f));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HealthInsuranceCardRecognitionResult recognizeInAreaFromNV21(byte[] nv21, int width, int height, Rect areaRect, int orientation) {
        long a = System.currentTimeMillis();
        try {
            HealthInsuranceCardRecognitionResult healthInsuranceCardRecognitionResult = HICRecognizer.recognizeInArea(nv21, width, height, areaRect.left, areaRect.top, areaRect.width(), areaRect.height(), orientation);
            return healthInsuranceCardRecognitionResult;
        }
        finally {
            long b = System.currentTimeMillis();
            Log.d((String)"HICRecognizer", (String)("Total recognition time (sec): " + (float)(b - a) / 1000.0f));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HealthInsuranceCardRecognitionResult recognizeFromJPEG(byte[] jpeg, int width, int height, int orientation) {
        long a = System.currentTimeMillis();
        try {
            HealthInsuranceCardRecognitionResult healthInsuranceCardRecognitionResult = HICRecognizer.recognizeJPEG(jpeg, width, height, orientation);
            return healthInsuranceCardRecognitionResult;
        }
        finally {
            long b = System.currentTimeMillis();
            Log.d((String)"HICRecognizer", (String)("Total recognition time (sec): " + (float)(b - a) / 1000.0f));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HealthInsuranceCardRecognitionResult recognizeFromBitmap(Bitmap image, int orientation) {
        long a = System.currentTimeMillis();
        try {
            HealthInsuranceCardRecognitionResult healthInsuranceCardRecognitionResult = HICRecognizer.recognizeBitmap(image, orientation);
            return healthInsuranceCardRecognitionResult;
        }
        finally {
            long b = System.currentTimeMillis();
            Log.d((String)"HICRecognizer", (String)("Total recognition time (sec): " + (float)(b - a) / 1000.0f));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HealthInsuranceCardRecognitionResult detectAndRecognizeFromNV21(byte[] nv21, int width, int height, int orientation) {
        long a = System.currentTimeMillis();
        try {
            HealthInsuranceCardRecognitionResult healthInsuranceCardRecognitionResult = HICRecognizer.detectAndRecognize(nv21, width, height, orientation);
            return healthInsuranceCardRecognitionResult;
        }
        finally {
            long b = System.currentTimeMillis();
            Log.d((String)"HICRecognizer", (String)("Total recognition time (sec): " + (float)(b - a) / 1000.0f));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HealthInsuranceCardRecognitionResult detectAndRecognizeInAreaFromNV21(byte[] nv21, int width, int height, Rect areaRect, int orientation) {
        long a = System.currentTimeMillis();
        try {
            HealthInsuranceCardRecognitionResult healthInsuranceCardRecognitionResult = HICRecognizer.detectAndRecognizeInArea(nv21, width, height, areaRect.left, areaRect.top, areaRect.width(), areaRect.height(), orientation);
            return healthInsuranceCardRecognitionResult;
        }
        finally {
            long b = System.currentTimeMillis();
            Log.d((String)"HICRecognizer", (String)("Total recognition time (sec): " + (float)(b - a) / 1000.0f));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HealthInsuranceCardRecognitionResult detectAndRecognizeFromJPEG(byte[] jpeg, int width, int height, int orientation) {
        long a = System.currentTimeMillis();
        try {
            HealthInsuranceCardRecognitionResult healthInsuranceCardRecognitionResult = HICRecognizer.detectAndRecognizeJPEG(jpeg, width, height, orientation);
            return healthInsuranceCardRecognitionResult;
        }
        finally {
            long b = System.currentTimeMillis();
            Log.d((String)"HICRecognizer", (String)("Total recognition time (sec): " + (float)(b - a) / 1000.0f));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HealthInsuranceCardRecognitionResult detectAndRecognizeFromBitmap(Bitmap image, int orientation) {
        long a = System.currentTimeMillis();
        try {
            HealthInsuranceCardRecognitionResult healthInsuranceCardRecognitionResult = HICRecognizer.detectAndRecognizeBitmap(image, orientation);
            return healthInsuranceCardRecognitionResult;
        }
        finally {
            long b = System.currentTimeMillis();
            Log.d((String)"HICRecognizer", (String)("Total recognition time (sec): " + (float)(b - a) / 1000.0f));
        }
    }

    private static native void ctor(String var0);

    private static native HealthInsuranceCardRecognitionResult recognize(byte[] var0, int var1, int var2, int var3);

    private static native HealthInsuranceCardRecognitionResult recognizeInArea(byte[] var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7);

    private static native HealthInsuranceCardRecognitionResult recognizeJPEG(byte[] var0, int var1, int var2, int var3);

    private static native HealthInsuranceCardRecognitionResult recognizeBitmap(Bitmap var0, int var1);

    private static native HealthInsuranceCardRecognitionResult detectAndRecognize(byte[] var0, int var1, int var2, int var3);

    private static native HealthInsuranceCardRecognitionResult detectAndRecognizeInArea(byte[] var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7);

    private static native HealthInsuranceCardRecognitionResult detectAndRecognizeJPEG(byte[] var0, int var1, int var2, int var3);

    private static native HealthInsuranceCardRecognitionResult detectAndRecognizeBitmap(Bitmap var0, int var1);
}

