/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.sdk_native_wrapper.helpers;

import android.graphics.Bitmap;
import io.scanbot.check.entity.RootDocumentType;
import io.scanbot.sdk.check.CheckRecognizer;
import io.scanbot.sdk.check.entity.CheckRecognizerResult;
import io.scanbot.sdk.sdk_native_wrapper.SBNWOperations;
import io.scanbot.sdk.sdk_native_wrapper.errors.SBNWCommonExceptions;
import io.scanbot.sdk.sdk_native_wrapper.helpers.SBNWBitmapHelper;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0016\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\bH\u0002J&\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0016\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\b\u00a8\u0006\r"}, d2={"Lio/scanbot/sdk/sdk_native_wrapper/helpers/SBNWCheckHelper;", "", "()V", "createCheckRecognizer", "Lio/scanbot/sdk/check/CheckRecognizer;", "acceptedCheckStandards", "Ljava/util/ArrayList;", "Lio/scanbot/check/entity/RootDocumentType;", "Lkotlin/collections/ArrayList;", "recognizeCheckOnImage", "Lio/scanbot/sdk/check/entity/CheckRecognizerResult;", "imageFileUri", "", "sdk-native-wrapper_release"})
public final class SBNWCheckHelper {
    @NotNull
    public static final SBNWCheckHelper INSTANCE = new SBNWCheckHelper();

    private SBNWCheckHelper() {
    }

    @NotNull
    public final CheckRecognizerResult recognizeCheckOnImage(@NotNull String imageFileUri, @NotNull ArrayList<RootDocumentType> acceptedCheckStandards) {
        Intrinsics.checkNotNullParameter((Object)imageFileUri, (String)"imageFileUri");
        Intrinsics.checkNotNullParameter(acceptedCheckStandards, (String)"acceptedCheckStandards");
        CheckRecognizer recognizer = this.createCheckRecognizer(acceptedCheckStandards);
        Bitmap sourceImage = SBNWBitmapHelper.INSTANCE.loadImage(imageFileUri);
        CheckRecognizerResult checkRecognizerResult = recognizer.recognizeBitmap(sourceImage, 0);
        if (checkRecognizerResult == null) {
            throw new SBNWCommonExceptions.SBSDKFunctionError(Intrinsics.stringPlus((String)"Cannot recognize check on the given image: ", (Object)imageFileUri));
        }
        return checkRecognizerResult;
    }

    private final CheckRecognizer createCheckRecognizer(ArrayList<RootDocumentType> acceptedCheckStandards) {
        CheckRecognizer checkRecognizer;
        CheckRecognizer $this$createCheckRecognizer_u24lambda_u2d0 = checkRecognizer = SBNWOperations.INSTANCE.getInternalSdk$sdk_native_wrapper_release().createCheckRecognizer();
        boolean bl = false;
        $this$createCheckRecognizer_u24lambda_u2d0.setAcceptedCheckStandards(acceptedCheckStandards);
        return checkRecognizer;
    }
}

