/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.sdk_native_wrapper.wrapper.operations;

import io.scanbot.sdk.barcode.entity.BarcodeScanningResult;
import io.scanbot.sdk.sdk_native_wrapper.converters.BarcodeExtensionsKt;
import io.scanbot.sdk.sdk_native_wrapper.errors.SBNWCommonExceptions;
import io.scanbot.sdk.sdk_native_wrapper.helpers.SBNWBarcodeHelper;
import io.scanbot.sdk.sdk_native_wrapper.helpers.SBNWJsonMap;
import io.scanbot.sdk.sdk_native_wrapper.models.SBNWBarcodeDetectionParameters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00042\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004J&\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00042\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004\u00a8\u0006\b"}, d2={"Lio/scanbot/sdk/sdk_native_wrapper/wrapper/operations/SBNWBarcodeOperations;", "", "()V", "detectBarcodesOnImage", "", "", "options", "detectBarcodesOnImages", "sdk-native-wrapper_release"})
public final class SBNWBarcodeOperations {
    @NotNull
    public static final SBNWBarcodeOperations INSTANCE = new SBNWBarcodeOperations();

    private SBNWBarcodeOperations() {
    }

    @NotNull
    public final Map<String, Object> detectBarcodesOnImage(@NotNull Map<String, ? extends Object> options) {
        Intrinsics.checkNotNullParameter(options, (String)"options");
        SBNWJsonMap jsonMap = new SBNWJsonMap(options);
        String string = jsonMap.getString("imageFileUri");
        if (string == null) {
            throw new SBNWCommonExceptions.SBSDKInvalidJSON(null, 1, null);
        }
        String imageUri = string;
        BarcodeScanningResult result = SBNWBarcodeHelper.INSTANCE.detectBarcodesOnImage(imageUri, new SBNWBarcodeDetectionParameters(options));
        return BarcodeExtensionsKt.toJson(result);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, Object> detectBarcodesOnImages(@NotNull Map<String, ? extends Object> options) {
        void $this$mapIndexedTo$iv$iv;
        void $this$mapIndexed$iv;
        Intrinsics.checkNotNullParameter(options, (String)"options");
        SBNWJsonMap jsonMap = new SBNWJsonMap(options);
        List<String> imageUris = jsonMap.getStringsOrThrow("imageFileUris");
        List<BarcodeScanningResult> results = SBNWBarcodeHelper.INSTANCE.detectBarcodesOnMultipleImages(imageUris, new SBNWBarcodeDetectionParameters(options));
        Iterable iterable = results;
        String string = "results";
        boolean $i$f$mapIndexed = false;
        void var7_8 = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void result;
            void index;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            BarcodeScanningResult barcodeScanningResult = (BarcodeScanningResult)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"imageFileUri", (Object)imageUris.get((int)index)), TuplesKt.to((Object)"barcodeResults", BarcodeExtensionsKt.toJson((BarcodeScanningResult)result))};
            collection.add(MapsKt.mapOf((Pair[])pairArray));
        }
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)string, (Object)((List)destination$iv$iv)));
    }
}

