/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.sdk_native_wrapper.wrapper.ui;

import android.content.Context;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.appcompat.app.AppCompatActivity;
import io.scanbot.sdk.sdk_native_wrapper.base.SBNWProxyDelegate;
import io.scanbot.sdk.sdk_native_wrapper.converters.GenericDocumentRecognizerExtensionsKt;
import io.scanbot.sdk.sdk_native_wrapper.wrapper.ui.base.SBNWRtuWrapper;
import io.scanbot.sdk.ui.view.genericdocument.GenericDocumentRecognizerActivity;
import io.scanbot.sdk.ui.view.genericdocument.configuration.GenericDocumentRecognizerConfiguration;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0018\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0019H\u0014R\u001e\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\r\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR \u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u000f8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001a"}, d2={"Lio/scanbot/sdk/sdk_native_wrapper/wrapper/ui/SBNWRtuGenericDocumentRecognizer;", "Lio/scanbot/sdk/sdk_native_wrapper/wrapper/ui/base/SBNWRtuWrapper;", "Lio/scanbot/sdk/ui/view/genericdocument/configuration/GenericDocumentRecognizerConfiguration;", "Lio/scanbot/sdk/ui/view/genericdocument/GenericDocumentRecognizerActivity$Result;", "activity", "Landroidx/appcompat/app/AppCompatActivity;", "(Landroidx/appcompat/app/AppCompatActivity;)V", "imageQuality", "", "getImageQuality", "()Ljava/lang/Integer;", "setImageQuality", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "resultContract", "Landroidx/activity/result/contract/ActivityResultContract;", "getResultContract", "()Landroidx/activity/result/contract/ActivityResultContract;", "forceClose", "", "context", "Landroid/content/Context;", "handleResult", "resultEntity", "delegate", "Lio/scanbot/sdk/sdk_native_wrapper/base/SBNWProxyDelegate;", "sdk-native-wrapper_release"})
public final class SBNWRtuGenericDocumentRecognizer
extends SBNWRtuWrapper<GenericDocumentRecognizerConfiguration, GenericDocumentRecognizerActivity.Result> {
    @Nullable
    private Integer imageQuality;

    public SBNWRtuGenericDocumentRecognizer(@NotNull AppCompatActivity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        super(activity);
    }

    @Override
    @NotNull
    protected ActivityResultContract<GenericDocumentRecognizerConfiguration, GenericDocumentRecognizerActivity.Result> getResultContract() {
        return (ActivityResultContract)new GenericDocumentRecognizerActivity.ResultContract();
    }

    @Nullable
    public final Integer getImageQuality() {
        return this.imageQuality;
    }

    public final void setImageQuality(@Nullable Integer n) {
        this.imageQuality = n;
    }

    @Override
    protected void handleResult(@NotNull GenericDocumentRecognizerActivity.Result resultEntity, @NotNull SBNWProxyDelegate delegate) {
        Intrinsics.checkNotNullParameter((Object)resultEntity, (String)"resultEntity");
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        if (!resultEntity.getResultOk()) {
            SBNWProxyDelegate.Companion.sendCanceled$sdk_native_wrapper_release(delegate);
            return;
        }
        List result = resultEntity.getResult();
        if (result == null) {
            SBNWProxyDelegate.Companion.sendFailure$sdk_native_wrapper_release(delegate, "Cannot parse Generic Document Recognizer result");
            return;
        }
        SBNWProxyDelegate.Companion.sendSuccess$sdk_native_wrapper_release(delegate, GenericDocumentRecognizerExtensionsKt.toJson(result, this.imageQuality));
    }

    @Override
    protected void forceClose(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        GenericDocumentRecognizerActivity.Companion.forceClose(context);
    }
}

