/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.sdk_native_wrapper.converters;

import io.scanbot.sdk.barcode.entity.BarcodeDensity;
import io.scanbot.sdk.barcode.entity.BarcodeDocumentFormat;
import io.scanbot.sdk.barcode.entity.BarcodeFormat;
import io.scanbot.sdk.barcode.entity.BarcodeItem;
import io.scanbot.sdk.barcode.entity.BarcodeScanningResult;
import io.scanbot.sdk.barcode.entity.MSIPlesseyChecksumAlgorithm;
import io.scanbot.sdk.sdk_native_wrapper.converters.CommonExtensionsKt;
import io.scanbot.sdk.sdk_native_wrapper.converters.SBNWJsonConverters;
import io.scanbot.sdk.sdk_native_wrapper.errors.SBNWCommonExceptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0003H\u0000\u001a\u001a\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00050\u0004*\u0004\u0018\u00010\u0006H\u0000\u001a\f\u0010\u0007\u001a\u00020\b*\u00020\u0001H\u0000\u001a\f\u0010\t\u001a\u00020\u0002*\u00020\u0001H\u0000\u001a\u0018\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b*\b\u0012\u0004\u0012\u00020\u00010\u000bH\u0000\u001a\f\u0010\f\u001a\u00020\u0003*\u00020\u0001H\u0000\u001a\u0018\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b*\b\u0012\u0004\u0012\u00020\u00010\u000bH\u0000\u001a\f\u0010\u000e\u001a\u00020\u000f*\u00020\u0001H\u0000\u00a8\u0006\u0010"}, d2={"toJson", "", "Lio/scanbot/sdk/barcode/entity/BarcodeDocumentFormat;", "Lio/scanbot/sdk/barcode/entity/BarcodeFormat;", "", "", "Lio/scanbot/sdk/barcode/entity/BarcodeScanningResult;", "toSdkBarcodeDensity", "Lio/scanbot/sdk/barcode/entity/BarcodeDensity;", "toSdkBarcodeDocumentFormat", "toSdkBarcodeDocumentFormats", "", "toSdkBarcodeFormat", "toSdkBarcodeFormats", "toSdkMsiPlesseyChecksumAlgorithm", "Lio/scanbot/sdk/barcode/entity/MSIPlesseyChecksumAlgorithm;", "sdk-native-wrapper_release"})
public final class BarcodeExtensionsKt {
    @NotNull
    public static final Map<String, Object> toJson(@Nullable BarcodeScanningResult $this$toJson) {
        List barcodes = new ArrayList();
        BarcodeScanningResult barcodeScanningResult = $this$toJson;
        if (barcodeScanningResult != null) {
            List list = barcodeScanningResult.getBarcodeItems();
            if (list != null) {
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    BarcodeItem barcode = (BarcodeItem)element$iv;
                    boolean bl = false;
                    Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"text", (Object)barcode.getText()), TuplesKt.to((Object)"textWithExtension", (Object)barcode.getTextWithExtension()), TuplesKt.to((Object)"type", (Object)BarcodeExtensionsKt.toJson(barcode.getBarcodeFormat())), TuplesKt.to((Object)"rawBytes", (Object)CommonExtensionsKt.toJson(barcode.getRawBytes()))};
                    barcodes.add(MapsKt.mapOf((Pair[])pairArray));
                }
            }
        }
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)"barcodes", (Object)barcodes));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<BarcodeFormat> toSdkBarcodeFormats(@NotNull List<String> $this$toSdkBarcodeFormats) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$toSdkBarcodeFormats, (String)"<this>");
        Iterable $this$map$iv = $this$toSdkBarcodeFormats;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(BarcodeExtensionsKt.toSdkBarcodeFormat((String)it));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final String toJson(@NotNull BarcodeFormat $this$toJson) {
        Intrinsics.checkNotNullParameter((Object)$this$toJson, (String)"<this>");
        return SBNWJsonConverters.INSTANCE.getBarcodeFormat().convertToJsonValue($this$toJson);
    }

    @NotNull
    public static final BarcodeFormat toSdkBarcodeFormat(@NotNull String $this$toSdkBarcodeFormat) {
        Intrinsics.checkNotNullParameter((Object)$this$toSdkBarcodeFormat, (String)"<this>");
        return SBNWJsonConverters.INSTANCE.getBarcodeFormat().convertToSdkValue($this$toSdkBarcodeFormat);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<BarcodeDocumentFormat> toSdkBarcodeDocumentFormats(@NotNull List<String> $this$toSdkBarcodeDocumentFormats) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$toSdkBarcodeDocumentFormats, (String)"<this>");
        Iterable $this$map$iv = $this$toSdkBarcodeDocumentFormats;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(BarcodeExtensionsKt.toSdkBarcodeDocumentFormat((String)it));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final String toJson(@NotNull BarcodeDocumentFormat $this$toJson) {
        Intrinsics.checkNotNullParameter((Object)$this$toJson, (String)"<this>");
        return SBNWJsonConverters.INSTANCE.getBarcodeDocumentFormat().convertToJsonValue($this$toJson);
    }

    @NotNull
    public static final BarcodeDocumentFormat toSdkBarcodeDocumentFormat(@NotNull String $this$toSdkBarcodeDocumentFormat) {
        Intrinsics.checkNotNullParameter((Object)$this$toSdkBarcodeDocumentFormat, (String)"<this>");
        return SBNWJsonConverters.INSTANCE.getBarcodeDocumentFormat().convertToSdkValue($this$toSdkBarcodeDocumentFormat);
    }

    @NotNull
    public static final MSIPlesseyChecksumAlgorithm toSdkMsiPlesseyChecksumAlgorithm(@NotNull String $this$toSdkMsiPlesseyChecksumAlgorithm) {
        MSIPlesseyChecksumAlgorithm mSIPlesseyChecksumAlgorithm;
        Intrinsics.checkNotNullParameter((Object)$this$toSdkMsiPlesseyChecksumAlgorithm, (String)"<this>");
        switch ($this$toSdkMsiPlesseyChecksumAlgorithm) {
            case "None": {
                mSIPlesseyChecksumAlgorithm = MSIPlesseyChecksumAlgorithm.None;
                break;
            }
            case "Mod10": {
                mSIPlesseyChecksumAlgorithm = MSIPlesseyChecksumAlgorithm.Mod10;
                break;
            }
            case "Mod11IBM": {
                mSIPlesseyChecksumAlgorithm = MSIPlesseyChecksumAlgorithm.Mod11IBM;
                break;
            }
            case "Mod11NCR": {
                mSIPlesseyChecksumAlgorithm = MSIPlesseyChecksumAlgorithm.Mod11NCR;
                break;
            }
            case "Mod1010": {
                mSIPlesseyChecksumAlgorithm = MSIPlesseyChecksumAlgorithm.Mod1010;
                break;
            }
            case "Mod1110IBM": {
                mSIPlesseyChecksumAlgorithm = MSIPlesseyChecksumAlgorithm.Mod1110IBM;
                break;
            }
            case "Mod1110NCR": {
                mSIPlesseyChecksumAlgorithm = MSIPlesseyChecksumAlgorithm.Mod1110NCR;
                break;
            }
            default: {
                throw new SBNWCommonExceptions.SBSDKOptionNotHandled($this$toSdkMsiPlesseyChecksumAlgorithm);
            }
        }
        return mSIPlesseyChecksumAlgorithm;
    }

    @NotNull
    public static final BarcodeDensity toSdkBarcodeDensity(@NotNull String $this$toSdkBarcodeDensity) {
        BarcodeDensity barcodeDensity;
        Intrinsics.checkNotNullParameter((Object)$this$toSdkBarcodeDensity, (String)"<this>");
        String string = $this$toSdkBarcodeDensity;
        if (Intrinsics.areEqual((Object)string, (Object)"LOW")) {
            barcodeDensity = BarcodeDensity.LOW;
        } else if (Intrinsics.areEqual((Object)string, (Object)"HIGH")) {
            barcodeDensity = BarcodeDensity.HIGH;
        } else {
            throw new SBNWCommonExceptions.SBSDKOptionNotHandled($this$toSdkBarcodeDensity);
        }
        return barcodeDensity;
    }
}

