/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.sdk_native_wrapper.helpers;

import android.app.Application;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.media.ExifInterface;
import android.net.Uri;
import android.util.Base64;
import io.scanbot.sdk.exceptions.crypto.SourceFileDoesNotExistException;
import io.scanbot.sdk.sdk_native_wrapper.SBNWOperations;
import io.scanbot.sdk.sdk_native_wrapper.errors.SBNWCommonExceptions;
import io.scanbot.sdk.sdk_native_wrapper.utils.SBNWStorageUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bJ\u001e\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\bJ\u0010\u0010\u0010\u001a\u00020\u00062\b\u0010\u0011\u001a\u0004\u0018\u00010\bJ\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0016\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0004J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a8\u0006\u001d"}, d2={"Lio/scanbot/sdk/sdk_native_wrapper/helpers/SBNWBitmapHelper;", "", "()V", "estimateBlur", "", "bitmap", "Landroid/graphics/Bitmap;", "imageUri", "", "getBase64Data", "handleImageRotation", "context", "Landroid/content/Context;", "imagePath", "loadAndDecodeBitmap", "imageFilePath", "loadImage", "imageFile", "loadImageFromContentUri", "contentUri", "Landroid/net/Uri;", "rotateImage", "source", "angle", "storeImageAsFile", "Ljava/io/File;", "image", "quality", "", "sdk-native-wrapper_release"})
public final class SBNWBitmapHelper {
    @NotNull
    public static final SBNWBitmapHelper INSTANCE = new SBNWBitmapHelper();

    private SBNWBitmapHelper() {
    }

    @NotNull
    public final File storeImageAsFile(@NotNull Bitmap image, int quality, @NotNull Context context) throws IOException {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        File pictureFile = SBNWStorageUtils.INSTANCE.generateRandomPluginStorageFile("jpg", context);
        FileOutputStream fos = new FileOutputStream(pictureFile);
        image.compress(Bitmap.CompressFormat.JPEG, quality, (OutputStream)fos);
        fos.close();
        return pictureFile;
    }

    public static /* synthetic */ File storeImageAsFile$default(SBNWBitmapHelper sBNWBitmapHelper, Bitmap bitmap, int n, Context context, int n2, Object object) throws IOException {
        if ((n2 & 4) != 0) {
            context = (Context)SBNWOperations.INSTANCE.getWrapper$sdk_native_wrapper_release().getApplication();
        }
        return sBNWBitmapHelper.storeImageAsFile(bitmap, n, context);
    }

    @NotNull
    public final Bitmap loadImage(@Nullable String imageFile) throws IOException, SBNWCommonExceptions.SBSDKInvalidJSON {
        String string = imageFile;
        if (string != null) {
            String file = string;
            boolean bl = false;
            if (((CharSequence)((Object)StringsKt.trim((CharSequence)file)).toString()).length() > 0) {
                Bitmap bitmap;
                try {
                    bitmap = INSTANCE.loadAndDecodeBitmap(file);
                }
                catch (SourceFileDoesNotExistException err) {
                    if (!StringsKt.contains$default((CharSequence)imageFile, (CharSequence)"content:", (boolean)false, (int)2, null)) {
                        throw err;
                    }
                    String $this$toUri$iv = file;
                    boolean $i$f$toUri = false;
                    Uri uri = Uri.parse((String)$this$toUri$iv);
                    Intrinsics.checkExpressionValueIsNotNull((Object)uri, (String)"Uri.parse(this)");
                    bitmap = INSTANCE.loadImageFromContentUri(uri);
                }
                return bitmap;
            }
        }
        throw new SBNWCommonExceptions.SBSDKInvalidJSON(Intrinsics.stringPlus((String)"Invalid imageFile. Must be a file URI or a file path: ", (Object)imageFile));
    }

    private final Bitmap loadImageFromContentUri(Uri contentUri) {
        try {
            Application context = SBNWOperations.INSTANCE.getWrapper$sdk_native_wrapper_release().getApplication();
            InputStream inputStream = context.getContentResolver().openInputStream(contentUri);
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)inputStream);
            if (bitmap == null) {
                throw new IOException();
            }
            Bitmap bitmap2 = bitmap;
            InputStream inputStream2 = inputStream;
            if (inputStream2 != null) {
                inputStream2.close();
            }
            return bitmap2;
        }
        catch (Exception err) {
            throw new SBNWCommonExceptions.SBSDKFunctionError(Intrinsics.stringPlus((String)"Cannot load image: ", (Object)contentUri));
        }
    }

    @NotNull
    public final Bitmap loadAndDecodeBitmap(@NotNull String imageFilePath) throws IOException {
        Intrinsics.checkNotNullParameter((Object)imageFilePath, (String)"imageFilePath");
        Uri uri = Uri.parse((String)imageFilePath);
        if (uri != null) {
            Uri it = uri;
            boolean bl = false;
            Bitmap bitmap = SBNWOperations.INSTANCE.getInternalSdk$sdk_native_wrapper_release().fileIOProcessor().readImage(it, null);
            if (bitmap == null) {
                throw new IOException(Intrinsics.stringPlus((String)"Cannot load ", (Object)imageFilePath));
            }
            return bitmap;
        }
        throw new IOException(Intrinsics.stringPlus((String)"Invalid URI. Cannot load ", (Object)imageFilePath));
    }

    @NotNull
    public final Bitmap handleImageRotation(@NotNull Context context, @NotNull String imagePath, @NotNull Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)imagePath, (String)"imagePath");
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        try {
            Bitmap bitmap2;
            ExifInterface exifInterface;
            if (StringsKt.startsWith$default((String)imagePath, (String)"content:/", (boolean)false, (int)2, null)) {
                InputStream inputStream = context.getContentResolver().openInputStream(Uri.parse((String)imagePath));
                if (inputStream == null) {
                    throw new IOException("Cannot process given image");
                }
                InputStream inputStream2 = inputStream;
                exifInterface = new ExifInterface(inputStream2);
            } else {
                exifInterface = new ExifInterface(imagePath);
            }
            ExifInterface ei = exifInterface;
            int orientation = ei.getAttributeInt("Orientation", 0);
            switch (orientation) {
                case 6: {
                    bitmap2 = this.rotateImage(bitmap, 90.0f);
                    break;
                }
                case 3: {
                    bitmap2 = this.rotateImage(bitmap, 180.0f);
                    break;
                }
                case 8: {
                    bitmap2 = this.rotateImage(bitmap, 270.0f);
                    break;
                }
                case 1: {
                    bitmap2 = bitmap;
                    break;
                }
                default: {
                    bitmap2 = bitmap;
                }
            }
            return bitmap2;
        }
        catch (Exception e) {
            e.printStackTrace();
            return bitmap;
        }
    }

    public final float estimateBlur(@NotNull Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        return SBNWOperations.INSTANCE.getInternalSdk$sdk_native_wrapper_release().createBlurEstimator().estimateInBitmap(bitmap, 0);
    }

    public final float estimateBlur(@NotNull String imageUri) {
        Intrinsics.checkNotNullParameter((Object)imageUri, (String)"imageUri");
        return this.estimateBlur(this.loadImage(imageUri));
    }

    @NotNull
    public final String getBase64Data(@NotNull String imageUri) throws SBNWCommonExceptions.SBSDKUriParsingError {
        File file;
        Intrinsics.checkNotNullParameter((Object)imageUri, (String)"imageUri");
        Uri uri = Uri.parse((String)imageUri);
        String string = uri.getPath();
        if (string == null) {
            file = null;
        } else {
            String it = string;
            boolean bl = false;
            file = new File(it);
        }
        if (file == null) {
            throw new SBNWCommonExceptions.SBSDKUriParsingError(null, 1, null);
        }
        File file2 = file;
        byte[] data = SBNWOperations.INSTANCE.getInternalSdk$sdk_native_wrapper_release().fileIOProcessor().read(file2);
        String string2 = Base64.encodeToString((byte[])data, (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"encodeToString(data, Base64.DEFAULT)");
        return string2;
    }

    @NotNull
    public final Bitmap rotateImage(@NotNull Bitmap source, float angle) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Matrix matrix = new Matrix();
        matrix.postRotate(angle);
        Bitmap bitmap = Bitmap.createBitmap((Bitmap)source, (int)0, (int)0, (int)source.getWidth(), (int)source.getHeight(), (Matrix)matrix, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"createBitmap(source, 0, \u2026rce.height, matrix, true)");
        return bitmap;
    }
}

