/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.sdk_native_wrapper.wrapper.operations;

import android.content.Context;
import android.net.Uri;
import io.scanbot.sdk.exceptions.files.FileAccessException;
import io.scanbot.sdk.persistence.Page;
import io.scanbot.sdk.process.ImageFilterType;
import io.scanbot.sdk.sdk_native_wrapper.SBNWOperations;
import io.scanbot.sdk.sdk_native_wrapper.converters.CommonExtensionsKt;
import io.scanbot.sdk.sdk_native_wrapper.converters.PageExtensionsKt;
import io.scanbot.sdk.sdk_native_wrapper.errors.SBNWCommonExceptions;
import io.scanbot.sdk.sdk_native_wrapper.helpers.BiMapKt;
import io.scanbot.sdk.sdk_native_wrapper.helpers.ImageFilterTypeMapped;
import io.scanbot.sdk.sdk_native_wrapper.helpers.SBNWJsonMap;
import io.scanbot.sdk.sdk_native_wrapper.helpers.SBNWPageHelper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bJ.\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00042\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00042\u0006\u0010\u000b\u001a\u00020\u0005J&\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00042\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004J&\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00042\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004J.\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00042\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00042\u0006\u0010\u0010\u001a\u00020\u0011\u00a8\u0006\u0012"}, d2={"Lio/scanbot/sdk/sdk_native_wrapper/wrapper/operations/SBNWPageOperations;", "", "()V", "createPage", "", "", "imageUri", "context", "Landroid/content/Context;", "getFilteredDocumentPreviewUri", "page", "filterName", "recreatePages", "options", "removePage", "rotatePage", "times", "", "sdk-native-wrapper_release"})
public final class SBNWPageOperations {
    @NotNull
    public static final SBNWPageOperations INSTANCE = new SBNWPageOperations();

    private SBNWPageOperations() {
    }

    @NotNull
    public final Map<String, Object> createPage(@NotNull String imageUri, @NotNull Context context) throws SBNWCommonExceptions.SBSDKFunctionError {
        Intrinsics.checkNotNullParameter((Object)imageUri, (String)"imageUri");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            return PageExtensionsKt.toJson(SBNWPageHelper.INSTANCE.createPageWithImage(imageUri, context));
        }
        catch (IOException ioe) {
            throw new SBNWCommonExceptions.SBSDKFunctionError("There was a problem when processing the given file with URI " + imageUri + ". REASON: " + ioe.getMessage());
        }
    }

    @NotNull
    public final Map<String, Object> removePage(@NotNull Map<String, ? extends Object> page) throws SBNWCommonExceptions.SBSDKFunctionError {
        Intrinsics.checkNotNullParameter(page, (String)"page");
        try {
            Object object = page.get("pageId");
            String string = object instanceof String ? (String)object : null;
            if (string == null) {
                throw new SBNWCommonExceptions.SBSDKInvalidJSON("Missing required parameter 'pageId'");
            }
            String pageId = string;
            boolean success = SBNWOperations.INSTANCE.getInternalSdk$sdk_native_wrapper_release().createPageFileStorage().remove(pageId);
            return MapsKt.mapOf((Pair)TuplesKt.to((Object)"operationResult", (Object)(success ? "SUCCESS" : "FAILED")));
        }
        catch (Exception err) {
            throw new SBNWCommonExceptions.SBSDKFunctionError("Unknown error while trying to remove page: " + page + "; EXCEPTION: " + err.getLocalizedMessage());
        }
    }

    @NotNull
    public final Map<String, Object> rotatePage(@NotNull Map<String, ? extends Object> page, int times) {
        Intrinsics.checkNotNullParameter(page, (String)"page");
        return PageExtensionsKt.toJson(SBNWOperations.INSTANCE.getInternalSdk$sdk_native_wrapper_release().createPageProcessor().rotate(PageExtensionsKt.toSdkPage(page), times));
    }

    @NotNull
    public final Map<String, Object> getFilteredDocumentPreviewUri(@NotNull Map<String, ? extends Object> page, @NotNull String filterName) {
        Intrinsics.checkNotNullParameter(page, (String)"page");
        Intrinsics.checkNotNullParameter((Object)filterName, (String)"filterName");
        Page sdkPage = PageExtensionsKt.toSdkPage(page);
        ImageFilterType filter = BiMapKt.getImageFilterBiMap().get(ImageFilterTypeMapped.valueOf(filterName));
        Uri uri = SBNWOperations.INSTANCE.getInternalSdk$sdk_native_wrapper_release().createPageFileStorage().getFilteredPreviewImageURI(sdkPage.getPageId(), filter);
        String string = uri.getPath();
        if (string == null) {
            throw new SBNWCommonExceptions.SBSDKUriParsingError(Intrinsics.stringPlus((String)"Invalid URI: ", (Object)uri));
        }
        String path = string;
        if (!new File(path).exists()) {
            try {
                SBNWOperations.INSTANCE.getInternalSdk$sdk_native_wrapper_release().createPageProcessor().generateFilteredPreview(sdkPage, filter);
            }
            catch (FileAccessException err) {
                throw new SBNWCommonExceptions.SBSDKFunctionError(Intrinsics.stringPlus((String)err.getLocalizedMessage(), (Object)" If you have manually created this page, you have to run document detection before being able to apply a filter on it. See 'detectDocument' function."));
            }
            if (!new File(path).exists()) {
                throw new SBNWCommonExceptions.SBSDKFunctionError(Intrinsics.stringPlus((String)"Cannot create filtered preview for uri: ", (Object)uri));
            }
        }
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)"filteredDocumentPreviewUri", (Object)CommonExtensionsKt.withHash(uri)));
    }

    @NotNull
    public final Map<String, Object> recreatePages(@NotNull Map<String, ? extends Object> options) {
        Page it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter(options, (String)"options");
        List<Map<String, Object>> pages = new SBNWJsonMap(options).getRawMapsOrThrow("pages");
        Iterable iterable = pages;
        String string = "pages";
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Map map = (Map)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(PageExtensionsKt.toSdkPage((Map<String, ? extends Object>)it));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Page)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(PageExtensionsKt.toJson(it));
        }
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)string, (Object)((List)destination$iv$iv)));
    }
}

