/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.sdk_native_wrapper.helpers;

import android.app.Application;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.media.ExifInterface;
import android.net.Uri;
import android.os.Build;
import android.util.Base64;
import android.util.Log;
import androidx.core.net.UriKt;
import io.scanbot.sdk.ScanbotSDK;
import io.scanbot.sdk.sdk_native_wrapper.SBNWOperations;
import io.scanbot.sdk.sdk_native_wrapper.errors.SBNWCommonExceptions;
import io.scanbot.sdk.sdk_native_wrapper.extensions.UriExtensionsKt;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0007\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0002J\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u000eJ\u000e\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0004J\u0010\u0010\u0015\u001a\u00020\u000e2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\tH\u0002J\u0010\u0010\u0019\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0016\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001d\u00a8\u0006\u001e"}, d2={"Lio/scanbot/sdk/sdk_native_wrapper/helpers/SBNWBitmapHelper;", "", "()V", "getBase64Data", "", "imageUri", "getInputStream", "Ljava/io/InputStream;", "uri", "Landroid/net/Uri;", "getInputStreamBytes", "", "inputStream", "handleImageRotation", "Landroid/graphics/Bitmap;", "context", "Landroid/content/Context;", "imagePath", "bitmap", "loadAndDecodeBitmap", "imageFilePath", "loadImage", "imageFile", "loadImageFromContentUri", "contentUri", "openAssetInputStream", "rotateImage", "source", "angle", "", "sdk-native-wrapper_release"})
@SourceDebugExtension(value={"SMAP\nSBNWBitmapHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SBNWBitmapHelper.kt\nio/scanbot/sdk/sdk_native_wrapper/helpers/SBNWBitmapHelper\n+ 2 Uri.kt\nandroidx/core/net/UriKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,174:1\n29#2:175\n1#3:176\n*S KotlinDebug\n*F\n+ 1 SBNWBitmapHelper.kt\nio/scanbot/sdk/sdk_native_wrapper/helpers/SBNWBitmapHelper\n*L\n31#1:175\n*E\n"})
public final class SBNWBitmapHelper {
    @NotNull
    public static final SBNWBitmapHelper INSTANCE = new SBNWBitmapHelper();

    private SBNWBitmapHelper() {
    }

    @NotNull
    public final Bitmap loadImage(@Nullable String imageFile) throws IOException, SBNWCommonExceptions.SBSDKInvalidJSON {
        String string = imageFile;
        if (string != null) {
            String file = string;
            boolean bl = false;
            if (((CharSequence)((Object)StringsKt.trim((CharSequence)file)).toString()).length() > 0) {
                Bitmap bitmap;
                try {
                    bitmap = INSTANCE.loadAndDecodeBitmap(file);
                }
                catch (Exception err) {
                    String $this$toUri$iv = file;
                    boolean $i$f$toUri = false;
                    Uri uri = Uri.parse((String)$this$toUri$iv);
                    Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"parse(this)");
                    bitmap = INSTANCE.loadImageFromContentUri(uri);
                }
                return bitmap;
            }
        }
        throw new SBNWCommonExceptions.SBSDKInvalidJSON("Invalid imageFile. Must be a file URI or a file path: " + imageFile);
    }

    private final Bitmap loadImageFromContentUri(Uri contentUri) {
        try {
            Application context = SBNWOperations.INSTANCE.getWrapper$sdk_native_wrapper_release().getApplication();
            InputStream inputStream = context.getContentResolver().openInputStream(contentUri);
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)inputStream);
            if (bitmap == null) {
                throw new IOException();
            }
            Bitmap bitmap2 = bitmap;
            InputStream inputStream2 = inputStream;
            if (inputStream2 != null) {
                inputStream2.close();
            }
            return bitmap2;
        }
        catch (Exception err) {
            throw new SBNWCommonExceptions.SBSDKFunctionError("Cannot load image: " + contentUri);
        }
    }

    @NotNull
    public final Bitmap loadAndDecodeBitmap(@NotNull String imageFilePath) throws IOException {
        Intrinsics.checkNotNullParameter((Object)imageFilePath, (String)"imageFilePath");
        Uri uri = Uri.parse((String)imageFilePath);
        if (uri != null) {
            Uri it = uri;
            boolean bl = false;
            Bitmap bitmap = SBNWOperations.INSTANCE.getInternalSdk$sdk_native_wrapper_release().fileIOProcessor().readImage(it, null);
            if (bitmap == null) {
                throw new IOException("Cannot load " + imageFilePath);
            }
            return bitmap;
        }
        throw new IOException("Invalid URI. Cannot load " + imageFilePath);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final Bitmap handleImageRotation(@NotNull Context context, @NotNull String imagePath, @NotNull Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)imagePath, (String)"imagePath");
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        try {
            Bitmap bitmap2;
            Object object;
            if (StringsKt.startsWith$default((String)imagePath, (String)"content:/", (boolean)false, (int)2, null)) {
                InputStream inputStream = context.getContentResolver().openInputStream(Uri.parse((String)imagePath));
                if (inputStream == null) {
                    throw new IOException("Cannot process given image");
                }
                InputStream inputStream2 = inputStream;
                if (Build.VERSION.SDK_INT < 24) return bitmap;
                object = new ExifInterface(inputStream2);
            } else {
                Object fixedPath;
                try {
                    new ExifInterface(imagePath);
                }
                catch (Exception err) {
                    Log.e((String)"ScanbotSDK", (String)"Cannot extract EXIF data from the given image");
                    return bitmap;
                }
                try {
                    fixedPath = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)imagePath, (String)"file://", (String)"", (boolean)false, (int)4, null), (String)"file:/", (String)"", (boolean)false, (int)4, null), (String)"file:", (String)"", (boolean)false, (int)4, null);
                    fixedPath = StringsKt.startsWith$default((String)fixedPath, (String)"/", (boolean)false, (int)2, null) ? fixedPath : "/" + (String)fixedPath;
                    fixedPath = new ExifInterface((String)fixedPath);
                }
                catch (Exception err) {
                    Log.e((String)"ScanbotSDK", (String)"Cannot extract EXIF data from the given image");
                    return bitmap;
                }
                object = fixedPath;
            }
            ExifInterface ei = object;
            int orientation = ei.getAttributeInt("Orientation", 0);
            switch (orientation) {
                case 6: {
                    bitmap2 = this.rotateImage(bitmap, 90.0f);
                    return bitmap2;
                }
                case 3: {
                    bitmap2 = this.rotateImage(bitmap, 180.0f);
                    return bitmap2;
                }
                case 8: {
                    bitmap2 = this.rotateImage(bitmap, 270.0f);
                    return bitmap2;
                }
                case 1: {
                    bitmap2 = bitmap;
                    return bitmap2;
                }
                default: {
                    bitmap2 = bitmap;
                }
            }
            return bitmap2;
        }
        catch (Exception e) {
            e.printStackTrace();
            return bitmap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String getBase64Data(@NotNull String imageUri) throws SBNWCommonExceptions.SBSDKUriParsingError {
        Object object;
        Intrinsics.checkNotNullParameter((Object)imageUri, (String)"imageUri");
        Uri uri = Uri.parse((String)imageUri);
        try {
            Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"uri");
            Closeable closeable = this.getInputStream(uri);
            Throwable throwable = null;
            try {
                Object inputStream = (InputStream)closeable;
                boolean bl = false;
                INSTANCE.loadImageFromContentUri(uri);
                byte[] inputData = INSTANCE.getInputStreamBytes((InputStream)inputStream);
                inputStream = Base64.encodeToString((byte[])inputData, (int)2);
            }
            catch (Throwable inputStream) {
                throwable = inputStream;
                throw inputStream;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            object = inputStream;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"{\n            getInputSt\u2026)\n            }\n        }");
        }
        catch (Exception exception) {
            String string = uri.getPath();
            if (string == null) {
                throw new SBNWCommonExceptions.SBSDKUriParsingError(null, 1, null);
            }
            String it = string;
            boolean bl = false;
            File file = new File(it);
            ScanbotSDK scanbotSDK = new ScanbotSDK(SBNWOperations.INSTANCE.getWrapper$sdk_native_wrapper_release().getApplication());
            byte[] data = scanbotSDK.fileIOProcessor().read(file);
            String string2 = Base64.encodeToString((byte[])data, (int)2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n            // Loading\u2026Base64.NO_WRAP)\n        }");
            object = string2;
        }
        return object;
    }

    private final InputStream getInputStream(Uri uri) throws IOException {
        InputStream inputStream;
        if (Intrinsics.areEqual((Object)uri.getScheme(), (Object)"file")) {
            inputStream = new FileInputStream(UriKt.toFile((Uri)uri));
        } else if (Intrinsics.areEqual((Object)uri.getScheme(), (Object)"asset")) {
            inputStream = this.openAssetInputStream(uri);
        } else if (UriExtensionsKt.isSAFUri(uri)) {
            inputStream = SBNWOperations.INSTANCE.getWrapper$sdk_native_wrapper_release().getApplication().getContentResolver().openInputStream(uri);
            if (inputStream == null) {
                throw new SBNWCommonExceptions.SBSDKFunctionError("Cannot open input stream for URI: " + uri);
            }
        } else {
            throw new IOException("Unsupported scheme for location '" + uri + "'.");
        }
        return inputStream;
    }

    private final InputStream openAssetInputStream(Uri uri) throws IOException {
        String string = uri.getPath();
        if (string == null) {
            String string2 = "Required value was null.";
            throw new IllegalArgumentException(string2.toString());
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"requireNotNull(uri.path)");
        String string3 = string;
        int n = 1;
        String string4 = string3.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).substring(startIndex)");
        String asset = string4;
        InputStream inputStream = SBNWOperations.INSTANCE.getWrapper$sdk_native_wrapper_release().getApplication().getAssets().open(asset);
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"SBNWOperations.wrapper.a\u2026cation.assets.open(asset)");
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final byte[] getInputStreamBytes(InputStream inputStream) throws IOException {
        byte[] bytesResult = null;
        ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream();
        int bufferSize = 1024;
        byte[] buffer = new byte[bufferSize];
        try {
            int len = 0;
            while (true) {
                int n;
                int it = n = inputStream.read(buffer);
                boolean bl = false;
                len = it;
                if (n == -1) break;
                byteBuffer.write(buffer, 0, len);
            }
            byte[] byArray = byteBuffer.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"byteBuffer.toByteArray()");
            bytesResult = byArray;
        }
        finally {
            try {
                byteBuffer.close();
            }
            catch (IOException iOException) {}
        }
        return bytesResult;
    }

    @NotNull
    public final Bitmap rotateImage(@NotNull Bitmap source, float angle) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Matrix matrix = new Matrix();
        matrix.postRotate(angle);
        Bitmap bitmap = Bitmap.createBitmap((Bitmap)source, (int)0, (int)0, (int)source.getWidth(), (int)source.getHeight(), (Matrix)matrix, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"createBitmap(source, 0, \u2026rce.height, matrix, true)");
        return bitmap;
    }
}

