/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.sdk_native_wrapper.utils;

import io.scanbot.sdk.sdk_native_wrapper.errors.SBNWCommonExceptions;
import io.scanbot.sdk.sdk_native_wrapper.extensions.MapJsonExtensionsKt;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\b\t\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003B\u0019\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0017\u0010\b\u001a\u00028\u00002\u0006\u0010\t\u001a\u00028\u0001H\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\b\u001a\u00028\u00012\u0006\u0010\f\u001a\u00028\u0000H\u0007\u00a2\u0006\u0004\b\r\u0010\u000bR\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lio/scanbot/sdk/sdk_native_wrapper/utils/SBNWJsonConverter;", "SdkValue", "JsonValue", "", "map", "", "(Ljava/util/Map;)V", "inverseMap", "convert", "jsonValue", "convertToSdkValue", "(Ljava/lang/Object;)Ljava/lang/Object;", "sdkValue", "convertToJsonValue", "sdk-native-wrapper_release"})
public final class SBNWJsonConverter<SdkValue, JsonValue> {
    @NotNull
    private final Map<SdkValue, JsonValue> map;
    @NotNull
    private final Map<JsonValue, SdkValue> inverseMap;

    public SBNWJsonConverter(@NotNull Map<SdkValue, ? extends JsonValue> map) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        this.map = map;
        this.inverseMap = MapJsonExtensionsKt.inverseMap(this.map);
    }

    @JvmName(name="convertToSdkValue")
    public final SdkValue convertToSdkValue(JsonValue jsonValue) {
        SdkValue SdkValue = this.inverseMap.get(jsonValue);
        if (SdkValue == null) {
            throw new SBNWCommonExceptions.SBSDKInvalidJSON("Invalid JSON value '" + jsonValue + "'");
        }
        return SdkValue;
    }

    @JvmName(name="convertToJsonValue")
    public final JsonValue convertToJsonValue(SdkValue sdkValue) {
        JsonValue JsonValue = this.map.get(sdkValue);
        if (JsonValue == null) {
            throw new SBNWCommonExceptions.SBSDKOptionNotHandled(String.valueOf(sdkValue));
        }
        return JsonValue;
    }
}

