/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.sdk_native_wrapper.wrapper.operations;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import io.scanbot.sdk.process.DocumentQualityAnalyzer;
import io.scanbot.sdk.process.model.DocumentQualityResult;
import io.scanbot.sdk.sdk_native_wrapper.SBNWOperations;
import io.scanbot.sdk.sdk_native_wrapper.configurations.SBDWrapperDocumentQualityAnalyzerArgs;
import io.scanbot.sdk.sdk_native_wrapper.errors.SBNWCommonExceptions;
import io.scanbot.sdk.sdk_native_wrapper.extensions.UriExtensionsKt;
import io.scanbot.sdk.sdk_native_wrapper.helpers.SBNWBitmapHelper;
import io.scanbot.sdk.sdk_native_wrapper.helpers.SBNWJsonMap;
import io.scanbot.sdk.sdk_native_wrapper.utils.SBNWStorageUtils;
import io.scanbot.sdk_wrapper.SBWrapper;
import java.io.File;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00042\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004J&\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00042\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004J&\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00042\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004\u00a8\u0006\t"}, d2={"Lio/scanbot/sdk/sdk_native_wrapper/wrapper/operations/SBNWImageOperations;", "", "()V", "documentQualityAnalyzer", "", "", "options", "getBase64ImageData", "rotateImage", "sdk-native-wrapper_release"})
@SourceDebugExtension(value={"SMAP\nSBNWImageOperations.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SBNWImageOperations.kt\nio/scanbot/sdk/sdk_native_wrapper/wrapper/operations/SBNWImageOperations\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Uri.kt\nandroidx/core/net/UriKt\n*L\n1#1,77:1\n1#2:78\n36#3:79\n*S KotlinDebug\n*F\n+ 1 SBNWImageOperations.kt\nio/scanbot/sdk/sdk_native_wrapper/wrapper/operations/SBNWImageOperations\n*L\n71#1:79\n*E\n"})
public final class SBNWImageOperations {
    @NotNull
    public static final SBNWImageOperations INSTANCE = new SBNWImageOperations();

    private SBNWImageOperations() {
    }

    @NotNull
    public final Map<String, Object> documentQualityAnalyzer(@NotNull Map<String, ? extends Object> options) throws SBNWCommonExceptions.SBSDKResultError {
        DocumentQualityAnalyzer dqa;
        DocumentQualityResult qualityResult;
        int it;
        DocumentQualityAnalyzer documentQualityAnalyzer2;
        Intrinsics.checkNotNullParameter(options, (String)"options");
        SBDWrapperDocumentQualityAnalyzerArgs wrapperConfig = (SBDWrapperDocumentQualityAnalyzerArgs)SBWrapper.getGson().fromJson(new JSONObject(options).toString(), SBDWrapperDocumentQualityAnalyzerArgs.class);
        Bitmap bitmap = SBNWBitmapHelper.INSTANCE.loadImage(wrapperConfig.getImageFileUri());
        DocumentQualityAnalyzer $this$documentQualityAnalyzer_u24lambda_u242 = documentQualityAnalyzer2 = SBNWOperations.INSTANCE.getInternalSdk$sdk_native_wrapper_release().createDocumentQualityAnalyzer();
        boolean bl = false;
        Integer n = wrapperConfig.getImageSizeLimit();
        if (n != null) {
            it = ((Number)n).intValue();
            boolean bl2 = false;
            $this$documentQualityAnalyzer_u24lambda_u242.setAnalyzerImageSizeLimit(it);
        }
        Integer n2 = wrapperConfig.getMinimumNumberOfSymbols();
        if (n2 != null) {
            it = ((Number)n2).intValue();
            boolean bl3 = false;
            $this$documentQualityAnalyzer_u24lambda_u242.setMinEstimatedNumberOfSymbolsForNoDocument(it);
        }
        if ((qualityResult = (dqa = documentQualityAnalyzer2).analyzeInBitmap(bitmap, 0)) != null) {
            return MapsKt.mapOf((Pair)TuplesKt.to((Object)"result", (Object)qualityResult.name()));
        }
        throw new SBNWCommonExceptions.SBSDKResultError(null, 1, null);
    }

    @NotNull
    public final Map<String, Object> getBase64ImageData(@NotNull Map<String, ? extends Object> options) {
        Intrinsics.checkNotNullParameter(options, (String)"options");
        String imageUri = new SBNWJsonMap(options).getStringOrThrow("imageFileUri");
        String base64Data = SBNWBitmapHelper.INSTANCE.getBase64Data(imageUri);
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)"base64ImageData", (Object)base64Data));
    }

    @NotNull
    public final Map<String, Object> rotateImage(@NotNull Map<String, ? extends Object> options) {
        Intrinsics.checkNotNullParameter(options, (String)"options");
        SBNWJsonMap jsonMap = new SBNWJsonMap(options);
        String imageUri = jsonMap.getStringOrThrow("imageFileUri");
        double degrees = jsonMap.getNumberAsDoubleOrThrow("degrees");
        Bitmap bitmap = SBNWBitmapHelper.INSTANCE.loadImage(imageUri);
        Bitmap rotatedBitmap = SBNWBitmapHelper.INSTANCE.rotateImage(bitmap, -((float)degrees));
        File resultImageUri = SBNWStorageUtils.INSTANCE.storeImageAsFile(rotatedBitmap, SBNWOperations.INSTANCE.getPageStorageSettings$sdk_native_wrapper_release().getImageQuality(), (Context)SBNWOperations.INSTANCE.getWrapper$sdk_native_wrapper_release().getApplication());
        Object object = resultImageUri;
        if (object != null) {
            File $this$toUri$iv = object;
            boolean $i$f$toUri = false;
            Uri uri = Uri.fromFile((File)$this$toUri$iv);
            Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"fromFile(this)");
            object = uri;
            if (uri != null && (object = UriExtensionsKt.toFilePath((Uri)object)) != null) {
                Object it = object;
                boolean bl = false;
                return MapsKt.mapOf((Pair)TuplesKt.to((Object)"imageFileUri", (Object)it));
            }
        }
        throw new SBNWCommonExceptions.SBSDKFunctionError("Unexpected error while rotating the given image");
    }
}

