/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk_wrapper.barcode.ui;

import androidx.activity.result.contract.ActivityResultContract;
import io.scanbot.sdk.ui_v2.barcode.BarcodeScannerActivity;
import io.scanbot.sdk.ui_v2.barcode.configuration.BarcodeItem;
import io.scanbot.sdk.ui_v2.barcode.configuration.BarcodeItemMapper;
import io.scanbot.sdk.ui_v2.barcode.configuration.BarcodeMappingResult;
import io.scanbot.sdk.ui_v2.barcode.configuration.BarcodeScannerConfiguration;
import io.scanbot.sdk.ui_v2.barcode.configuration.BarcodeScannerResult;
import io.scanbot.sdk.ui_v2.barcode.configuration.BarcodeUseCase;
import io.scanbot.sdk.ui_v2.barcode.configuration.MultipleScanningMode;
import io.scanbot.sdk.ui_v2.barcode.configuration.SingleScanningMode;
import io.scanbot.sdk.util.log.LoggerProvider;
import io.scanbot.sdk_wrapper.SBWrapper;
import io.scanbot.sdk_wrapper.barcode.extensions.SBWrapperBarcodeItemExtensionKt;
import io.scanbot.sdk_wrapper.barcode.helpers.SBWrapperRtuBarcodeScannerV2BarcodeItemMapper;
import io.scanbot.sdk_wrapper.interfaces.SBWrapperResultDelegate;
import io.scanbot.sdk_wrapper.ui.SBWrapperRtuUI;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000  2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001 BF\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012%\b\u0002\u0010\n\u001a\u001f\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u001c\u001a\u00020\u000fH\u0014J\u0010\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u0003H\u0014J\b\u0010\u001f\u001a\u00020\u000fH\u0002R&\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u0002X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\n\u001a\u001f\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lio/scanbot/sdk_wrapper/barcode/ui/SBWrapperRtuBarcodeScannerV2;", "Lio/scanbot/sdk_wrapper/ui/SBWrapperRtuUI;", "Lio/scanbot/sdk/ui_v2/barcode/configuration/BarcodeScannerConfiguration;", "Lio/scanbot/sdk/ui_v2/barcode/BarcodeScannerActivity$Result;", "wrapperConfiguration", "Lorg/json/JSONObject;", "resultContract", "Lio/scanbot/sdk/ui_v2/barcode/BarcodeScannerActivity$ResultContract;", "resultDelegate", "Lio/scanbot/sdk_wrapper/interfaces/SBWrapperResultDelegate;", "wrapperMapBarcodeItemCallback", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "barcodeItem", "", "(Lorg/json/JSONObject;Lio/scanbot/sdk/ui_v2/barcode/BarcodeScannerActivity$ResultContract;Lio/scanbot/sdk_wrapper/interfaces/SBWrapperResultDelegate;Lkotlin/jvm/functions/Function1;)V", "barcodeMappingResults", "", "", "Lio/scanbot/sdk/ui_v2/barcode/configuration/BarcodeMappingResult;", "getBarcodeMappingResults", "()Ljava/util/Map;", "setBarcodeMappingResults", "(Ljava/util/Map;)V", "configuration", "getConfiguration", "()Lio/scanbot/sdk/ui_v2/barcode/configuration/BarcodeScannerConfiguration;", "extraConfiguration", "handleResult", "activityResult", "initializeMapBarcodeItemCallback", "Companion", "sdk-native-wrapper_release"})
public final class SBWrapperRtuBarcodeScannerV2
extends SBWrapperRtuUI<BarcodeScannerConfiguration, BarcodeScannerActivity.Result> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final SBWrapperResultDelegate resultDelegate;
    @Nullable
    private final Function1<JSONObject, Unit> wrapperMapBarcodeItemCallback;
    @NotNull
    private final BarcodeScannerConfiguration configuration;
    @NotNull
    private Map<String, BarcodeMappingResult> barcodeMappingResults;
    public static final int REQUEST_CODE = 280403;
    @Nullable
    private static Function2<? super BarcodeItem, ? super BarcodeMappingResult, Unit> mapBarcodeItemCallback;

    public SBWrapperRtuBarcodeScannerV2(@NotNull JSONObject wrapperConfiguration, @NotNull BarcodeScannerActivity.ResultContract resultContract, @Nullable SBWrapperResultDelegate resultDelegate, @Nullable Function1<? super JSONObject, Unit> wrapperMapBarcodeItemCallback) {
        Intrinsics.checkNotNullParameter((Object)wrapperConfiguration, (String)"wrapperConfiguration");
        Intrinsics.checkNotNullParameter((Object)resultContract, (String)"resultContract");
        super(wrapperConfiguration, (ActivityResultContract)resultContract, 280403, "BarcodeScanner");
        this.resultDelegate = resultDelegate;
        this.wrapperMapBarcodeItemCallback = wrapperMapBarcodeItemCallback;
        this.configuration = new BarcodeScannerConfiguration(wrapperConfiguration);
        this.barcodeMappingResults = new LinkedHashMap();
        mapBarcodeItemCallback = null;
        LoggerProvider.getLogger().i(SBWrapper.INSTANCE.getLoggerTag$sdk_native_wrapper_release(), "BarcodeScanner initialized");
        this.extraConfiguration();
    }

    public /* synthetic */ SBWrapperRtuBarcodeScannerV2(JSONObject jSONObject, BarcodeScannerActivity.ResultContract resultContract, SBWrapperResultDelegate sBWrapperResultDelegate, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            function1 = null;
        }
        this(jSONObject, resultContract, sBWrapperResultDelegate, (Function1<? super JSONObject, Unit>)function1);
    }

    @Override
    @NotNull
    protected BarcodeScannerConfiguration getConfiguration() {
        return this.configuration;
    }

    @NotNull
    public final Map<String, BarcodeMappingResult> getBarcodeMappingResults() {
        return this.barcodeMappingResults;
    }

    public final void setBarcodeMappingResults(@NotNull Map<String, BarcodeMappingResult> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.barcodeMappingResults = map;
    }

    @Override
    protected void extraConfiguration() {
        if (this.wrapperMapBarcodeItemCallback != null) {
            BarcodeUseCase barcodeUseCase = this.getConfiguration().getUseCase();
            if (barcodeUseCase instanceof SingleScanningMode) {
                this.initializeMapBarcodeItemCallback();
                BarcodeUseCase barcodeUseCase2 = this.getConfiguration().getUseCase();
                Intrinsics.checkNotNull((Object)barcodeUseCase2, (String)"null cannot be cast to non-null type io.scanbot.sdk.ui_v2.barcode.configuration.SingleScanningMode");
                ((SingleScanningMode)barcodeUseCase2).getBarcodeInfoMapping().setBarcodeItemMapper((BarcodeItemMapper)new SBWrapperRtuBarcodeScannerV2BarcodeItemMapper());
            } else if (barcodeUseCase instanceof MultipleScanningMode) {
                this.initializeMapBarcodeItemCallback();
                BarcodeUseCase barcodeUseCase3 = this.getConfiguration().getUseCase();
                Intrinsics.checkNotNull((Object)barcodeUseCase3, (String)"null cannot be cast to non-null type io.scanbot.sdk.ui_v2.barcode.configuration.MultipleScanningMode");
                ((MultipleScanningMode)barcodeUseCase3).getBarcodeInfoMapping().setBarcodeItemMapper((BarcodeItemMapper)new SBWrapperRtuBarcodeScannerV2BarcodeItemMapper());
            }
        }
    }

    @Override
    protected void handleResult(@NotNull BarcodeScannerActivity.Result activityResult) {
        Intrinsics.checkNotNullParameter((Object)activityResult, (String)"activityResult");
        this.barcodeMappingResults.clear();
        mapBarcodeItemCallback = null;
        if (activityResult.getResultOk()) {
            Unit unit;
            BarcodeScannerResult barcodeScannerResult = activityResult.getResult();
            if (barcodeScannerResult != null) {
                BarcodeScannerResult it = barcodeScannerResult;
                boolean bl = false;
                SBWrapperResultDelegate.Companion.sendSuccessOnMainThread$sdk_native_wrapper_release$default(SBWrapperResultDelegate.Companion, this.resultDelegate, it.toJson(), null, 4, null);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit == null) {
                SBWrapperRtuBarcodeScannerV2 $this$handleResult_u24lambda_u241 = this;
                boolean bl = false;
                SBWrapperResultDelegate.Companion.sendFailureOnMainThread$sdk_native_wrapper_release($this$handleResult_u24lambda_u241.resultDelegate, "Cannot parse Barcode Scanner result");
            }
        } else {
            SBWrapperResultDelegate.Companion.sendCanceledOnMainThread$sdk_native_wrapper_release(this.resultDelegate, "Result code: " + activityResult.getResultCode());
        }
    }

    private final void initializeMapBarcodeItemCallback() {
        LoggerProvider.getLogger().i(SBWrapper.INSTANCE.getLoggerTag$sdk_native_wrapper_release(), "BarcodeItemMapper callback is set");
        mapBarcodeItemCallback = (Function2)new Function2<BarcodeItem, BarcodeMappingResult, Unit>(this){
            final /* synthetic */ SBWrapperRtuBarcodeScannerV2 this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull BarcodeItem barcodeItem, @NotNull BarcodeMappingResult mappingResult) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)barcodeItem, (String)"barcodeItem");
                    Intrinsics.checkNotNullParameter((Object)mappingResult, (String)"mappingResult");
                    this.this$0.getBarcodeMappingResults().put(SBWrapperBarcodeItemExtensionKt.uuid(barcodeItem), mappingResult);
                    Function1 function1 = SBWrapperRtuBarcodeScannerV2.access$getWrapperMapBarcodeItemCallback$p(this.this$0);
                    if (function1 == null) break block0;
                    function1.invoke((Object)barcodeItem.toJson());
                }
            }
        };
    }

    public static final /* synthetic */ Function1 access$getWrapperMapBarcodeItemCallback$p(SBWrapperRtuBarcodeScannerV2 $this) {
        return $this.wrapperMapBarcodeItemCallback;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000RL\u0010\u0005\u001a4\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\r\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lio/scanbot/sdk_wrapper/barcode/ui/SBWrapperRtuBarcodeScannerV2$Companion;", "", "()V", "REQUEST_CODE", "", "mapBarcodeItemCallback", "Lkotlin/Function2;", "Lio/scanbot/sdk/ui_v2/barcode/configuration/BarcodeItem;", "Lkotlin/ParameterName;", "name", "barcodeItem", "Lio/scanbot/sdk/ui_v2/barcode/configuration/BarcodeMappingResult;", "mappingResult", "", "getMapBarcodeItemCallback", "()Lkotlin/jvm/functions/Function2;", "setMapBarcodeItemCallback", "(Lkotlin/jvm/functions/Function2;)V", "sdk-native-wrapper_release"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Function2<BarcodeItem, BarcodeMappingResult, Unit> getMapBarcodeItemCallback() {
            return mapBarcodeItemCallback;
        }

        public final void setMapBarcodeItemCallback(@Nullable Function2<? super BarcodeItem, ? super BarcodeMappingResult, Unit> function2) {
            mapBarcodeItemCallback = function2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

