/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.sdk_native_wrapper.converters;

import android.graphics.PointF;
import android.net.Uri;
import io.scanbot.imagefilters.ParametricFilter;
import io.scanbot.sdk.common.JsonKt;
import io.scanbot.sdk.core.contourdetector.DetectionStatus;
import io.scanbot.sdk.persistence.Page;
import io.scanbot.sdk.persistence.PageFileStorage;
import io.scanbot.sdk.process.ImageFilterType;
import io.scanbot.sdk.sdk_native_wrapper.SBNWOperations;
import io.scanbot.sdk.sdk_native_wrapper.converters.CommonExtensionsKt;
import io.scanbot.sdk.sdk_native_wrapper.converters.PageExtensionsKt;
import io.scanbot.sdk.sdk_native_wrapper.errors.SBNWCommonExceptions;
import io.scanbot.sdk.ui.view.camera.configuration.json.ImageFilterTypeExtensionsKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001:\u0001\u0014B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u0006J\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u00062\u0006\u0010\t\u001a\u00020\u0004J\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u00062\u0006\u0010\t\u001a\u00020\u0004J\u001a\u0010\u000b\u001a\u00020\f2\u0010\u0010\r\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u0006H\u0002J%\u0010\u000e\u001a\u0004\u0018\u0001H\u000f\"\u0004\b\u0000\u0010\u000f*\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0012\u00a2\u0006\u0002\u0010\u0013\u00a8\u0006\u0015"}, d2={"Lio/scanbot/sdk/sdk_native_wrapper/converters/PageUtils;", "", "()V", "createPageFromJson", "Lio/scanbot/sdk/persistence/Page;", "pageJson", "", "", "jsonFromExtractedPage", "nativePage", "jsonFromSnappedPage", "reactMapToNativePageSize", "Lio/scanbot/sdk/persistence/Page$Size;", "sizeLimitJson", "ifFalse", "T", "", "supplier", "Lkotlin/Function0;", "(ZLkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "Keys", "sdk-native-wrapper_release"})
@SourceDebugExtension(value={"SMAP\nPageExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PageExtensions.kt\nio/scanbot/sdk/sdk_native_wrapper/converters/PageUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,186:1\n1549#2:187\n1620#2,3:188\n1549#2:191\n1620#2,3:192\n1855#2,2:195\n*S KotlinDebug\n*F\n+ 1 PageExtensions.kt\nio/scanbot/sdk/sdk_native_wrapper/converters/PageUtils\n*L\n89#1:187\n89#1:188,3\n113#1:191\n113#1:192,3\n157#1:195,2\n*E\n"})
final class PageUtils {
    @NotNull
    public static final PageUtils INSTANCE = new PageUtils();

    private PageUtils() {
    }

    @Nullable
    public final <T> T ifFalse(boolean $this$ifFalse, @NotNull Function0<? extends T> supplier) {
        Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
        return (T)(!$this$ifFalse ? supplier.invoke() : null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, Object> jsonFromExtractedPage(@NotNull Page nativePage) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)nativePage, (String)"nativePage");
        Map page = MapsKt.toMutableMap(this.jsonFromSnappedPage(nativePage));
        Object v = page.get("originalImageFileUri");
        Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.String");
        String originalImageFileUri = (String)v;
        Object v2 = page.get("originalPreviewImageFileUri");
        Intrinsics.checkNotNull(v2, (String)"null cannot be cast to non-null type kotlin.String");
        String previewImageFileUri = (String)v2;
        page.put("filter", ImageFilterTypeExtensionsKt.toJson((ImageFilterType)nativePage.getFilter()).toString());
        Map map = page;
        String string = "parametricFilters";
        Iterable $this$map$iv = nativePage.getParametricFilters();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ParametricFilter parametricFilter = (ParametricFilter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(JsonKt.toMap((JSONObject)it.toJson()));
        }
        List list = (List)destination$iv$iv;
        map.put(string, list);
        this.ifFalse(page.containsKey("documentImageFileUri"), (Function0)new Function0<Unit>((Map<String, Object>)page, originalImageFileUri){
            final /* synthetic */ Map<String, Object> $page;
            final /* synthetic */ String $originalImageFileUri;
            {
                this.$page = $page;
                this.$originalImageFileUri = $originalImageFileUri;
                super(0);
            }

            public final void invoke() {
                this.$page.put("documentImageFileUri", this.$originalImageFileUri);
            }
        });
        this.ifFalse(page.containsKey("documentPreviewImageFileUri"), (Function0)new Function0<Unit>((Map<String, Object>)page, previewImageFileUri){
            final /* synthetic */ Map<String, Object> $page;
            final /* synthetic */ String $previewImageFileUri;
            {
                this.$page = $page;
                this.$previewImageFileUri = $previewImageFileUri;
                super(0);
            }

            public final void invoke() {
                this.$page.put("documentPreviewImageFileUri", this.$previewImageFileUri);
            }
        });
        return page;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, Object> jsonFromSnappedPage(@NotNull Page nativePage) {
        Map page;
        block3: {
            Object it;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)nativePage, (String)"nativePage");
            PageFileStorage storage = SBNWOperations.INSTANCE.getInternalSdk$sdk_native_wrapper_release().createPageFileStorage();
            page = new LinkedHashMap();
            String pageId = nativePage.getPageId();
            page.put("pageId", pageId);
            page.put("detectionResult", CommonExtensionsKt.toJson(nativePage.getDetectionStatus()));
            page.put("pageImageSource", PageExtensionsKt.access$toJson(nativePage.getPageImageSource()));
            page.put("polygon", CommonExtensionsKt.toJson(nativePage.getPolygon()));
            page.put("filter", ImageFilterTypeExtensionsKt.toJson((ImageFilterType)nativePage.getFilter()).toString());
            Map map = page;
            String string = "parametricFilters";
            Iterable $this$map$iv = nativePage.getParametricFilters();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                ParametricFilter parametricFilter = (ParametricFilter)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(JsonKt.toMap((JSONObject)it2.toJson()));
            }
            $this$map$iv = (List)destination$iv$iv;
            map.put(string, $this$map$iv);
            Uri originalImageFileUri = storage.getImageURI(pageId, PageFileStorage.PageFileType.ORIGINAL);
            page.put("originalImageFileUri", CommonExtensionsKt.withHash(originalImageFileUri));
            Uri originalPreviewImageFileUri = storage.getPreviewImageURI(pageId, PageFileStorage.PageFileType.ORIGINAL);
            page.put("originalPreviewImageFileUri", CommonExtensionsKt.withHash(originalPreviewImageFileUri));
            Uri documentImageUri = storage.getImageURI(pageId, PageFileStorage.PageFileType.DOCUMENT);
            String string2 = documentImageUri.getPath();
            if (string2 != null) {
                it = string2;
                boolean bl = false;
                if (new File((String)it).isFile()) {
                    page.put("documentImageFileUri", CommonExtensionsKt.withHash(documentImageUri));
                    page.put("documentPreviewImageFileUri", CommonExtensionsKt.withHash(storage.getPreviewImageURI(pageId, PageFileStorage.PageFileType.DOCUMENT)));
                }
            }
            Map map2 = PageExtensionsKt.access$toJson(nativePage.getDocumentImageSizeLimit());
            if (map2 == null) break block3;
            it = map2;
            boolean bl = false;
            page.put("documentImageSizeLimit", it);
        }
        return page;
    }

    @NotNull
    public final Page createPageFromJson(@NotNull Map<String, ? extends Object> pageJson) {
        List list;
        Object object;
        Intrinsics.checkNotNullParameter(pageJson, (String)"pageJson");
        Object object2 = pageJson.get("pageId");
        String string = object2 instanceof String ? (String)object2 : null;
        if (string == null) {
            throw new SBNWCommonExceptions.SBSDKInvalidJSON(null, 1, null);
        }
        String pageId = string;
        Iterator iterator = pageJson.get("polygon");
        List list2 = iterator instanceof List ? (List)((Object)iterator) : null;
        if (list2 == null) {
            throw new SBNWCommonExceptions.SBSDKInvalidJSON(null, 1, null);
        }
        List polygonJson = list2;
        List polygonPoints = new ArrayList();
        for (Object pointObj : polygonJson) {
            Intrinsics.checkNotNull(pointObj, (String)"null cannot be cast to non-null type kotlin.collections.Map<*, *>");
            Map pointMap = (Map)pointObj;
            object = pointMap.get("x");
            Number number = object instanceof Number ? (Number)((Number)object) : (Number)null;
            if (number == null) {
                throw new SBNWCommonExceptions.SBSDKInvalidJSON(null, 1, null);
            }
            float x = number.floatValue();
            Object v = pointMap.get("y");
            Number number2 = v instanceof Number ? (Number)((Number)v) : (Number)null;
            if (number2 == null) {
                throw new SBNWCommonExceptions.SBSDKInvalidJSON(null, 1, null);
            }
            float y = number2.floatValue();
            polygonPoints.add(new PointF(x, y));
        }
        Object object3 = pageJson.get("detectionResult");
        Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type kotlin.String");
        String jsDetectionResult = (String)object3;
        DetectionStatus detectionStatus = !Intrinsics.areEqual((Object)"", (Object)jsDetectionResult) ? DetectionStatus.valueOf((String)jsDetectionResult) : DetectionStatus.ERROR_NOTHING_DETECTED;
        Object x = pageJson.get("filter");
        ImageFilterType filter = CommonExtensionsKt.toSdkFilterType(x instanceof String ? (String)x : null);
        object = pageJson.get("parametricFilters");
        List list3 = object instanceof List ? (List)object : null;
        if (list3 != null) {
            List it = list3;
            boolean bl = false;
            List listOfFilters = new ArrayList();
            Iterable $this$forEach$iv = it;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map filter2 = (Map)element$iv;
                boolean bl2 = false;
                listOfFilters.add(ParametricFilter.Companion.invoke(filter2));
            }
            list = listOfFilters;
        } else {
            list = CollectionsKt.emptyList();
        }
        List parametricFilters = list;
        object = pageJson.get("documentImageSizeLimit");
        Page.Size documentImageSizeLimit = this.reactMapToNativePageSize(object instanceof Map ? (Map)object : null);
        return new Page(pageId, polygonPoints, detectionStatus, filter, parametricFilters, documentImageSizeLimit, null, 64, null);
    }

    private final Page.Size reactMapToNativePageSize(Map<?, ?> sizeLimitJson) {
        if (sizeLimitJson == null) {
            return new Page.Size(0, 0, 3, null);
        }
        Object obj = sizeLimitJson.get("width");
        Number number = obj instanceof Number ? (Number)((Number)obj) : (Number)null;
        if (number == null) {
            throw new SBNWCommonExceptions.SBSDKInvalidJSON(null, 1, null);
        }
        Number width = number;
        Object obj2 = sizeLimitJson.get("height");
        Number number2 = obj2 instanceof Number ? (Number)((Number)obj2) : (Number)null;
        if (number2 == null) {
            throw new SBNWCommonExceptions.SBSDKInvalidJSON(null, 1, null);
        }
        Number height = number2;
        return new Page.Size(width.intValue(), height.intValue());
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000f\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/scanbot/sdk/sdk_native_wrapper/converters/PageUtils$Keys;", "", "()V", "detectionResult", "", "docOriginalImageUri", "docPreviewImageUri", "documentImageSizeLimit", "filter", "originalImageUri", "originalPreviewImageFileUri", "pageId", "pageImageSource", "parametricFilters", "pointX", "pointY", "polygon", "sizeLimitHeight", "sizeLimitWidth", "sdk-native-wrapper_release"})
    public static final class Keys {
        @NotNull
        public static final Keys INSTANCE = new Keys();
        @NotNull
        public static final String pageId = "pageId";
        @NotNull
        public static final String detectionResult = "detectionResult";
        @NotNull
        public static final String pageImageSource = "pageImageSource";
        @NotNull
        public static final String polygon = "polygon";
        @NotNull
        public static final String filter = "filter";
        @NotNull
        public static final String parametricFilters = "parametricFilters";
        @NotNull
        public static final String documentImageSizeLimit = "documentImageSizeLimit";
        @NotNull
        public static final String originalImageUri = "originalImageFileUri";
        @NotNull
        public static final String originalPreviewImageFileUri = "originalPreviewImageFileUri";
        @NotNull
        public static final String docOriginalImageUri = "documentImageFileUri";
        @NotNull
        public static final String docPreviewImageUri = "documentPreviewImageFileUri";
        @NotNull
        public static final String sizeLimitWidth = "width";
        @NotNull
        public static final String sizeLimitHeight = "height";
        @NotNull
        public static final String pointX = "x";
        @NotNull
        public static final String pointY = "y";

        private Keys() {
        }
    }
}

