/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk_wrapper.extensions;

import android.content.ContentResolver;
import android.graphics.Bitmap;
import android.graphics.ImageDecoder;
import android.net.Uri;
import android.os.Build;
import android.provider.MediaStore;
import android.webkit.MimeTypeMap;
import io.scanbot.sdk_wrapper.exceptions.SBWrapperExceptions;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u001c\u0010\u0005\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u00a8\u0006\b"}, d2={"toBitmap", "Landroid/graphics/Bitmap;", "Landroid/net/Uri;", "contentResolver", "Landroid/content/ContentResolver;", "toFileInDirectory", "Ljava/io/File;", "directory", "sdk-native-wrapper_release"})
@SourceDebugExtension(value={"SMAP\nSBWrapperUriExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SBWrapperUriExtension.kt\nio/scanbot/sdk_wrapper/extensions/SBWrapperUriExtensionKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,51:1\n1#2:52\n*E\n"})
public final class SBWrapperUriExtensionKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final File toFileInDirectory(@NotNull Uri $this$toFileInDirectory, @NotNull File directory, @NotNull ContentResolver contentResolver) throws Exception {
        File file;
        Intrinsics.checkNotNullParameter((Object)$this$toFileInDirectory, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)contentResolver, (String)"contentResolver");
        InputStream inputStream = contentResolver.openInputStream($this$toFileInDirectory);
        if (inputStream != null) {
            Closeable closeable = inputStream;
            Throwable throwable = null;
            try {
                InputStream inputStream2 = (InputStream)closeable;
                boolean bl = false;
                String extension = MimeTypeMap.getSingleton().getExtensionFromMimeType(contentResolver.getType($this$toFileInDirectory));
                File outputFile = new File(directory, UUID.randomUUID().toString() + "." + extension);
                Closeable closeable2 = new FileOutputStream(outputFile);
                Throwable throwable2 = null;
                try {
                    FileOutputStream outputStream = (FileOutputStream)closeable2;
                    boolean bl2 = false;
                    byte[] buffer = new byte[4096];
                    int length = 0;
                    while (true) {
                        int n;
                        int it = n = inputStream2.read(buffer);
                        boolean bl3 = false;
                        length = it;
                        if (n <= 0) break;
                        outputStream.write(buffer, 0, length);
                    }
                    outputStream.flush();
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                file = outputFile;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        throw new SBWrapperExceptions.SBWrapperFileProcessError($this$toFileInDirectory.getPath());
        return file;
    }

    @NotNull
    public static final Bitmap toBitmap(@NotNull Uri $this$toBitmap, @NotNull ContentResolver contentResolver) throws Exception {
        Intrinsics.checkNotNullParameter((Object)$this$toBitmap, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)contentResolver, (String)"contentResolver");
        if (Build.VERSION.SDK_INT >= 28) {
            ImageDecoder.Source source = ImageDecoder.createSource((ContentResolver)contentResolver, (Uri)$this$toBitmap);
            Intrinsics.checkNotNullExpressionValue((Object)source, (String)"createSource(contentResolver, this)");
            ImageDecoder.Source source2 = source;
            Bitmap bitmap = ImageDecoder.decodeBitmap((ImageDecoder.Source)source2, SBWrapperUriExtensionKt::toBitmap$lambda$3);
            Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"decodeBitmap(source) { d\u2026Required = true\n        }");
            return bitmap;
        }
        Bitmap bitmap = MediaStore.Images.Media.getBitmap((ContentResolver)contentResolver, (Uri)$this$toBitmap);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"{\n        @Suppress(\"DEP\u2026tentResolver, this)\n    }");
        return bitmap;
    }

    private static final void toBitmap$lambda$3(ImageDecoder decoder, ImageDecoder.ImageInfo imageInfo, ImageDecoder.Source source) {
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        Intrinsics.checkNotNullParameter((Object)imageInfo, (String)"<anonymous parameter 1>");
        Intrinsics.checkNotNullParameter((Object)source, (String)"<anonymous parameter 2>");
        decoder.setMutableRequired(true);
    }
}

