/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk_wrapper.document.operations.setup;

import android.net.Uri;
import androidx.annotation.Keep;
import io.scanbot.sdk.configuration.json.JsonStorageImageFormat;
import io.scanbot.sdk_wrapper.exceptions.SBExceptions;
import io.scanbot.sdk_wrapper.extensions.SBJSONExtensionKt;
import io.scanbot.sdk_wrapper.extensions.SBStringExtensionKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0081\b\u0018\u0000 #2\u00020\u0001:\u0001#B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020\u0016H\u00d6\u0001J\u0006\u0010 \u001a\u00020!J\t\u0010\"\u001a\u00020!H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0013\u0010\u0019\u001a\u0004\u0018\u00010\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0018\u00a8\u0006$"}, d2={"Lio/scanbot/sdk_wrapper/document/operations/setup/SBDSdkConfiguration;", "", "configurationAsJson", "Lorg/json/JSONObject;", "(Lorg/json/JSONObject;)V", "getConfigurationAsJson", "()Lorg/json/JSONObject;", "loggingEnabled", "", "getLoggingEnabled", "()Z", "storageBaseDirectory", "Landroid/net/Uri;", "getStorageBaseDirectory", "()Landroid/net/Uri;", "setStorageBaseDirectory", "(Landroid/net/Uri;)V", "storageImageFormat", "Lio/scanbot/sdk/configuration/json/JsonStorageImageFormat;", "getStorageImageFormat", "()Lio/scanbot/sdk/configuration/json/JsonStorageImageFormat;", "storageImagePreviewSize", "", "getStorageImagePreviewSize", "()Ljava/lang/Integer;", "storageImageQuality", "getStorageImageQuality", "component1", "copy", "equals", "other", "hashCode", "toJsonString", "", "toString", "Companion", "document-sdk-wrapper_release"})
@Keep
@SourceDebugExtension(value={"SMAP\nSBDSdkConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SBDSdkConfiguration.kt\nio/scanbot/sdk_wrapper/document/operations/setup/SBDSdkConfiguration\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,65:1\n1#2:66\n*E\n"})
public final class SBDSdkConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String LOGGING_ENABLED_KEY = "loggingEnabled";
    @NotNull
    private static final String STORAGE_IMAGE_PREVIEW_SIZE_KEY = "storageImagePreviewSize";
    @NotNull
    private static final String STORAGE_IMAGE_QUALITY_KEY = "storageImageQuality";
    @NotNull
    private static final String STORAGE_IMAGE_FORMAT_KEY = "storageImageFormat";
    @NotNull
    private static final String STORAGE_BASE_DIRECTORY_KEY = "storageBaseDirectory";
    @NotNull
    private final JSONObject configurationAsJson;
    @Nullable
    private Uri storageBaseDirectory;

    public SBDSdkConfiguration(@NotNull JSONObject jSONObject) {
        Intrinsics.checkNotNullParameter((Object)jSONObject, (String)"configurationAsJson");
        this.configurationAsJson = jSONObject;
    }

    public static /* synthetic */ SBDSdkConfiguration copy$default(SBDSdkConfiguration sBDSdkConfiguration, JSONObject jSONObject, int n2, Object object) {
        if ((n2 & 1) != 0) {
            jSONObject = sBDSdkConfiguration.configurationAsJson;
        }
        return sBDSdkConfiguration.copy(jSONObject);
    }

    @NotNull
    public final JSONObject getConfigurationAsJson() {
        return this.configurationAsJson;
    }

    @Nullable
    public final Uri getStorageBaseDirectory() {
        return this.storageBaseDirectory;
    }

    public final void setStorageBaseDirectory(@Nullable Uri uri) {
        this.storageBaseDirectory = uri;
    }

    public final boolean getLoggingEnabled() {
        Boolean bl = SBJSONExtensionKt.getBooleanOrDefault(this.configurationAsJson, LOGGING_ENABLED_KEY, Boolean.FALSE);
        Intrinsics.checkNotNull((Object)bl);
        return bl;
    }

    @Nullable
    public final Integer getStorageImageQuality() {
        return SBJSONExtensionKt.getIntOrDefault$default(this.configurationAsJson, STORAGE_IMAGE_QUALITY_KEY, null, 2, null);
    }

    @Nullable
    public final Integer getStorageImagePreviewSize() {
        return SBJSONExtensionKt.getIntOrDefault$default(this.configurationAsJson, STORAGE_IMAGE_PREVIEW_SIZE_KEY, null, 2, null);
    }

    @Nullable
    public final JsonStorageImageFormat getStorageImageFormat() {
        String string = SBJSONExtensionKt.getStringOrDefault$default(((SBDSdkConfiguration)((Object)string)).configurationAsJson, STORAGE_IMAGE_FORMAT_KEY, null, 2, null);
        return string != null ? JsonStorageImageFormat.valueOf((String)string) : null;
    }

    @NotNull
    public final String toJsonString() {
        String string = SBJSONExtensionKt.getStringOrDefault$default(this.configurationAsJson, STORAGE_BASE_DIRECTORY_KEY, null, 2, null);
        if (string != null) {
            this.configurationAsJson.remove(STORAGE_BASE_DIRECTORY_KEY);
            string = SBStringExtensionKt.toValidUriOrNull(string);
            if (string != null) {
                this.storageBaseDirectory = string;
            } else {
                throw new SBExceptions.SBWrapperUriParsingError("storageBaseDirectory URI path not found");
            }
        }
        String string2 = this.configurationAsJson.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    @NotNull
    public final JSONObject component1() {
        return this.configurationAsJson;
    }

    @NotNull
    public final SBDSdkConfiguration copy(@NotNull JSONObject jSONObject) {
        Intrinsics.checkNotNullParameter((Object)jSONObject, (String)"configurationAsJson");
        return new SBDSdkConfiguration(jSONObject);
    }

    @NotNull
    public String toString() {
        return "SBDSdkConfiguration(configurationAsJson=" + this.configurationAsJson + ")";
    }

    public int hashCode() {
        return this.configurationAsJson.hashCode();
    }

    public boolean equals(@Nullable Object object) {
        if (sBDSdkConfiguration2 == object) {
            return true;
        }
        if (!(object instanceof SBDSdkConfiguration)) {
            return false;
        }
        SBDSdkConfiguration sBDSdkConfiguration = sBDSdkConfiguration2;
        SBDSdkConfiguration sBDSdkConfiguration2 = (SBDSdkConfiguration)object;
        return Intrinsics.areEqual((Object)sBDSdkConfiguration.configurationAsJson, (Object)sBDSdkConfiguration2.configurationAsJson);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/scanbot/sdk_wrapper/document/operations/setup/SBDSdkConfiguration$Companion;", "", "()V", "LOGGING_ENABLED_KEY", "", "STORAGE_BASE_DIRECTORY_KEY", "STORAGE_IMAGE_FORMAT_KEY", "STORAGE_IMAGE_PREVIEW_SIZE_KEY", "STORAGE_IMAGE_QUALITY_KEY", "document-sdk-wrapper_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

