/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.connectivity;

import android.content.Context;
import android.net.Uri;
import com.google.inject.Inject;
import net.doo.snap.util.ManifestConstantsProvider;

public class RemoteStorage {
    private final Uri tessDataFolder;
    private final Uri languageClassifierBlobPath;
    private final Uri documentClassifierBlobsPath;

    @Inject
    public RemoteStorage(Context context) {
        this.tessDataFolder = Uri.parse((String)ManifestConstantsProvider.getConstantValue((Context)context, (String)"ocr_blobs_path"));
        this.languageClassifierBlobPath = Uri.parse((String)ManifestConstantsProvider.getConstantValue((Context)context, (String)"language_classifier_blob_path"));
        this.documentClassifierBlobsPath = Uri.parse((String)ManifestConstantsProvider.getConstantValue((Context)context, (String)"document_classifier_blob_path"));
    }

    public Uri ocrBlobPath(String name) {
        return this.tessDataFolder.buildUpon().appendPath(name).build();
    }

    public Uri languageClassifierBlobPath() {
        return this.languageClassifierBlobPath.buildUpon().appendPath("languageClassifier2.bin").build();
    }

    public Uri documentClassifierBlobPath(String languageCode, String name) {
        return this.documentClassifierBlobsPath.buildUpon().appendPath(languageCode).appendPath(name).build();
    }
}

