/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.blob;

import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import net.doo.snap.connectivity.RemoteStorage;
import net.doo.snap.entity.Blob;
import net.doo.snap.entity.Language;
import net.doo.snap.intelligence.DocumentClassifier;
import net.doo.snap.persistence.BlobStoreStrategy;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;

public class BlobFactory {
    private static final String LANGUAGE_CLASSIFIER_BIN = "languageClassifier2.bin";
    private static final String NATALIE_BIN = "natalie.bin";
    private static final String OSD = "osd.traineddata";
    private static final String[] OCR_ARABIC = new String[]{"ara.cube.bigrams", "ara.cube.fold", "ara.cube.lm", "ara.cube.nn", "ara.cube.params", "ara.cube.size", "ara.cube.word-freq", "ara.traineddata", "eng.cube.params", "fra.cube.params", "hin.cube.params", "ita.cube.params", "rus.cube.params", "spa.cube.params"};
    private static final String PDF_FONT = "pdf.ttf";
    private final BlobStoreStrategy blobStoreStrategy;
    private final RemoteStorage remoteStorage;
    private final DocumentClassifier documentClassifier;

    @Inject
    public BlobFactory(BlobStoreStrategy blobStoreStrategy, RemoteStorage remoteStorage, DocumentClassifier documentClassifier) {
        this.blobStoreStrategy = blobStoreStrategy;
        this.remoteStorage = remoteStorage;
        this.documentClassifier = documentClassifier;
    }

    @NotNull
    public Collection<Blob> ocrLanguageBlobs(Language language) throws IOException {
        HashSet<Blob> blobs = new HashSet<Blob>();
        File ocrDirectory = this.blobStoreStrategy.getOCRDataDirectory();
        String binaryName = language.getIsoCode() + ".traineddata";
        Blob languageBlob = new Blob(new File(ocrDirectory, binaryName).getPath(), this.remoteStorage.ocrBlobPath(binaryName).toString());
        blobs.add(languageBlob);
        Blob osdBlob = new Blob(new File(ocrDirectory, OSD).getPath(), this.remoteStorage.ocrBlobPath(OSD).toString());
        blobs.add(osdBlob);
        Blob pdfBlob = new Blob(new File(ocrDirectory, PDF_FONT).getPath(), PDF_FONT);
        blobs.add(pdfBlob);
        blobs.addAll(this.ocrLanguageSpecificBlobs(language));
        return blobs;
    }

    private Collection<? extends Blob> ocrLanguageSpecificBlobs(Language language) throws IOException {
        if (language != Language.ARA) {
            return Collections.emptySet();
        }
        File ocrDirectory = this.blobStoreStrategy.getOCRDataDirectory();
        HashSet<Blob> blobs = new HashSet<Blob>();
        for (String binaryName : OCR_ARABIC) {
            blobs.add(new Blob(new File(ocrDirectory, binaryName).getPath(), this.remoteStorage.ocrBlobPath(binaryName).toString()));
        }
        return blobs;
    }

    @NotNull
    public Collection<Blob> languageDetectorBlobs() throws IOException {
        File binariesDirectory = this.blobStoreStrategy.getBinariesDirectory();
        String binaryName = LANGUAGE_CLASSIFIER_BIN;
        Blob blob = new Blob(new File(binariesDirectory, LANGUAGE_CLASSIFIER_BIN).getPath(), this.remoteStorage.languageClassifierBlobPath().toString());
        return Arrays.asList(blob);
    }

    @NotNull
    public Collection<Blob> documentClassifierBlobs(Language language) throws IOException {
        if (!this.documentClassifier.isLanguageSupported(language)) {
            return Collections.emptyList();
        }
        File natalieDirectory = this.blobStoreStrategy.getDocumentClassifierDirectory();
        String binaryName = NATALIE_BIN;
        Blob blob = new Blob(FileUtils.getFile((File)natalieDirectory, (String[])new String[]{language.getIsoCode(), NATALIE_BIN}).getPath(), this.remoteStorage.documentClassifierBlobPath(language.getIsoCode(), NATALIE_BIN).toString());
        return Arrays.asList(blob);
    }
}

