/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.intelligence;

import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.doo.datamining.language.LanguageClassifier;
import net.doo.datamining.language.LanguageLearningResult;
import net.doo.snap.blob.BlobFactory;
import net.doo.snap.entity.Blob;
import net.doo.snap.entity.Language;
import org.jetbrains.annotations.NotNull;

public class TextLanguageDetector {
    private static SoftReference<LanguageLearningResult> cachedLearningResult = new SoftReference<Object>(null);
    private final BlobFactory blobFactory;

    @Inject
    public TextLanguageDetector(BlobFactory blobFactory) {
        this.blobFactory = blobFactory;
    }

    @NotNull
    public List<Language> detectTextLanguages(@NotNull String detectedText) throws IOException {
        Collection blobs = this.blobFactory.languageDetectorBlobs();
        if (blobs.isEmpty()) {
            return Collections.emptyList();
        }
        Blob languageClassifierBinary = (Blob)blobs.iterator().next();
        LanguageLearningResult learningResult = this.getLanguageLearningResult(languageClassifierBinary);
        String languageCode = LanguageClassifier.classify((LanguageLearningResult)learningResult, (String)detectedText);
        Language language = Language.languageByIso((String)languageCode);
        if (language != null) {
            return Arrays.asList(language);
        }
        return Collections.emptyList();
    }

    private LanguageLearningResult getLanguageLearningResult(Blob languageClassifierBinary) throws IOException {
        LanguageLearningResult learningResult = cachedLearningResult.get();
        if (learningResult != null) {
            return learningResult;
        }
        learningResult = LanguageClassifier.readClassifiers((File)new File(languageClassifierBinary.getLocalPath()));
        cachedLearningResult = new SoftReference<LanguageLearningResult>(learningResult);
        return learningResult;
    }
}

