/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.intelligence;

import android.os.SystemClock;
import io.scanbot.sap.SapManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.doo.snap.blob.BlobManager;
import net.doo.snap.entity.Document;
import net.doo.snap.entity.Language;
import net.doo.snap.entity.OcrStatus;
import net.doo.snap.entity.Page;
import net.doo.snap.intelligence.LanguageProvider;
import net.doo.snap.intelligence.OcrPdfRenderer;
import net.doo.snap.intelligence.TextBasedLanguageDetector;
import net.doo.snap.intelligence.WrongLanguageException;
import net.doo.snap.persistence.DocumentStoreStrategy;
import net.doo.snap.process.OcrPerformer;
import net.doo.snap.process.OcrResult;
import net.doo.snap.process.PDFProcessor;
import net.doo.snap.process.compose.SimpleComposer;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;
import org.apache.commons.io.FileUtils;

public class SandwichingPdfOcrPerformer
implements OcrPerformer {
    private final Logger logger = LoggerProvider.getLogger();
    private final Document document;
    private final Page[] pages;
    private final SapManager sapManager;
    private final BlobManager blobManager;
    private final LanguageProvider languageProvider;
    private final TextBasedLanguageDetector textBasedLanguageDetector;
    private final PDFProcessor pdfProcessor;
    private final OcrPdfRenderer pdfRenderer;
    private final DocumentStoreStrategy documentStoreStrategy;
    private final SimpleComposer simpleComposer;
    private Language defaultLanguage;

    public SandwichingPdfOcrPerformer(SapManager sapManager, BlobManager blobManager, LanguageProvider languageProvider, TextBasedLanguageDetector textBasedLanguageDetector, PDFProcessor pdfProcessor, OcrPdfRenderer pdfRenderer, DocumentStoreStrategy documentStoreStrategy, SimpleComposer simpleComposer, Language defaultLanguage, Document document, List<Page> pages) {
        this.defaultLanguage = defaultLanguage;
        this.document = document;
        this.pages = (Page[])pages.toArray();
        this.sapManager = sapManager;
        this.blobManager = blobManager;
        this.languageProvider = languageProvider;
        this.textBasedLanguageDetector = textBasedLanguageDetector;
        this.pdfProcessor = pdfProcessor;
        this.pdfRenderer = pdfRenderer;
        this.documentStoreStrategy = documentStoreStrategy;
        this.simpleComposer = simpleComposer;
    }

    public OcrResult recognize() throws IOException {
        String detectedText = "";
        if (!this.isOcrFeatureActive().booleanValue()) {
            return new OcrResult(detectedText, null);
        }
        long ocrStartedMillis = SystemClock.elapsedRealtime();
        try {
            this.ensureNoActiveDownloads();
            Set availableLanguages = this.blobManager.getAllLanguagesWithAvailableOcrBlobs();
            if (this.defaultLanguage == null) {
                this.defaultLanguage = this.languageProvider.getMostCommonLanguage();
            }
            if (!availableLanguages.contains(this.defaultLanguage)) {
                this.logger.d("OCR", "Default language is not available - abort OCR: " + this.defaultLanguage);
                throw new IOException("Blob for default language is not available");
            }
            detectedText = this.createPDF(this.document, this.pages, this.defaultLanguage, availableLanguages);
            this.saveMetaData(this.document, availableLanguages, this.defaultLanguage, detectedText);
        }
        catch (IOException e) {
            this.logger.logException((Throwable)e);
            this.simpleComposer.composeDocument(this.document, this.pages);
        }
        this.trackDuration(ocrStartedMillis);
        return new OcrResult(detectedText, this.document);
    }

    private void saveMetaData(Document document, Set<Language> availableLanguages, Language defaultLanguage, String detectedText) throws IOException {
        document.setOcrStatus(OcrStatus.DONE);
        document.setOcrText(detectedText);
        this.detectDocumentLanguage(document, detectedText, availableLanguages, defaultLanguage);
        this.trackDocument(document);
    }

    private void trackDocument(Document document) {
        if (document.getLanguage() != null) {
            this.logger.d("OCR", "Document language assigned: " + document.getLanguage().getIsoCode());
        }
    }

    private void detectDocumentLanguage(Document document, String detectedText, Set<Language> availableLanguages, Language defaultLanguage) throws IOException {
        ArrayList<Language> languages = new ArrayList<Language>(this.textBasedLanguageDetector.detectTextBasedLanguages(detectedText));
        languages.retainAll(availableLanguages);
        languages.add(defaultLanguage);
        document.setLanguage((Language)languages.get(0));
    }

    private String createPDF(Document document, Page[] pages, Language defaultLanguage, Set<Language> availableLanguages) throws IOException {
        String detectedText = this.performOCR(document, pages, availableLanguages, defaultLanguage);
        this.pdfProcessor.processPDF(document, pages);
        return detectedText;
    }

    private String performOCR(Document document, Page[] pages, Set<Language> availableLanguages, Language defaultLanguage) throws IOException {
        String detectedText;
        this.logger.d("OCR", "Starting OCR with language: " + defaultLanguage);
        try {
            detectedText = this.ocrWithDefaultLanguage(document, pages, availableLanguages, defaultLanguage);
        }
        catch (WrongLanguageException e) {
            detectedText = this.cleanupAndRunWithNewLanguages(document, pages, e.getNewLanguages());
        }
        return detectedText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String cleanupAndRunWithNewLanguages(Document document, Page[] pages, Collection<Language> languages) throws IOException {
        File documentFile = this.documentStoreStrategy.getDocumentFile(document.getId(), document.getName());
        FileUtils.deleteQuietly((File)documentFile);
        OcrPdfRenderer.RenderIterator renderIterator = this.pdfRenderer.startRender(document, pages, languages);
        try {
            while (renderIterator.renderNextPage()) {
            }
            String string = renderIterator.getDetectedText();
            return string;
        }
        finally {
            renderIterator.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String ocrWithDefaultLanguage(Document document, Page[] pages, Set<Language> availableLanguages, Language defaultLanguage) throws IOException, WrongLanguageException {
        StringBuilder detectedText = new StringBuilder();
        OcrPdfRenderer.RenderIterator renderIterator = this.pdfRenderer.startRender(document, pages, Collections.singletonList(defaultLanguage));
        try {
            boolean languageDetected = false;
            while (renderIterator.renderNextPage()) {
                detectedText.append(renderIterator.getDetectedText());
                if (languageDetected) continue;
                languageDetected = this.isLanguageDetected(availableLanguages, defaultLanguage, renderIterator.getDetectedText());
            }
        }
        finally {
            renderIterator.recycle();
        }
        return detectedText.toString();
    }

    private boolean isLanguageDetected(Set<Language> availableLanguages, Language defaultLanguage, String detectedText) throws WrongLanguageException {
        if (detectedText.isEmpty()) {
            return false;
        }
        try {
            HashSet<Language> languages = new HashSet<Language>(this.textBasedLanguageDetector.detectTextBasedLanguages(detectedText));
            this.logger.d("OCR", "Detected languages: " + Arrays.toString(languages.toArray()));
            languages.retainAll(availableLanguages);
            if (languages.isEmpty()) {
                languages.addAll(availableLanguages);
                this.logger.d("OCR", "None of them are available");
            }
            if (languages.size() == 1 && languages.contains(defaultLanguage)) {
                this.logger.d("OCR", "Continue with current language");
                return true;
            }
            this.logger.d("OCR", "Languages are not match. Restart with languages: " + Arrays.toString(languages.toArray()));
            throw new WrongLanguageException(languages);
        }
        catch (IOException e) {
            this.logger.logException((Throwable)e);
            return true;
        }
    }

    private void ensureNoActiveDownloads() throws IOException {
        if (this.blobManager.hasActiveDownloads()) {
            throw new IOException("Downloading in progress");
        }
    }

    private Boolean isOcrFeatureActive() {
        return this.sapManager.isLicenseActive() && this.sapManager.isFeatureEnabled(16);
    }

    private void trackDuration(long ocrStartedMillis) {
        long ocrDuration = SystemClock.elapsedRealtime() - ocrStartedMillis;
        this.logger.d("OCR", "Ocr total: " + (float)ocrDuration / 1000.0f + " sec");
    }
}

