/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.intelligence;

import com.google.inject.Inject;
import io.scanbot.sap.SapManager;
import java.util.List;
import net.doo.snap.blob.BlobManager;
import net.doo.snap.entity.Document;
import net.doo.snap.entity.Language;
import net.doo.snap.entity.Page;
import net.doo.snap.intelligence.LanguageProvider;
import net.doo.snap.intelligence.OcrPdfRenderer;
import net.doo.snap.intelligence.SandwichingPdfOcrPerformer;
import net.doo.snap.intelligence.SimpleOcrPerformer;
import net.doo.snap.intelligence.TextBasedLanguageDetector;
import net.doo.snap.persistence.BlobStoreStrategy;
import net.doo.snap.persistence.DocumentStoreStrategy;
import net.doo.snap.persistence.PageStoreStrategy;
import net.doo.snap.process.OcrPerformer;
import net.doo.snap.process.PDFProcessor;
import net.doo.snap.process.TextRecognition;
import net.doo.snap.process.TextRecognizer;
import net.doo.snap.process.compose.SimpleComposer;

public class TextRecognizerFactory
implements TextRecognition {
    @Inject
    private SapManager sapManager;
    @Inject
    private BlobManager blobManager;
    @Inject
    private LanguageProvider languageProvider;
    @Inject
    private TextBasedLanguageDetector textBasedLanguageDetector;
    @Inject
    private PDFProcessor pdfProcessor;
    @Inject
    private OcrPdfRenderer pdfRenderer;
    @Inject
    private DocumentStoreStrategy documentStoreStrategy;
    @Inject
    private SimpleComposer simpleComposer;
    @Inject
    private BlobStoreStrategy blobStoreStrategy;
    @Inject
    private PageStoreStrategy pageStoreStrategy;

    public TextRecognizer withPDF(Language defaultLanguage, Document document, List<Page> pages) {
        return new TextRecognizer((OcrPerformer)new SandwichingPdfOcrPerformer(this.sapManager, this.blobManager, this.languageProvider, this.textBasedLanguageDetector, this.pdfProcessor, this.pdfRenderer, this.documentStoreStrategy, this.simpleComposer, defaultLanguage, document, pages));
    }

    public TextRecognizer withoutPDF(Language defaultLanguage, List<Page> pages) {
        return new TextRecognizer((OcrPerformer)new SimpleOcrPerformer(this.sapManager, this.blobManager, this.languageProvider, this.textBasedLanguageDetector, this.blobStoreStrategy, this.pageStoreStrategy, defaultLanguage, pages));
    }
}

