/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.intelligence;

import android.os.SystemClock;
import android.text.TextUtils;
import com.googlecode.tesseract.android.TessBaseAPI;
import io.scanbot.sap.SapManager;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.doo.snap.blob.BlobManager;
import net.doo.snap.entity.Language;
import net.doo.snap.entity.Page;
import net.doo.snap.intelligence.LanguageProvider;
import net.doo.snap.intelligence.TextBasedLanguageDetector;
import net.doo.snap.intelligence.WrongLanguageException;
import net.doo.snap.persistence.BlobStoreStrategy;
import net.doo.snap.persistence.PageStoreStrategy;
import net.doo.snap.process.OcrPerformer;
import net.doo.snap.process.OcrResult;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;

public class SimpleOcrPerformer
implements OcrPerformer {
    private final Logger logger = LoggerProvider.getLogger();
    private final Page[] pages;
    private final SapManager sapManager;
    private final BlobManager blobManager;
    private final LanguageProvider languageProvider;
    private final TextBasedLanguageDetector textBasedLanguageDetector;
    private final BlobStoreStrategy blobStoreStrategy;
    private final PageStoreStrategy pageStoreStrategy;
    private Language defaultLanguage;

    public SimpleOcrPerformer(SapManager sapManager, BlobManager blobManager, LanguageProvider languageProvider, TextBasedLanguageDetector textBasedLanguageDetector, BlobStoreStrategy blobStoreStrategy, PageStoreStrategy pageStoreStrategy, Language defaultLanguage, List<Page> pages) {
        this.defaultLanguage = defaultLanguage;
        this.pages = pages.toArray(new Page[pages.size()]);
        this.sapManager = sapManager;
        this.blobManager = blobManager;
        this.languageProvider = languageProvider;
        this.textBasedLanguageDetector = textBasedLanguageDetector;
        this.blobStoreStrategy = blobStoreStrategy;
        this.pageStoreStrategy = pageStoreStrategy;
    }

    public OcrResult recognize() {
        String detectedText = "";
        if (!this.isOcrFeatureActive().booleanValue()) {
            return new OcrResult(detectedText, null);
        }
        long ocrStartedMillis = SystemClock.elapsedRealtime();
        try {
            this.ensureNoActiveDownloads();
            Set availableLanguages = this.blobManager.getAllLanguagesWithAvailableOcrBlobs();
            if (this.defaultLanguage == null) {
                this.defaultLanguage = this.languageProvider.getMostCommonLanguage();
            }
            if (!availableLanguages.contains(this.defaultLanguage)) {
                this.logger.d("OCR", "Default language is not available - abort OCR: " + this.defaultLanguage);
                throw new IOException("Blob for default language is not available");
            }
            detectedText = this.performTessOCR(this.pages, availableLanguages, this.defaultLanguage);
        }
        catch (IOException e) {
            this.logger.logException((Throwable)e);
        }
        this.trackDuration(ocrStartedMillis);
        return new OcrResult(detectedText, null);
    }

    private Boolean isOcrFeatureActive() {
        return this.sapManager.isLicenseActive() && this.sapManager.isFeatureEnabled(16);
    }

    private void trackDuration(long ocrStartedMillis) {
        long ocrDuration = SystemClock.elapsedRealtime() - ocrStartedMillis;
        this.logger.d("OCR", "Ocr total: " + (float)ocrDuration / 1000.0f + " sec");
    }

    private String performTessOCR(Page[] pages, Set<Language> availableLanguages, Language defaultLanguage) throws IOException {
        String detectedText;
        this.logger.d("OCR", "Starting OCR with language: " + defaultLanguage);
        try {
            detectedText = this.ocrWithDefaultLanguage(pages, availableLanguages, defaultLanguage);
        }
        catch (WrongLanguageException e) {
            detectedText = this.cleanupAndRunWithNewLanguages(pages, e.getNewLanguages());
        }
        return detectedText;
    }

    private String ocrWithDefaultLanguage(Page[] pages, Set<Language> availableLanguages, Language defaultLanguage) throws IOException, WrongLanguageException {
        StringBuilder detectedText = new StringBuilder();
        boolean languageDetected = false;
        TessBaseAPI tessBaseAPI = this.initTessApi(Language.languageCodes(Collections.singletonList(defaultLanguage)));
        for (Page page : pages) {
            File pageFile = this.pageToFile(page);
            if (!pageFile.exists()) continue;
            tessBaseAPI.setImage(pageFile);
            detectedText.append(tessBaseAPI.getUTF8Text());
            if (languageDetected) continue;
            languageDetected = this.isLanguageDetected(availableLanguages, defaultLanguage, detectedText);
        }
        return detectedText.toString();
    }

    private File pageToFile(Page page) throws IOException {
        return this.pageStoreStrategy.getImageFile(page.getId(), Page.ImageType.OPTIMIZED);
    }

    private String cleanupAndRunWithNewLanguages(Page[] pages, Collection<Language> languages) throws IOException {
        StringBuilder detectedText = new StringBuilder();
        TessBaseAPI tessBaseAPI = this.initTessApi(Language.languageCodes(languages));
        for (Page page : pages) {
            File pageFile = this.pageStoreStrategy.getImageFile(page.getId(), Page.ImageType.OPTIMIZED);
            tessBaseAPI.setImage(pageFile);
            detectedText.append(tessBaseAPI.getUTF8Text());
        }
        return detectedText.toString();
    }

    private TessBaseAPI initTessApi(String ... languageCodes) throws IOException {
        TessBaseAPI tessBaseAPI = new TessBaseAPI();
        tessBaseAPI.init(this.blobStoreStrategy.getOCRDataDirectory().getParent() + File.separator, TextUtils.join((CharSequence)"+", (Object[])languageCodes));
        tessBaseAPI.setPageSegMode(1);
        return tessBaseAPI;
    }

    private boolean isLanguageDetected(Set<Language> availableLanguages, Language defaultLanguage, StringBuilder detectedText) throws WrongLanguageException {
        try {
            HashSet<Language> languages = new HashSet<Language>(this.textBasedLanguageDetector.detectTextBasedLanguages(detectedText.toString()));
            this.logger.d("OCR", "Detected languages: " + Arrays.toString(languages.toArray()));
            languages.retainAll(availableLanguages);
            if (languages.isEmpty()) {
                languages.addAll(availableLanguages);
                this.logger.d("OCR", "None of them are available");
            }
            if (languages.size() == 1 && languages.contains(defaultLanguage)) {
                this.logger.d("OCR", "Continue with current language");
                return true;
            }
            this.logger.d("OCR", "Languages are not match. Restart with languages: " + Arrays.toString(languages.toArray()));
            throw new WrongLanguageException(languages);
        }
        catch (IOException e) {
            this.logger.logException((Throwable)e);
            return true;
        }
    }

    private void ensureNoActiveDownloads() throws IOException {
        if (this.blobManager.hasActiveDownloads()) {
            throw new IOException("Downloading in progress");
        }
    }
}

