/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.smartname;

import android.app.Activity;
import android.content.Context;
import android.content.IntentSender;
import android.location.Address;
import android.location.Criteria;
import android.location.Geocoder;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationServices;
import com.google.inject.Inject;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import net.doo.snap.packageFull.R;
import net.doo.snap.smartname.TermType;
import net.doo.snap.util.log.DebugLog;
import roboguice.activity.event.OnStopEvent;
import roboguice.context.event.OnStartEvent;
import roboguice.event.Observes;

public class SmartNameValuesProvider
implements GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener {
    private static final int CONNECTION_FAILURE_RESOLUTION_REQUEST = 9000;
    private static final int LOCATION_UPDATE_FASTEST_INTERVAL_MILLIS = 1000;
    private static final int LOCATION_UPDATE_INTERVAL_MILLIS = 60000;
    private static final int MAX_RESULTS_COUNT = 1;
    private final GoogleApiClient googleApiClient;
    private Activity activity;
    private String cityName;
    private Location location;
    private LocationManager locationManager;
    private com.google.android.gms.location.LocationListener locationListener = new com.google.android.gms.location.LocationListener(){

        public void onLocationChanged(Location location) {
            SmartNameValuesProvider.this.location = location;
            SmartNameValuesProvider.this.updateCurrentCityName();
            SmartNameValuesProvider.this.disconnectPlayServices();
        }
    };
    private LocationListener androidLocationListener = new LocationListener(){

        public void onLocationChanged(Location location) {
            SmartNameValuesProvider.this.location = location;
            SmartNameValuesProvider.this.updateCurrentCityName();
        }

        public void onStatusChanged(String provider, int status, Bundle extras) {
        }

        public void onProviderEnabled(String provider) {
        }

        public void onProviderDisabled(String provider) {
        }
    };

    @Inject
    public SmartNameValuesProvider(Activity activity) {
        this.activity = activity;
        this.cityName = activity.getString(R.string.default_city_name);
        if (GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)activity) != 0) {
            this.locationManager = (LocationManager)activity.getSystemService("location");
            Criteria criteria = new Criteria();
            criteria.setAccuracy(1);
            String provider = this.locationManager.getBestProvider(criteria, false);
            if (provider != null) {
                this.location = this.locationManager.getLastKnownLocation(provider);
            }
            if (this.location == null) {
                provider = this.locationManager.getBestProvider(criteria, true);
                if (provider != null) {
                    this.locationManager.requestSingleUpdate(provider, this.androidLocationListener, null);
                }
            } else {
                this.updateCurrentCityName();
            }
        }
        this.googleApiClient = new GoogleApiClient.Builder((Context)activity).addApi(LocationServices.API).addConnectionCallbacks((GoogleApiClient.ConnectionCallbacks)this).addOnConnectionFailedListener((GoogleApiClient.OnConnectionFailedListener)this).build();
    }

    public void onStart(@Observes OnStartEvent event) {
        this.googleApiClient.connect();
    }

    public void onStop(@Observes OnStopEvent event) {
        if (this.locationManager != null) {
            this.locationManager.removeUpdates(this.androidLocationListener);
        }
        this.disconnectPlayServices();
    }

    private void disconnectPlayServices() {
        this.googleApiClient.disconnect();
    }

    public String getTermValue(TermType termType) {
        switch (termType) {
            case CITY: {
                return TextUtils.isEmpty((CharSequence)this.cityName) ? this.activity.getString(R.string.default_city_name) : this.cityName;
            }
            case YEAR: {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
                return sdf.format(new Date());
            }
            case YEAR_SHORT: {
                SimpleDateFormat sdf = new SimpleDateFormat("yy");
                return sdf.format(new Date());
            }
            case MONTH: {
                SimpleDateFormat sdf = new SimpleDateFormat("MM");
                return sdf.format(new Date());
            }
            case DAY: {
                SimpleDateFormat sdf = new SimpleDateFormat("dd");
                return sdf.format(new Date());
            }
            case HOURS: {
                SimpleDateFormat sdf = new SimpleDateFormat("HH");
                return sdf.format(new Date());
            }
            case MINUTES: {
                SimpleDateFormat sdf = new SimpleDateFormat("mm");
                return sdf.format(new Date());
            }
            case SECONDS: {
                SimpleDateFormat sdf = new SimpleDateFormat("ss");
                return sdf.format(new Date());
            }
            case DEVICE_MODEL: {
                return TextUtils.isEmpty((CharSequence)Build.MODEL) ? "" : Build.MODEL;
            }
        }
        return "";
    }

    private void updateCurrentCityName() {
        new AsyncTask<Void, Void, String>(){

            protected String doInBackground(Void ... params) {
                String cityName = SmartNameValuesProvider.this.activity.getString(R.string.default_city_name);
                if (SmartNameValuesProvider.this.location == null) {
                    return cityName;
                }
                Geocoder gcd = new Geocoder((Context)SmartNameValuesProvider.this.activity, Locale.getDefault());
                try {
                    List addresses = gcd.getFromLocation(SmartNameValuesProvider.this.location.getLatitude(), SmartNameValuesProvider.this.location.getLongitude(), 1);
                    if (addresses.size() > 0) {
                        cityName = ((Address)addresses.get(0)).getLocality();
                    }
                }
                catch (IOException e) {
                    DebugLog.logException((Throwable)e);
                }
                return cityName;
            }

            protected void onPostExecute(String result) {
                SmartNameValuesProvider.this.cityName = result;
            }
        }.executeOnExecutor(AsyncTask.SERIAL_EXECUTOR, (Object[])new Void[0]);
    }

    public void onConnected(Bundle bundle) {
        DebugLog.d((String)"GooglePlay service connected");
        this.location = LocationServices.FusedLocationApi.getLastLocation(this.googleApiClient);
        this.updateCurrentCityName();
        this.requestLocationUpdates();
    }

    public void onConnectionSuspended(int i) {
        DebugLog.d((String)"GooglePlay service disconnected");
    }

    private void requestLocationUpdates() {
        LocationRequest request = LocationRequest.create();
        request.setPriority(102);
        request.setFastestInterval(1000L);
        request.setInterval(60000L);
        LocationServices.FusedLocationApi.requestLocationUpdates(this.googleApiClient, request, this.locationListener);
    }

    public void onConnectionFailed(ConnectionResult connectionResult) {
        if (connectionResult.hasResolution()) {
            try {
                connectionResult.startResolutionForResult(this.activity, 9000);
            }
            catch (IntentSender.SendIntentException e) {
                DebugLog.logException((Throwable)e);
            }
        } else {
            DebugLog.e((String)("GooglePlay service connection failed: " + connectionResult.getErrorCode()));
        }
    }
}

