/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.ui.upload;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Parcelable;
import android.widget.TextView;
import com.evernote.client.android.EvernoteSession;
import com.evernote.edam.error.EDAMSystemException;
import com.evernote.edam.error.EDAMUserException;
import com.evernote.thrift.TException;
import com.google.inject.Inject;
import net.doo.snap.UploadConstants;
import net.doo.snap.packageFull.R;
import net.doo.snap.ui.CustomThemeActivity;
import net.doo.snap.upload.CloudStorage;
import net.doo.snap.upload.auth.ConnectionResult;
import net.doo.snap.util.ManifestConstantsProvider;
import net.doo.snap.util.NavigationUtils;
import net.doo.snap.util.log.DebugLog;

public class EvernoteActivity
extends CustomThemeActivity {
    public static final String WAITING_FOR_RESULT = "WAITING_FOR_RESULT";
    private static final String ACCOUNT_NAME = "ACCOUNT_NAME";
    private static final int CHOOSER_REQUEST_CODE = 1;
    @Inject
    private SharedPreferences preferences;
    private String accountName;
    private EvernoteSession evernoteSession;
    private boolean waitingForResult;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_connect_storage);
        ((TextView)this.findViewById(R.id.connect_description)).setText((CharSequence)this.getString(R.string.connect_source_description, new Object[]{this.getString(CloudStorage.EVERNOTE.getNameResource())}));
        if (savedInstanceState != null) {
            this.accountName = savedInstanceState.getString(ACCOUNT_NAME);
            this.waitingForResult = savedInstanceState.getBoolean(WAITING_FOR_RESULT);
        }
    }

    protected void onStart() {
        super.onStart();
        if (this.accountName == null && !this.waitingForResult) {
            this.evernoteSession = EvernoteSession.getInstance((Context)this, (String)ManifestConstantsProvider.getConstantValue((Context)this, (String)"evernote_consumer_key"), (String)ManifestConstantsProvider.getConstantValue((Context)this, (String)"evernote_consumer_secret"), (EvernoteSession.EvernoteService)UploadConstants.EVERNOTE_HOST, (boolean)true);
            this.evernoteSession.authenticate((Context)this);
            this.waitingForResult = true;
        }
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putString(ACCOUNT_NAME, this.accountName);
        outState.putBoolean(WAITING_FOR_RESULT, this.waitingForResult);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 14390) {
            if (resultCode == -1) {
                this.finishAuthorization();
            } else {
                this.deliverConnectionResult(new ConnectionResult(false, CloudStorage.EVERNOTE, null));
            }
        } else if (requestCode == 1) {
            this.deliverConnectionResult(new ConnectionResult(true, CloudStorage.EVERNOTE, this.accountName));
        }
    }

    private void deliverConnectionResult(ConnectionResult result) {
        Intent intent = new Intent();
        intent.putExtra("CONNECTION_EXTRA", (Parcelable)result);
        NavigationUtils.deliverResultAndFinish((Activity)this, (int)-1, (Intent)intent);
    }

    private void finishAuthorization() {
        new AsyncTask<Void, Void, Void>(){

            protected Void doInBackground(Void ... params) {
                try {
                    if (EvernoteActivity.this.evernoteSession == null || !EvernoteActivity.this.evernoteSession.isLoggedIn()) {
                        EvernoteActivity.this.deliverConnectionResult(new ConnectionResult(false, CloudStorage.EVERNOTE, null));
                        return null;
                    }
                    EvernoteActivity.this.accountName = EvernoteActivity.this.evernoteSession.getClientFactory().createUserStoreClient().getClient().getUser(EvernoteActivity.this.evernoteSession.getAuthToken()).getUsername();
                    EvernoteActivity.this.waitingForResult = false;
                    EvernoteActivity.this.preferences.edit().remove(CloudStorage.EVERNOTE.getDefaultFolderKey()).apply();
                    EvernoteActivity.this.startActivityForResult(new Intent((Context)EvernoteActivity.this, CloudStorage.getChooserActivity(CloudStorage.EVERNOTE)), 1);
                }
                catch (EDAMSystemException | EDAMUserException | TException e) {
                    DebugLog.logException((Throwable)e);
                    EvernoteActivity.this.deliverConnectionResult(new ConnectionResult(false, CloudStorage.EVERNOTE, null));
                }
                return null;
            }
        }.executeOnExecutor(AsyncTask.SERIAL_EXECUTOR, (Object[])new Void[0]);
    }
}

