/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.ui.upload;

import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.doo.snap.packageFull.R;
import net.doo.snap.ui.upload.ChooserActivity;
import net.doo.snap.upload.CloudStorage;
import net.doo.snap.upload.cloud.slack.SlackApi;
import net.doo.snap.upload.cloud.slack.model.Channel;
import net.doo.snap.upload.cloud.slack.model.ChannelResponse;
import net.doo.snap.upload.cloud.slack.model.ChannelsListResponse;
import net.doo.snap.upload.cloud.slack.model.Group;
import net.doo.snap.upload.cloud.slack.model.GroupsListResponse;
import net.doo.snap.upload.cloud.slack.model.Im;
import net.doo.snap.upload.cloud.slack.model.ImListResponse;
import net.doo.snap.upload.cloud.slack.model.User;
import net.doo.snap.upload.cloud.slack.model.UsersListResponse;
import net.doo.snap.util.log.DebugLog;
import net.doo.snap.util.thread.ExecutionUtils;

public class SlackChooserActivity
extends ChooserActivity {
    private static final String SECTION_ROOT = "root";
    private static final String SECTION_CHANNELS = "channels";
    private static final String SECTION_IM = "im";
    private static final String SECTION_GROUPS = "groups";
    @Inject
    private SlackApi slackApi;

    @Override
    protected void init() {
        this.chooserStorage = CloudStorage.SLACK;
        Uri root = new Uri.Builder().appendQueryParameter("folder_name", SECTION_ROOT).appendQueryParameter("id", SECTION_ROOT).build();
        this.foldersHierarchy.add(root);
    }

    @Override
    protected void createFolder(String name) {
        try {
            ChannelResponse channelResponse = this.slackApi.createChannel(name);
            if (channelResponse.isOk()) {
                this.slackApi.joinChannel(name);
            }
        }
        catch (IOException e) {
            DebugLog.logException((Throwable)e);
            ExecutionUtils.showToast((Context)this, (int)R.string.unable_create_folder_error);
        }
    }

    @Override
    protected List<Uri> loadFolders() {
        Uri last = (Uri)this.foldersHierarchy.getLast();
        String lastId = last.getQueryParameter("id");
        if (SECTION_ROOT.equals(lastId)) {
            this.setCreateFolderViewVisible(false);
            this.adapter.showCheckerView(false);
            return this.loadTopLevel();
        }
        this.adapter.showCheckerView(true);
        if (SECTION_CHANNELS.equals(lastId)) {
            this.setCreateFolderViewVisible(true);
            return this.getChannelsUri();
        }
        if (SECTION_IM.equals(lastId)) {
            this.setCreateFolderViewVisible(false);
            return this.getIMChannelsUris();
        }
        if (SECTION_GROUPS.equals(lastId)) {
            this.setCreateFolderViewVisible(false);
            return this.getGroupsUris();
        }
        ExecutionUtils.showToast((Context)this, (int)R.string.unable_open_folder_error);
        return Collections.emptyList();
    }

    private List<Uri> loadTopLevel() {
        ArrayList<Uri> folderUris = new ArrayList<Uri>();
        Uri uri = new Uri.Builder().appendQueryParameter("folder_name", this.getString(R.string.slack_section_channels)).appendQueryParameter("id", SECTION_CHANNELS).build();
        folderUris.add(uri);
        uri = new Uri.Builder().appendQueryParameter("folder_name", this.getString(R.string.slack_section_im)).appendQueryParameter("id", SECTION_IM).build();
        folderUris.add(uri);
        uri = new Uri.Builder().appendQueryParameter("folder_name", this.getString(R.string.slack_section_groups)).appendQueryParameter("id", SECTION_GROUPS).build();
        folderUris.add(uri);
        return folderUris;
    }

    private List<Uri> getChannelsUri() {
        List<Channel> channels = null;
        try {
            ChannelsListResponse channelsListResponse = this.slackApi.getChannels();
            if (channelsListResponse.isOk()) {
                channels = channelsListResponse.getChannels();
            }
        }
        catch (IOException e) {
            DebugLog.logException((Throwable)e);
        }
        if (channels == null) {
            ExecutionUtils.showToast((Context)this, (int)R.string.unable_open_folder_error);
            return Collections.emptyList();
        }
        ArrayList<Uri> folderUris = new ArrayList<Uri>();
        for (Channel channel : channels) {
            Uri uri = new Uri.Builder().appendQueryParameter("folder_name", channel.getName()).appendQueryParameter("id", channel.getId()).build();
            folderUris.add(uri);
        }
        return folderUris;
    }

    private List<Uri> getIMChannelsUris() {
        HashMap<String, User> users = new HashMap<String, User>();
        try {
            UsersListResponse usersListResponse = this.slackApi.getUsers();
            if (usersListResponse.isOk()) {
                List<User> usersList = usersListResponse.getMembers();
                for (User user : usersList) {
                    if (user == null || TextUtils.isEmpty((CharSequence)user.getName())) continue;
                    users.put(user.getId(), user);
                }
            }
        }
        catch (IOException e) {
            DebugLog.logException((Throwable)e);
        }
        List<Im> imChannels = null;
        try {
            ImListResponse imListResponse = this.slackApi.getImChannels();
            if (imListResponse.isOk()) {
                imChannels = imListResponse.getIms();
            }
        }
        catch (IOException e) {
            DebugLog.logException((Throwable)e);
        }
        if (imChannels != null && !users.isEmpty()) {
            ArrayList<Uri> folderUris = new ArrayList<Uri>();
            for (Im imChannel : imChannels) {
                if (!users.containsKey(imChannel.getUser())) continue;
                Uri uri = new Uri.Builder().appendQueryParameter("folder_name", ((User)users.get(imChannel.getUser())).getName()).appendQueryParameter("id", imChannel.getId()).build();
                folderUris.add(uri);
            }
            return folderUris;
        }
        ExecutionUtils.showToast((Context)this, (int)R.string.unable_open_folder_error);
        return Collections.emptyList();
    }

    private List<Uri> getGroupsUris() {
        List<Group> groups = null;
        try {
            GroupsListResponse groupsListResponse = this.slackApi.getGroups();
            if (groupsListResponse.isOk()) {
                groups = groupsListResponse.getGroups();
            }
        }
        catch (IOException e) {
            DebugLog.logException((Throwable)e);
        }
        if (groups == null) {
            ExecutionUtils.showToast((Context)this, (int)R.string.unable_open_folder_error);
            return Collections.emptyList();
        }
        ArrayList<Uri> folderUris = new ArrayList<Uri>();
        for (Group group : groups) {
            Uri uri = new Uri.Builder().appendQueryParameter("folder_name", group.getName()).appendQueryParameter("id", group.getId()).build();
            folderUris.add(uri);
        }
        return folderUris;
    }
}

