/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.upload.cloud;

import android.content.Context;
import android.content.SharedPreferences;
import com.google.inject.Inject;
import com.microsoft.live.LiveAuthClient;
import com.microsoft.live.LiveAuthException;
import com.microsoft.live.LiveAuthListener;
import com.microsoft.live.LiveConnectClient;
import com.microsoft.live.LiveConnectSession;
import com.microsoft.live.LiveOperation;
import com.microsoft.live.LiveOperationException;
import com.microsoft.live.LiveStatus;
import com.microsoft.live.OverwriteOption;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import net.doo.snap.ui.upload.UploadInfo;
import net.doo.snap.upload.CloudStorage;
import net.doo.snap.upload.cloud.CloudUploader;
import net.doo.snap.upload.cloud.OnFileUploadListener;
import net.doo.snap.util.ManifestConstantsProvider;
import net.doo.snap.util.log.DebugLog;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class OneDriveUploader
implements CloudUploader {
    private static final String HOME_FOLDER = "me/skydrive";
    private static final String FOLDERS_FILTER = "/files?filter=folders";
    private static final String FILE_ID_KEY = "id";
    private static final String DATA_KEY = "data";
    private static final String NAME_KEY = "name";
    private static final String DESCRIPTION_KEY = "description";
    private static final String FOLDER_DESCRIPTION = "Scanbot folder";
    @Inject
    private Context context;
    @Inject
    private SharedPreferences preferences;
    private CountDownLatch countDownLatch;
    private LiveAuthClient auth;
    private LiveConnectClient client;
    private LiveConnectSession session;

    @Inject
    OneDriveUploader() {
    }

    @Override
    public void upload(UploadInfo info, OnFileUploadListener listener) throws IOException {
        this.countDownLatch = new CountDownLatch(1);
        this.initOneDriveAPI();
        try {
            this.countDownLatch.await();
        }
        catch (InterruptedException e) {
            DebugLog.logException((Throwable)e);
        }
        if (this.session != null && !this.session.isExpired()) {
            this.client = new LiveConnectClient(this.session);
            this.findFolderAndUploadFile(info, listener);
        } else {
            listener.onUploadAuthorizationFailed(info.getId(), CloudStorage.ONE_DRIVE);
        }
    }

    private void findFolderAndUploadFile(UploadInfo info, OnFileUploadListener listener) {
        String id2 = info.getId();
        try {
            if (!this.preferences.contains(CloudStorage.ONE_DRIVE.getDefaultFolderKey())) {
                LiveOperation operation = this.client.get("me/skydrive/files?filter=folders");
                if (operation.getResult().has(DATA_KEY)) {
                    JSONArray folders = operation.getResult().getJSONArray(DATA_KEY);
                    for (int index = 0; index < folders.length(); ++index) {
                        if (!folders.getJSONObject(index).getString(NAME_KEY).equals("Scanbot")) continue;
                        this.uploadFile(folders.getJSONObject(index).getString(FILE_ID_KEY), info, listener);
                        return;
                    }
                }
                this.createFolder(info, listener);
            } else {
                this.uploadFile(CloudStorage.ONE_DRIVE.getDefaultFolder(this.preferences).getQueryParameter(FILE_ID_KEY), info, listener);
            }
        }
        catch (LiveOperationException e) {
            DebugLog.logException((Throwable)e);
            listener.onUploadFailed(id2, CloudStorage.ONE_DRIVE);
        }
        catch (JSONException e) {
            DebugLog.logException((Throwable)e);
            listener.onUploadFailed(id2, CloudStorage.ONE_DRIVE);
        }
    }

    private void createFolder(UploadInfo info, OnFileUploadListener listener) throws JSONException, LiveOperationException {
        JSONObject body = new JSONObject();
        body.put(NAME_KEY, (Object)"Scanbot");
        body.put(DESCRIPTION_KEY, (Object)FOLDER_DESCRIPTION);
        LiveOperation operation = this.client.post(HOME_FOLDER, body);
        if (operation.getResult().has(FILE_ID_KEY)) {
            this.uploadFile(operation.getResult().getString(FILE_ID_KEY), info, listener);
        } else {
            listener.onUploadFailed(info.getId(), CloudStorage.ONE_DRIVE);
        }
    }

    private void uploadFile(String folderId, UploadInfo info, OnFileUploadListener listener) throws LiveOperationException {
        File file = info.getFile();
        String id2 = info.getId();
        LiveOperation operation = this.client.upload(folderId, file.getName(), file, OverwriteOption.Overwrite);
        if (operation.getResult().has(FILE_ID_KEY)) {
            try {
                listener.onUploadFinished(id2, CloudStorage.ONE_DRIVE, operation.getResult().getString(FILE_ID_KEY));
            }
            catch (JSONException e) {
                DebugLog.logException((Throwable)e);
            }
        } else {
            listener.onUploadFailed(id2, CloudStorage.ONE_DRIVE);
        }
    }

    private void initOneDriveAPI() {
        this.auth = new LiveAuthClient(this.context, ManifestConstantsProvider.getConstantValue((Context)this.context, (String)"onedrive_client_id"));
        this.auth.initialize(new LiveAuthListener(){

            public void onAuthComplete(LiveStatus status, LiveConnectSession session, Object userState) {
                OneDriveUploader.this.session = session;
                OneDriveUploader.this.countDownLatch.countDown();
            }

            public void onAuthError(LiveAuthException exception, Object userState) {
                OneDriveUploader.this.countDownLatch.countDown();
            }
        });
    }
}

