/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.upload.cloud.slack;

import android.app.Activity;
import android.app.LoaderManager;
import android.content.Context;
import android.content.Intent;
import android.content.Loader;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.google.inject.Inject;
import java.io.IOException;
import net.doo.snap.upload.cloud.slack.SlackApi;
import net.doo.snap.util.ManifestConstantsProvider;
import net.doo.snap.util.NavigationUtils;
import net.doo.snap.util.loading.SingleThreadLoader;
import net.doo.snap.util.log.DebugLog;
import roboguice.activity.RoboFragmentActivity;

public class SlackAuthActivity
extends RoboFragmentActivity
implements LoaderManager.LoaderCallbacks<Boolean> {
    private static final String SLACK_AUTH_URL = "https://slack.com/oauth/authorize";
    private static final String SCOPES = "read,post";
    private static final String CLIENT_ID_KEY = "client_id";
    private static final String SCOPE_KEY = "scope";
    private static final String REDIRECT_URL_KEY = "redirect_uri";
    private static final String CODE_KEY = "code";
    private static final String STATE_KEY = "state";
    @Inject
    SlackApi slackApi;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        WebView webview = new WebView((Context)this);
        webview.setWebViewClient(new WebViewClient(){

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                if (url.startsWith(ManifestConstantsProvider.getConstantValue((Context)SlackAuthActivity.this, (String)"slack_redirect_url"))) {
                    Log.e((String)((Object)((Object)this)).getClass().getSimpleName(), (String)("url: " + url));
                    Uri uri = Uri.parse((String)url);
                    String code = uri.getQueryParameter(SlackAuthActivity.CODE_KEY);
                    view.setVisibility(8);
                    Bundle params = new Bundle();
                    params.putString(SlackAuthActivity.CODE_KEY, code);
                    SlackAuthActivity.this.getLoaderManager().restartLoader(0, params, (LoaderManager.LoaderCallbacks)SlackAuthActivity.this);
                    return true;
                }
                return super.shouldOverrideUrlLoading(view, url);
            }
        });
        Uri uri = new Uri.Builder().encodedPath(SLACK_AUTH_URL).appendQueryParameter(CLIENT_ID_KEY, ManifestConstantsProvider.getConstantValue((Context)this, (String)"slack_client_id")).appendQueryParameter(SCOPE_KEY, SCOPES).appendQueryParameter(STATE_KEY, "scanbot").appendQueryParameter(REDIRECT_URL_KEY, ManifestConstantsProvider.getConstantValue((Context)this, (String)"slack_redirect_url")).build();
        webview.loadUrl(uri.toString());
        WebSettings webSettings = webview.getSettings();
        webSettings.setJavaScriptEnabled(true);
        this.setContentView((View)webview);
    }

    public Loader<Boolean> onCreateLoader(int id2, final Bundle args) {
        return new SingleThreadLoader<Boolean>((Context)this){

            protected Boolean doInBackground() {
                String code = args.getString(SlackAuthActivity.CODE_KEY, null);
                try {
                    String token = SlackAuthActivity.this.slackApi.getToken(code);
                    if (token != null) {
                        SlackAuthActivity.this.slackApi.saveToken(token);
                        return true;
                    }
                }
                catch (IOException e) {
                    DebugLog.logException((Throwable)e);
                }
                return false;
            }
        };
    }

    public void onLoadFinished(Loader<Boolean> loader, Boolean success) {
        Intent intent = new Intent();
        NavigationUtils.deliverResultAndFinish((Activity)this, (int)(success != false ? -1 : 0), (Intent)intent);
    }

    public void onLoaderReset(Loader<Boolean> loader) {
    }
}

