/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.intelligence;

import android.content.Context;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import net.doo.datamining.AggregatedClassificationResults;
import net.doo.datamining.natalie.NatalieClassifier;
import net.doo.datamining.natalie.NatalieConfiguration;
import net.doo.datamining.natalie.NatalieLearningResult;
import net.doo.datamining.preprocessing.WordVector;
import net.doo.datamining.util.Tuple;
import net.doo.snap.blob.BlobFactory;
import net.doo.snap.entity.Blob;
import net.doo.snap.entity.DocumentType;
import net.doo.snap.entity.Language;
import net.doo.snap.intelligence.DocumentClassifier;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;

public class PFDocumentClassifier
implements DocumentClassifier {
    private static final String CLASSIFICATION_INPUT_SUFFIX = "_classificationInput";
    private static final EnumSet<Language> SUPPORTED_LANGUAGES = EnumSet.of(Language.ENG, Language.DEU);
    private static volatile SoftReference<Tuple<NatalieConfiguration, NatalieLearningResult>> cachedNatalieData = new SoftReference<Object>(null);
    @Inject
    private Context context;
    @Inject
    private BlobFactory blobFactory;
    private Language language;
    private Tuple<NatalieConfiguration, NatalieLearningResult> natalieData;

    @Inject
    public PFDocumentClassifier() {
    }

    PFDocumentClassifier(Context context, BlobFactory blobFactory) {
        this.context = context;
        this.blobFactory = blobFactory;
    }

    public boolean isLanguageSupported(@NotNull Language language) {
        return SUPPORTED_LANGUAGES.contains(language);
    }

    public synchronized void initialize(@NotNull Language language) throws IOException, IllegalStateException {
        this.language = language;
        this.natalieData = this.readNatalieBinaries(language);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public synchronized DocumentType classifyDocument(@NotNull Language language, @NotNull String content) throws IOException {
        if (this.natalieData == null || this.language != language) {
            this.initialize(language);
        }
        File tempFile = null;
        try {
            tempFile = this.writeContentToTempFile(content);
            String type = this.classifyDocumentType(tempFile, this.natalieData);
            DocumentType documentType = DocumentType.getByMimeType((String)type);
            return documentType;
        }
        finally {
            FileUtils.deleteQuietly((File)tempFile);
        }
    }

    private File writeContentToTempFile(String content) throws IOException {
        File tempFile = File.createTempFile("scanbot_", content.hashCode() + CLASSIFICATION_INPUT_SUFFIX, this.context.getExternalCacheDir());
        FileUtils.write((File)tempFile, (CharSequence)content);
        return tempFile;
    }

    private Tuple<NatalieConfiguration, NatalieLearningResult> readNatalieBinaries(Language language) throws IOException {
        Tuple<NatalieConfiguration, NatalieLearningResult> cached = cachedNatalieData.get();
        if (cached != null) {
            return cached;
        }
        Collection classifierBlobs = this.blobFactory.documentClassifierBlobs(language);
        if (classifierBlobs.isEmpty()) {
            throw new IOException("No classifier blobs available");
        }
        File natalieBinaries = new File(((Blob)classifierBlobs.iterator().next()).getLocalPath());
        Tuple results = NatalieClassifier.readBinary((File)natalieBinaries);
        cachedNatalieData = new SoftReference<Tuple>(results);
        return results;
    }

    private String classifyDocumentType(File tempFile, Tuple<NatalieConfiguration, NatalieLearningResult> resultTuple) throws IOException {
        NatalieConfiguration config = (NatalieConfiguration)resultTuple.fst;
        NatalieLearningResult learningResult = (NatalieLearningResult)resultTuple.snd;
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        for (WordVector wv : config.preprocessing.getClassificationData(Arrays.asList(tempFile), learningResult.dictionary)) {
            AggregatedClassificationResults result = config.natalie.classify(learningResult, wv);
            resultBuilder.add((Object)result);
        }
        ImmutableList result = resultBuilder.build();
        if (result.isEmpty()) {
            return null;
        }
        return (String)((AggregatedClassificationResults)result.get((int)0)).bestResult.categoryKey.fst;
    }
}

