/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.ui.upload;

import android.app.Activity;
import android.app.LoaderManager;
import android.content.Context;
import android.content.Intent;
import android.content.Loader;
import android.content.SharedPreferences;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.widget.TextView;
import com.google.inject.Inject;
import java.io.IOException;
import net.doo.snap.packageFull.R;
import net.doo.snap.ui.CustomThemeActivity;
import net.doo.snap.upload.CloudStorage;
import net.doo.snap.upload.auth.ConnectionResult;
import net.doo.snap.upload.cloud.amazon.AmazonAuthActivity;
import net.doo.snap.upload.cloud.amazon.AmazonCloudDriveApi;
import net.doo.snap.upload.cloud.amazon.ForbiddenException;
import net.doo.snap.upload.cloud.amazon.model.ProfileResponse;
import net.doo.snap.util.NavigationUtils;
import net.doo.snap.util.loading.SingleThreadLoader;
import net.doo.snap.util.log.DebugLog;

public class AmazonCloudDriveActivity
extends CustomThemeActivity
implements LoaderManager.LoaderCallbacks<ProfileResponse> {
    private static final int AMAZON_AUTH_ACTIVITY_CODE = 13220;
    private static final int AMAZON_CHOOSER_ACTIVITY_CODE = 13221;
    private static final String ACCOUNT_NAME = "ACCOUNT_NAME";
    @Inject
    private AmazonCloudDriveApi amazonCloudDriveApi;
    @Inject
    private SharedPreferences preferences;
    private String accountName;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_connect_storage);
        ((TextView)this.findViewById(R.id.connect_description)).setText((CharSequence)this.getString(R.string.connect_source_description, new Object[]{this.getString(CloudStorage.AMAZON_CLOUD_DRIVE.getNameResource())}));
        if (savedInstanceState != null) {
            this.accountName = savedInstanceState.getString(ACCOUNT_NAME);
        }
        if (TextUtils.isEmpty((CharSequence)this.accountName)) {
            Intent intent = new Intent((Context)this, AmazonAuthActivity.class);
            this.startActivityForResult(intent, 13220);
        } else {
            this.deliverConnectionResult(new ConnectionResult(true, CloudStorage.AMAZON_CLOUD_DRIVE, this.accountName));
        }
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putString(ACCOUNT_NAME, this.accountName);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 13220) {
            if (resultCode == -1) {
                this.getLoaderManager().restartLoader(0, null, (LoaderManager.LoaderCallbacks)this);
            } else {
                this.deliverConnectionResult(new ConnectionResult(false, CloudStorage.AMAZON_CLOUD_DRIVE, null));
            }
        } else if (requestCode == 13221) {
            if (resultCode != -1) {
                Uri folderUri = new Uri.Builder().appendQueryParameter("folder_name", "Scanbot").build();
                SharedPreferences.Editor edit = this.preferences.edit();
                edit.putString(CloudStorage.AMAZON_CLOUD_DRIVE.getDefaultFolderKey(), folderUri.toString());
                edit.apply();
            }
            this.deliverConnectionResult(new ConnectionResult(true, CloudStorage.AMAZON_CLOUD_DRIVE, this.accountName));
        }
    }

    private void deliverConnectionResult(ConnectionResult result) {
        Intent intent = new Intent();
        intent.putExtra("CONNECTION_EXTRA", (Parcelable)result);
        NavigationUtils.deliverResultAndFinish((Activity)this, (int)-1, (Intent)intent);
    }

    public Loader<ProfileResponse> onCreateLoader(int id2, Bundle args) {
        return new SingleThreadLoader<ProfileResponse>((Context)this){

            protected ProfileResponse doInBackground() {
                try {
                    return AmazonCloudDriveActivity.this.amazonCloudDriveApi.getProfile();
                }
                catch (IOException | ForbiddenException e) {
                    DebugLog.logException((Throwable)e);
                    return null;
                }
            }
        };
    }

    public void onLoadFinished(Loader loader, ProfileResponse profile) {
        if (profile != null) {
            this.accountName = profile.getEmail();
            this.preferences.edit().remove(CloudStorage.AMAZON_CLOUD_DRIVE.getDefaultFolderKey()).apply();
            this.startActivityForResult(new Intent((Context)this, CloudStorage.getChooserActivity(CloudStorage.AMAZON_CLOUD_DRIVE)), 13221);
        } else {
            this.deliverConnectionResult(new ConnectionResult(false, CloudStorage.AMAZON_CLOUD_DRIVE, null));
        }
    }

    public void onLoaderReset(Loader loader) {
    }
}

