/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.ui.upload;

import android.app.Activity;
import android.app.LoaderManager;
import android.content.Context;
import android.content.Intent;
import android.content.Loader;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.widget.TextView;
import com.google.inject.Inject;
import java.io.IOException;
import net.doo.snap.packageFull.R;
import net.doo.snap.ui.CustomThemeActivity;
import net.doo.snap.upload.CloudStorage;
import net.doo.snap.upload.auth.ConnectionResult;
import net.doo.snap.upload.cloud.slack.SlackApi;
import net.doo.snap.upload.cloud.slack.SlackAuthActivity;
import net.doo.snap.upload.cloud.slack.model.ProfileResponse;
import net.doo.snap.util.NavigationUtils;
import net.doo.snap.util.loading.SingleThreadLoader;
import net.doo.snap.util.log.DebugLog;

public class SlackActivity
extends CustomThemeActivity
implements LoaderManager.LoaderCallbacks<ProfileResponse> {
    private static final int SLACK_AUTH_ACTIVITY_CODE = 7527;
    private static final int SLACK_CHOOSER_ACTIVITY_CODE = 26261;
    private static final String ACCOUNT_NAME = "ACCOUNT_NAME";
    private String accountName;
    @Inject
    SlackApi slackApi;
    @Inject
    private SharedPreferences preferences;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_connect_storage);
        ((TextView)this.findViewById(R.id.connect_description)).setText((CharSequence)this.getString(R.string.connect_source_description, new Object[]{this.getString(CloudStorage.SLACK.getNameResource())}));
        if (savedInstanceState != null) {
            this.accountName = savedInstanceState.getString(ACCOUNT_NAME);
        }
        if (TextUtils.isEmpty((CharSequence)this.accountName)) {
            Intent intent = new Intent((Context)this, SlackAuthActivity.class);
            this.startActivityForResult(intent, 7527);
        } else {
            this.deliverConnectionResult(new ConnectionResult(true, CloudStorage.SLACK, this.accountName));
        }
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putString(ACCOUNT_NAME, this.accountName);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 7527) {
            if (resultCode == -1) {
                this.startActivityForResult(new Intent((Context)this, CloudStorage.getChooserActivity(CloudStorage.SLACK)), 26261);
            } else {
                this.deliverConnectionResult(new ConnectionResult(false, CloudStorage.SLACK, null));
            }
        } else if (requestCode == 26261) {
            if (resultCode == -1) {
                this.deliverConnectionResult(new ConnectionResult(true, CloudStorage.SLACK, this.accountName));
            } else {
                this.deliverConnectionResult(new ConnectionResult(false, CloudStorage.SLACK, null));
            }
        }
    }

    private void deliverConnectionResult(ConnectionResult result) {
        Intent intent = new Intent();
        intent.putExtra("CONNECTION_EXTRA", (Parcelable)result);
        NavigationUtils.deliverResultAndFinish((Activity)this, (int)-1, (Intent)intent);
    }

    public Loader<ProfileResponse> onCreateLoader(int id2, Bundle args) {
        return new SingleThreadLoader<ProfileResponse>((Context)this){

            protected ProfileResponse doInBackground() {
                try {
                    return SlackActivity.this.slackApi.getProfile();
                }
                catch (IOException e) {
                    DebugLog.logException((Throwable)e);
                    return null;
                }
            }
        };
    }

    public void onLoadFinished(Loader loader, ProfileResponse profile) {
        if (profile != null && profile.isOk()) {
            this.accountName = profile.getUser();
            this.preferences.edit().remove(CloudStorage.SLACK.getDefaultFolderKey()).apply();
            this.startActivityForResult(new Intent((Context)this, CloudStorage.getChooserActivity(CloudStorage.SLACK)), 26261);
        } else {
            this.deliverConnectionResult(new ConnectionResult(false, CloudStorage.SLACK, null));
        }
    }

    public void onLoaderReset(Loader loader) {
    }
}

