/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.di.components;

import android.app.Activity;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dagger.internal.DoubleCheck;
import dagger.internal.Preconditions;
import io.reactivex.Scheduler;
import io.scanbot.sdk.persistance.DraftPagesRepository;
import io.scanbot.sdk.persistance.PageProcessorInteractor;
import io.scanbot.sdk.persistance.PageStorage;
import io.scanbot.sdk.persistance.PageStorageSettings;
import io.scanbot.sdk.ui.di.components.ActivityComponent;
import io.scanbot.sdk.ui.di.components.CameraComponent;
import io.scanbot.sdk.ui.di.modules.NavigatorModule;
import io.scanbot.sdk.ui.di.modules.NavigatorModule_ProvidesNavigatorFactory;
import io.scanbot.sdk.ui.utils.navigator.Navigator;
import io.scanbot.sdk.ui.view.camera.CameraFragment;
import io.scanbot.sdk.ui.view.camera.CameraFragment_MembersInjector;
import io.scanbot.sdk.ui.view.camera.CameraPresenter;
import io.scanbot.sdk.ui.view.interactor.CheckCameraPermissionUseCase;
import io.scanbot.sdk.ui.view.interactor.SaveTakenPictureUseCase;
import javax.inject.Provider;

public final class DaggerCameraComponent
implements CameraComponent {
    private ActivityComponent activityComponent;
    private Provider<Navigator> providesNavigatorProvider;

    private DaggerCameraComponent(Builder builder) {
        this.initialize(builder);
    }

    public static Builder builder() {
        return new Builder();
    }

    private CheckCameraPermissionUseCase getCheckCameraPermissionUseCase() {
        return new CheckCameraPermissionUseCase((Activity)Preconditions.checkNotNull((Object)this.activityComponent.activity(), (String)"Cannot return null from a non-@Nullable component method"));
    }

    private PageProcessorInteractor getPageProcessorInteractor() {
        return new PageProcessorInteractor((PageStorage)Preconditions.checkNotNull((Object)this.activityComponent.pageStorage(), (String)"Cannot return null from a non-@Nullable component method"), (PageStorageSettings)Preconditions.checkNotNull((Object)this.activityComponent.pageStorageSettings(), (String)"Cannot return null from a non-@Nullable component method"));
    }

    private DraftPagesRepository getDraftPagesRepository() {
        return new DraftPagesRepository(this.getPageProcessorInteractor());
    }

    private SaveTakenPictureUseCase getSaveTakenPictureUseCase() {
        return new SaveTakenPictureUseCase(this.getDraftPagesRepository());
    }

    private CameraPresenter getCameraPresenter() {
        return new CameraPresenter(this.getCheckCameraPermissionUseCase(), this.getSaveTakenPictureUseCase(), (PageStorageSettings)Preconditions.checkNotNull((Object)this.activityComponent.pageStorageSettings(), (String)"Cannot return null from a non-@Nullable component method"), (Navigator)this.providesNavigatorProvider.get(), (Scheduler)Preconditions.checkNotNull((Object)this.activityComponent.provideBackgroundTaskScheduler(), (String)"Cannot return null from a non-@Nullable component method"), (Scheduler)Preconditions.checkNotNull((Object)this.activityComponent.provideUiScheduler(), (String)"Cannot return null from a non-@Nullable component method"));
    }

    private void initialize(Builder builder) {
        this.activityComponent = builder.activityComponent;
        this.providesNavigatorProvider = DoubleCheck.provider((Provider)NavigatorModule_ProvidesNavigatorFactory.create(builder.navigatorModule));
    }

    @Override
    public void inject(CameraFragment cameraFragment) {
        this.injectCameraFragment(cameraFragment);
    }

    @CanIgnoreReturnValue
    private CameraFragment injectCameraFragment(CameraFragment instance) {
        CameraFragment_MembersInjector.injectCheckCameraPermissionUseCase(instance, this.getCheckCameraPermissionUseCase());
        CameraFragment_MembersInjector.injectCameraPresenter(instance, this.getCameraPresenter());
        return instance;
    }

    public static final class Builder {
        private NavigatorModule navigatorModule;
        private ActivityComponent activityComponent;

        private Builder() {
        }

        public CameraComponent build() {
            if (this.navigatorModule == null) {
                throw new IllegalStateException(NavigatorModule.class.getCanonicalName() + " must be set");
            }
            if (this.activityComponent == null) {
                throw new IllegalStateException(ActivityComponent.class.getCanonicalName() + " must be set");
            }
            return new DaggerCameraComponent(this);
        }

        public Builder navigatorModule(NavigatorModule navigatorModule) {
            this.navigatorModule = (NavigatorModule)Preconditions.checkNotNull((Object)navigatorModule);
            return this;
        }

        public Builder activityComponent(ActivityComponent activityComponent2) {
            this.activityComponent = (ActivityComponent)Preconditions.checkNotNull((Object)activityComponent2);
            return this;
        }
    }
}

